/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.io.Serializable;

public class AS400Certificate
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private byte[] certificate_;
    private String info_;
    private byte[] byteData_;

    public AS400Certificate() {
    }

    public AS400Certificate(byte[] byArray) {
        this.certificate_ = byArray;
    }

    public byte[] getByteInfo() {
        return this.byteData_;
    }

    public byte[] getEncoded() {
        int n = this.getLength(this.certificate_);
        if (n != this.certificate_.length) {
            byte[] byArray = this.certificate_;
            this.certificate_ = new byte[n];
            System.arraycopy(byArray, 0, this.certificate_, 0, n);
        }
        return this.certificate_;
    }

    public String getInfo() {
        return this.info_;
    }

    public void setByteInfo(byte[] byArray) {
        this.byteData_ = byArray;
    }

    public void setEncoded(byte[] byArray) {
        this.certificate_ = byArray;
    }

    public void setInfo(String string) {
        this.info_ = string;
    }

    private int getLength(byte[] byArray) {
        int n;
        int n2 = byArray[1];
        int n3 = 2;
        if (0 == (byArray[1] & 0x80)) {
            n = byArray[1];
        } else {
            n2 &= 0x7F;
            n = 0;
            int n4 = 2;
            while (n2 > 0) {
                n <<= 8;
                n += byArray[n4] & 0xFF;
                ++n3;
                --n2;
                ++n4;
            }
        }
        return n + n3;
    }
}

