/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.transforms;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class ConnectRecordValueToMapTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELD_KEY_CONFIG = "key";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("key", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Transforms String-based content from Kafka into a map");
    private String key;

    public R apply(R r) {
        HashMap<String, Object> targetMap = new HashMap<String, Object>();
        Object value = r.value();
        targetMap.put(this.key, value);
        return (R)r.newRecord(r.topic(), r.kafkaPartition(), null, r.key(), (Schema)SchemaHelper.buildSchemaBuilderForType(value), targetMap, r.timestamp());
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, map);
        this.key = config.getString(FIELD_KEY_CONFIG);
        if (this.key == null) {
            throw new ConfigException("The ConnectRecordValueToMapTransforms transformer requires a 'key'");
        }
    }
}

