/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.utils;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.slf4j.Logger;

public final class TaskHelper {
    private TaskHelper() {
    }

    public static String buildUrl(CamelContext camelContext, Map<String, String> props, String componentSchema, String endpointPropertiesPrefix, String pathPropertiesPrefix) throws URISyntaxException {
        Map<String, Object> filteredProps = props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(endpointPropertiesPrefix) || ((String)e.getKey()).startsWith(pathPropertiesPrefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).replace(endpointPropertiesPrefix, "").replace(pathPropertiesPrefix, ""), Map.Entry::getValue));
        EndpointUriFactory factory = camelContext.getCamelContextExtension().getEndpointUriFactory(componentSchema);
        if (factory == null) {
            throw new IllegalStateException("Unable to compute endpoint uri. Reason: uri factory for schema `" + componentSchema + "` not found");
        }
        if (!factory.isEnabled(componentSchema)) {
            throw new IllegalStateException("Unable to compute endpoint uri. Reason: uri factory for schema `" + componentSchema + "` not enabled");
        }
        return factory.buildUri(componentSchema, filteredProps, false);
    }

    public static Map<String, String> combineDefaultAndLoadedProperties(Map<String, String> defaultProps, Map<String, String> loadedProps) {
        if (loadedProps == null && defaultProps == null) {
            return Collections.emptyMap();
        }
        if (loadedProps == null) {
            return new HashMap<String, String>(defaultProps);
        }
        if (defaultProps == null) {
            return new HashMap<String, String>(loadedProps);
        }
        HashMap<String, String> result = new HashMap<String, String>(loadedProps);
        defaultProps.keySet().stream().filter(k -> TaskHelper.stringStartWithOneOfPrefixes(k, loadedProps.keySet()) == false).filter(k -> !result.containsKey(k)).forEach(k -> result.put((String)k, (String)defaultProps.get(k)));
        return result;
    }

    private static Boolean stringStartWithOneOfPrefixes(String s, Set<String> prefixes) {
        if (s == null || prefixes == null) {
            return false;
        }
        for (String p : prefixes) {
            if (!s.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public static void logRecordContent(Logger logger, LoggingLevel level, ConnectRecord<?> record) {
        if (level == LoggingLevel.OFF) {
            return;
        }
        switch (level) {
            case TRACE: {
                logger.trace(record.toString());
                break;
            }
            case DEBUG: {
                logger.debug(record.toString());
                break;
            }
            case INFO: {
                logger.info(record.toString());
                break;
            }
            case WARN: {
                logger.warn(record.toString());
                break;
            }
            case ERROR: {
                logger.error(record.toString());
                break;
            }
        }
    }
}

