/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kafka.KafkaHeaderFilterStrategy;
import org.apache.camel.component.kafka.serde.DefaultKafkaHeaderDeserializer;
import org.apache.camel.component.kafka.serde.DefaultKafkaHeaderSerializer;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.jsse.CipherSuitesParameters;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.SecureSocketProtocolsParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class KafkaConfiguration
implements Cloneable,
HeaderFilterStrategyAware {
    @UriPath(label="common")
    @Metadata(required=true)
    private String topic;
    @UriParam(label="common")
    private String brokers;
    @UriParam(label="common")
    private String clientId;
    @UriParam(label="common", description="To use a custom HeaderFilterStrategy to filter header to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy = new KafkaHeaderFilterStrategy();
    @UriParam(label="consumer")
    private boolean topicIsPattern;
    @UriParam(label="consumer")
    private String groupId;
    @UriParam(label="consumer", defaultValue="10")
    private int consumerStreams = 10;
    @UriParam(label="consumer", defaultValue="1")
    private int consumersCount = 1;
    @UriParam(label="consumer", description="To use a custom KafkaHeaderDeserializer to deserialize kafka headers values")
    private KafkaHeaderDeserializer kafkaHeaderDeserializer = new DefaultKafkaHeaderDeserializer();
    @UriParam(label="common,monitoring")
    private String interceptorClasses;
    @UriParam(label="consumer", defaultValue="org.apache.kafka.common.serialization.StringDeserializer")
    private String keyDeserializer = "org.apache.kafka.common.serialization.StringDeserializer";
    @UriParam(label="consumer", defaultValue="org.apache.kafka.common.serialization.StringDeserializer")
    private String valueDeserializer = "org.apache.kafka.common.serialization.StringDeserializer";
    @UriParam(label="consumer", defaultValue="1")
    private Integer fetchMinBytes = 1;
    @UriParam(label="consumer", defaultValue="52428800")
    private Integer fetchMaxBytes = 0x3200000;
    @UriParam(label="consumer", defaultValue="3000")
    private Integer heartbeatIntervalMs = 3000;
    @UriParam(label="consumer", defaultValue="1048576")
    private Integer maxPartitionFetchBytes = 0x100000;
    @UriParam(label="consumer", defaultValue="10000")
    private Integer sessionTimeoutMs = 10000;
    @UriParam(label="consumer", defaultValue="500")
    private Integer maxPollRecords;
    @UriParam(label="consumer", defaultValue="5000")
    private Long pollTimeoutMs = 5000L;
    @UriParam(label="consumer")
    private Long maxPollIntervalMs;
    @UriParam(label="consumer", defaultValue="latest", enums="latest,earliest,none")
    private String autoOffsetReset = "latest";
    @UriParam(label="consumer", defaultValue="org.apache.kafka.clients.consumer.RangeAssignor")
    private String partitionAssignor = "org.apache.kafka.clients.consumer.RangeAssignor";
    @UriParam(label="consumer", defaultValue="40000")
    private Integer consumerRequestTimeoutMs = 40000;
    @UriParam(label="consumer", defaultValue="5000")
    private Integer autoCommitIntervalMs = 5000;
    @UriParam(label="consumer", defaultValue="true")
    private Boolean checkCrcs = true;
    @UriParam(label="consumer", defaultValue="500")
    private Integer fetchWaitMaxMs = 500;
    @UriParam(label="consumer", enums="beginning,end")
    private String seekTo;
    @UriParam(label="consumer", defaultValue="true")
    private Boolean autoCommitEnable = true;
    @UriParam(label="consumer")
    private boolean allowManualCommit;
    @UriParam(label="consumer", defaultValue="sync", enums="sync,async,none")
    private String autoCommitOnStop = "sync";
    @UriParam(label="consumer")
    private boolean breakOnFirstError;
    @UriParam(label="consumer")
    private StateRepository<String, String> offsetRepository;
    @UriParam(label="producer", defaultValue="org.apache.kafka.clients.producer.internals.DefaultPartitioner")
    private String partitioner = "org.apache.kafka.clients.producer.internals.DefaultPartitioner";
    @UriParam(label="producer", defaultValue="100")
    private Integer retryBackoffMs = 100;
    @UriParam(label="producer")
    private ExecutorService workerPool;
    @UriParam(label="producer", defaultValue="10")
    private Integer workerPoolCoreSize = 10;
    @UriParam(label="producer", defaultValue="20")
    private Integer workerPoolMaxSize = 20;
    @UriParam(label="producer", defaultValue="10000")
    private Integer queueBufferingMaxMessages = 10000;
    @UriParam(label="producer", defaultValue="org.apache.kafka.common.serialization.StringSerializer")
    private String serializerClass = "org.apache.kafka.common.serialization.StringSerializer";
    @UriParam(label="producer", defaultValue="org.apache.kafka.common.serialization.StringSerializer")
    private String keySerializerClass = "org.apache.kafka.common.serialization.StringSerializer";
    @UriParam(label="producer")
    private String key;
    @UriParam(label="producer")
    private Integer partitionKey;
    @UriParam(label="producer", enums="-1,0,1,all", defaultValue="1")
    private String requestRequiredAcks = "1";
    @UriParam(label="producer", defaultValue="33554432")
    private Integer bufferMemorySize = 0x2000000;
    @UriParam(label="producer", defaultValue="none", enums="none,gzip,snappy,lz4")
    private String compressionCodec = "none";
    @UriParam(label="producer", defaultValue="0")
    private Integer retries = 0;
    @UriParam(label="producer", defaultValue="16384")
    private Integer producerBatchSize = 16384;
    @UriParam(label="producer", defaultValue="540000")
    private Integer connectionMaxIdleMs = 540000;
    @UriParam(label="producer", defaultValue="0")
    private Integer lingerMs = 0;
    @UriParam(label="producer", defaultValue="60000")
    private Integer maxBlockMs = 60000;
    @UriParam(label="producer", defaultValue="1048576")
    private Integer maxRequestSize = 0x100000;
    @UriParam(label="producer", defaultValue="65536")
    private Integer receiveBufferBytes = 65536;
    @UriParam(label="producer", defaultValue="30000")
    private Integer requestTimeoutMs = 30000;
    @UriParam(label="producer", defaultValue="131072")
    private Integer sendBufferBytes = 131072;
    @UriParam(label="producer", defaultValue="true")
    private boolean recordMetadata = true;
    @UriParam(label="producer", defaultValue="5")
    private Integer maxInFlightRequest = 5;
    @UriParam(label="producer", defaultValue="300000")
    private Integer metadataMaxAgeMs = 300000;
    @UriParam(label="producer")
    private String metricReporters;
    @UriParam(label="producer", defaultValue="2")
    private Integer noOfMetricsSample = 2;
    @UriParam(label="producer", defaultValue="30000")
    private Integer metricsSampleWindowMs = 30000;
    @UriParam(label="producer", defaultValue="50")
    private Integer reconnectBackoffMs = 50;
    @UriParam(label="producer", defaultValue="false")
    private boolean enableIdempotence;
    @UriParam(label="producer", description="To use a custom KafkaHeaderSerializer to serialize kafka headers values")
    private KafkaHeaderSerializer kafkaHeaderSerializer = new DefaultKafkaHeaderSerializer();
    @UriParam(label="common", defaultValue="1000")
    private Integer reconnectBackoffMaxMs = 1000;
    @UriParam(label="common,security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="producer,security", secret=true)
    private String sslKeyPassword;
    @UriParam(label="producer,security")
    private String sslKeystoreLocation;
    @UriParam(label="producer,security", secret=true)
    private String sslKeystorePassword;
    @UriParam(label="producer,security")
    private String sslTruststoreLocation;
    @UriParam(label="producer,security", secret=true)
    private String sslTruststorePassword;
    @UriParam(label="common,security", defaultValue="TLSv1.2")
    private String sslEnabledProtocols = "TLSv1.2";
    @UriParam(label="common,security", defaultValue="JKS")
    private String sslKeystoreType = "JKS";
    @UriParam(label="common,security", defaultValue="TLSv1.2")
    private String sslProtocol = "TLSv1.2";
    @UriParam(label="common,security")
    private String sslProvider;
    @UriParam(label="common,security", defaultValue="JKS")
    private String sslTruststoreType = "JKS";
    @UriParam(label="common,security")
    private String sslCipherSuites;
    @UriParam(label="common,security")
    private String sslEndpointAlgorithm;
    @UriParam(label="common,security", defaultValue="SunX509")
    private String sslKeymanagerAlgorithm = "SunX509";
    @UriParam(label="common,security", defaultValue="PKIX")
    private String sslTrustmanagerAlgorithm = "PKIX";
    @UriParam(label="common,security")
    private String saslKerberosServiceName;
    @UriParam(label="common,security", defaultValue="PLAINTEXT")
    private String securityProtocol = "PLAINTEXT";
    @UriParam(label="common,security", defaultValue="GSSAPI")
    private String saslMechanism = "GSSAPI";
    @UriParam(label="common,security", defaultValue="/usr/bin/kinit")
    private String kerberosInitCmd = "/usr/bin/kinit";
    @UriParam(label="common,security", defaultValue="60000")
    private Integer kerberosBeforeReloginMinTime = 60000;
    @UriParam(label="common,security", defaultValue="0.05")
    private Double kerberosRenewJitter = 0.05;
    @UriParam(label="common,security", defaultValue="0.8")
    private Double kerberosRenewWindowFactor = 0.8;
    @UriParam(label="common,security", defaultValue="DEFAULT")
    private String kerberosPrincipalToLocalRules;
    @UriParam(label="common,security", secret=true)
    private String saslJaasConfig;
    @UriParam(label="confluent")
    private String schemaRegistryURL;
    @UriParam(label="confluent,consumer")
    private boolean specificAvroReader;
    @UriParam(label="common", prefix="additionalProperties.", multiValue=true)
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @UriParam(label="common", defaultValue="30000")
    private int shutdownTimeout = 30000;

    public KafkaConfiguration copy() {
        try {
            KafkaConfiguration copy = (KafkaConfiguration)this.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public Properties createProducerProperties() {
        Properties props = new Properties();
        KafkaConfiguration.addPropertyIfNotNull(props, "key.serializer", this.getKeySerializerClass());
        KafkaConfiguration.addPropertyIfNotNull(props, "value.serializer", this.getSerializerClass());
        KafkaConfiguration.addPropertyIfNotNull(props, "acks", this.getRequestRequiredAcks());
        KafkaConfiguration.addPropertyIfNotNull(props, "buffer.memory", this.getBufferMemorySize());
        KafkaConfiguration.addPropertyIfNotNull(props, "compression.type", this.getCompressionCodec());
        KafkaConfiguration.addPropertyIfNotNull(props, "retries", this.getRetries());
        KafkaConfiguration.addPropertyIfNotNull(props, "interceptor.classes", this.getInterceptorClasses());
        KafkaConfiguration.addPropertyIfNotNull(props, "batch.size", this.getProducerBatchSize());
        KafkaConfiguration.addPropertyIfNotNull(props, "client.id", this.getClientId());
        KafkaConfiguration.addPropertyIfNotNull(props, "connections.max.idle.ms", this.getConnectionMaxIdleMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "linger.ms", this.getLingerMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.block.ms", this.getMaxBlockMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.request.size", this.getMaxRequestSize());
        KafkaConfiguration.addPropertyIfNotNull(props, "partitioner.class", this.getPartitioner());
        KafkaConfiguration.addPropertyIfNotNull(props, "receive.buffer.bytes", this.getReceiveBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "request.timeout.ms", this.getRequestTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "send.buffer.bytes", this.getSendBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.in.flight.requests.per.connection", this.getMaxInFlightRequest());
        KafkaConfiguration.addPropertyIfNotNull(props, "metadata.max.age.ms", this.getMetadataMaxAgeMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "metric.reporters", this.getMetricReporters());
        KafkaConfiguration.addPropertyIfNotNull(props, "metrics.num.samples", this.getNoOfMetricsSample());
        KafkaConfiguration.addPropertyIfNotNull(props, "metrics.sample.window.ms", this.getMetricsSampleWindowMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.ms", this.getReconnectBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "retry.backoff.ms", this.getRetryBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "enable.idempotence", this.isEnableIdempotence());
        KafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.max.ms", this.getReconnectBackoffMaxMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "schema.registry.url", this.getSchemaRegistryURL());
        this.applySslConfiguration(props, this.getSslContextParameters());
        KafkaConfiguration.addPropertyIfNotNull(props, "security.protocol", this.getSecurityProtocol());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.key.password", this.getSslKeyPassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.location", this.getSslKeystoreLocation());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.password", this.getSslKeystorePassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.location", this.getSslTruststoreLocation());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.password", this.getSslTruststorePassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.enabled.protocols", this.getSslEnabledProtocols());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.type", this.getSslKeystoreType());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.protocol", this.getSslProtocol());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.provider", this.getSslProvider());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.type", this.getSslTruststoreType());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.cipher.suites", this.getSslCipherSuites());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.endpoint.identification.algorithm", this.getSslEndpointAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keymanager.algorithm", this.getSslKeymanagerAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.trustmanager.algorithm", this.getSslTrustmanagerAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.service.name", this.getSaslKerberosServiceName());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.kinit.cmd", this.getKerberosInitCmd());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.min.time.before.relogin", this.getKerberosBeforeReloginMinTime());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.jitter", this.getKerberosRenewJitter());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.window.factor", this.getKerberosRenewWindowFactor());
        KafkaConfiguration.addListPropertyIfNotNull(props, "sasl.kerberos.principal.to.local.rules", this.getKerberosPrincipalToLocalRules());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.mechanism", this.getSaslMechanism());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.jaas.config", this.getSaslJaasConfig());
        this.applyAdditionalProperties(props, this.getAdditionalProperties());
        return props;
    }

    public Properties createConsumerProperties() {
        Properties props = new Properties();
        KafkaConfiguration.addPropertyIfNotNull(props, "key.deserializer", this.getKeyDeserializer());
        KafkaConfiguration.addPropertyIfNotNull(props, "value.deserializer", this.getValueDeserializer());
        KafkaConfiguration.addPropertyIfNotNull(props, "fetch.min.bytes", this.getFetchMinBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "fetch.max.bytes", this.getFetchMaxBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "heartbeat.interval.ms", this.getHeartbeatIntervalMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.partition.fetch.bytes", this.getMaxPartitionFetchBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "session.timeout.ms", this.getSessionTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.poll.interval.ms", this.getMaxPollIntervalMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "max.poll.records", this.getMaxPollRecords());
        KafkaConfiguration.addPropertyIfNotNull(props, "interceptor.classes", this.getInterceptorClasses());
        KafkaConfiguration.addPropertyIfNotNull(props, "auto.offset.reset", this.getAutoOffsetReset());
        KafkaConfiguration.addPropertyIfNotNull(props, "connections.max.idle.ms", this.getConnectionMaxIdleMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "enable.auto.commit", this.getAutoCommitEnable());
        KafkaConfiguration.addPropertyIfNotNull(props, "partition.assignment.strategy", this.getPartitionAssignor());
        KafkaConfiguration.addPropertyIfNotNull(props, "receive.buffer.bytes", this.getReceiveBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "request.timeout.ms", this.getConsumerRequestTimeoutMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "auto.commit.interval.ms", this.getAutoCommitIntervalMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "check.crcs", this.getCheckCrcs());
        KafkaConfiguration.addPropertyIfNotNull(props, "client.id", this.getClientId());
        KafkaConfiguration.addPropertyIfNotNull(props, "fetch.max.wait.ms", this.getFetchWaitMaxMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "metadata.max.age.ms", this.getMetadataMaxAgeMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "metric.reporters", this.getMetricReporters());
        KafkaConfiguration.addPropertyIfNotNull(props, "metrics.num.samples", this.getNoOfMetricsSample());
        KafkaConfiguration.addPropertyIfNotNull(props, "metrics.sample.window.ms", this.getMetricsSampleWindowMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.ms", this.getReconnectBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "retry.backoff.ms", this.getRetryBackoffMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.max.ms", this.getReconnectBackoffMaxMs());
        KafkaConfiguration.addPropertyIfNotNull(props, "schema.registry.url", this.getSchemaRegistryURL());
        KafkaConfiguration.addPropertyIfNotNull(props, "specific.avro.reader", this.isSpecificAvroReader());
        this.applySslConfiguration(props, this.getSslContextParameters());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.key.password", this.getSslKeyPassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.location", this.getSslKeystoreLocation());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.password", this.getSslKeystorePassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.location", this.getSslTruststoreLocation());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.password", this.getSslTruststorePassword());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.cipher.suites", this.getSslCipherSuites());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.endpoint.identification.algorithm", this.getSslEndpointAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keymanager.algorithm", this.getSslKeymanagerAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.trustmanager.algorithm", this.getSslTrustmanagerAlgorithm());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.enabled.protocols", this.getSslEnabledProtocols());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.type", this.getSslKeystoreType());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.protocol", this.getSslProtocol());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.provider", this.getSslProvider());
        KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.type", this.getSslTruststoreType());
        KafkaConfiguration.addPropertyIfNotNull(props, "security.protocol", this.getSecurityProtocol());
        KafkaConfiguration.addPropertyIfNotNull(props, "send.buffer.bytes", this.getSendBufferBytes());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.service.name", this.getSaslKerberosServiceName());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.kinit.cmd", this.getKerberosInitCmd());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.min.time.before.relogin", this.getKerberosBeforeReloginMinTime());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.jitter", this.getKerberosRenewJitter());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.window.factor", this.getKerberosRenewWindowFactor());
        KafkaConfiguration.addListPropertyIfNotNull(props, "sasl.kerberos.principal.to.local.rules", this.getKerberosPrincipalToLocalRules());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.mechanism", this.getSaslMechanism());
        KafkaConfiguration.addPropertyIfNotNull(props, "sasl.jaas.config", this.getSaslJaasConfig());
        this.applyAdditionalProperties(props, this.getAdditionalProperties());
        return props;
    }

    private void applySslConfiguration(Properties props, SSLContextParameters sslContextParameters) {
        if (sslContextParameters != null) {
            TrustManagersParameters trustManagers;
            KeyManagersParameters keyManagers;
            SecureSocketProtocolsParameters secureSocketProtocols;
            KafkaConfiguration.addPropertyIfNotNull(props, "ssl.protocol", sslContextParameters.getSecureSocketProtocol());
            KafkaConfiguration.addPropertyIfNotNull(props, "ssl.provider", sslContextParameters.getProvider());
            CipherSuitesParameters cipherSuites = sslContextParameters.getCipherSuites();
            if (cipherSuites != null) {
                KafkaConfiguration.addCommaSeparatedList(props, "ssl.cipher.suites", cipherSuites.getCipherSuite());
            }
            if ((secureSocketProtocols = sslContextParameters.getSecureSocketProtocols()) != null) {
                KafkaConfiguration.addCommaSeparatedList(props, "ssl.enabled.protocols", secureSocketProtocols.getSecureSocketProtocol());
            }
            if ((keyManagers = sslContextParameters.getKeyManagers()) != null) {
                KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keymanager.algorithm", keyManagers.getAlgorithm());
                KafkaConfiguration.addPropertyIfNotNull(props, "ssl.key.password", keyManagers.getKeyPassword());
                KeyStoreParameters keyStore = keyManagers.getKeyStore();
                if (keyStore != null) {
                    KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.type", keyStore.getType());
                    KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.location", keyStore.getResource());
                    KafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.password", keyStore.getPassword());
                }
            }
            if ((trustManagers = sslContextParameters.getTrustManagers()) != null) {
                KafkaConfiguration.addPropertyIfNotNull(props, "ssl.trustmanager.algorithm", trustManagers.getAlgorithm());
                KeyStoreParameters keyStore = trustManagers.getKeyStore();
                if (keyStore != null) {
                    KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.type", keyStore.getType());
                    KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.location", keyStore.getResource());
                    KafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.password", keyStore.getPassword());
                }
            }
        }
    }

    private void applyAdditionalProperties(Properties props, Map<String, Object> additionalProperties) {
        if (!ObjectHelper.isEmpty(this.getAdditionalProperties())) {
            additionalProperties.forEach((property, value) -> KafkaConfiguration.addPropertyIfNotNull(props, property, value));
        }
    }

    private static <T> void addPropertyIfNotNull(Properties props, String key, T value) {
        if (value != null) {
            props.put(key, value.toString());
        }
    }

    private static <T> void addListPropertyIfNotNull(Properties props, String key, T value) {
        if (value != null) {
            String[] values = value.toString().split(",");
            List<String> list = Arrays.asList(values);
            props.put(key, list);
        }
    }

    private static void addCommaSeparatedList(Properties props, String key, List<String> values) {
        if (values != null && !values.isEmpty()) {
            props.put(key, values.stream().collect(Collectors.joining(",")));
        }
    }

    public boolean isTopicIsPattern() {
        return this.topicIsPattern;
    }

    public void setTopicIsPattern(boolean topicIsPattern) {
        this.topicIsPattern = topicIsPattern;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(String partitioner) {
        this.partitioner = partitioner;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getConsumerStreams() {
        return this.consumerStreams;
    }

    public void setConsumerStreams(int consumerStreams) {
        this.consumerStreams = consumerStreams;
    }

    public int getConsumersCount() {
        return this.consumersCount;
    }

    public void setConsumersCount(int consumersCount) {
        this.consumersCount = consumersCount;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isAutoCommitEnable() {
        return this.offsetRepository == null ? this.autoCommitEnable : false;
    }

    public Boolean getAutoCommitEnable() {
        return this.autoCommitEnable;
    }

    public void setAutoCommitEnable(Boolean autoCommitEnable) {
        this.autoCommitEnable = autoCommitEnable;
    }

    public boolean isAllowManualCommit() {
        return this.allowManualCommit;
    }

    public void setAllowManualCommit(boolean allowManualCommit) {
        this.allowManualCommit = allowManualCommit;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public StateRepository<String, String> getOffsetRepository() {
        return this.offsetRepository;
    }

    public void setOffsetRepository(StateRepository<String, String> offsetRepository) {
        this.offsetRepository = offsetRepository;
    }

    public Integer getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public void setAutoCommitIntervalMs(Integer autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
    }

    public Integer getFetchMinBytes() {
        return this.fetchMinBytes;
    }

    public void setFetchMinBytes(Integer fetchMinBytes) {
        this.fetchMinBytes = fetchMinBytes;
    }

    public Integer getFetchMaxBytes() {
        return this.fetchMaxBytes;
    }

    public void setFetchMaxBytes(Integer fetchMaxBytes) {
        this.fetchMaxBytes = fetchMaxBytes;
    }

    public Integer getFetchWaitMaxMs() {
        return this.fetchWaitMaxMs;
    }

    public void setFetchWaitMaxMs(Integer fetchWaitMaxMs) {
        this.fetchWaitMaxMs = fetchWaitMaxMs;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public String getAutoCommitOnStop() {
        return this.autoCommitOnStop;
    }

    public void setAutoCommitOnStop(String autoCommitOnStop) {
        this.autoCommitOnStop = autoCommitOnStop;
    }

    public boolean isBreakOnFirstError() {
        return this.breakOnFirstError;
    }

    public void setBreakOnFirstError(boolean breakOnFirstError) {
        this.breakOnFirstError = breakOnFirstError;
    }

    public String getBrokers() {
        return this.brokers;
    }

    public void setBrokers(String brokers) {
        this.brokers = brokers;
    }

    public String getSchemaRegistryURL() {
        return this.schemaRegistryURL;
    }

    public void setSchemaRegistryURL(String schemaRegistryURL) {
        this.schemaRegistryURL = schemaRegistryURL;
    }

    public boolean isSpecificAvroReader() {
        return this.specificAvroReader;
    }

    public void setSpecificAvroReader(boolean specificAvroReader) {
        this.specificAvroReader = specificAvroReader;
    }

    public String getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(String compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public Integer getRetryBackoffMs() {
        return this.retryBackoffMs;
    }

    public void setRetryBackoffMs(Integer retryBackoffMs) {
        this.retryBackoffMs = retryBackoffMs;
    }

    public Integer getSendBufferBytes() {
        return this.sendBufferBytes;
    }

    public void setSendBufferBytes(Integer sendBufferBytes) {
        this.sendBufferBytes = sendBufferBytes;
    }

    public Integer getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(Integer requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public Integer getQueueBufferingMaxMessages() {
        return this.queueBufferingMaxMessages;
    }

    public void setQueueBufferingMaxMessages(Integer queueBufferingMaxMessages) {
        this.queueBufferingMaxMessages = queueBufferingMaxMessages;
    }

    public String getSerializerClass() {
        return this.serializerClass;
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    public String getKeySerializerClass() {
        return this.keySerializerClass;
    }

    public void setKeySerializerClass(String keySerializerClass) {
        this.keySerializerClass = keySerializerClass;
    }

    public String getKerberosInitCmd() {
        return this.kerberosInitCmd;
    }

    public void setKerberosInitCmd(String kerberosInitCmd) {
        this.kerberosInitCmd = kerberosInitCmd;
    }

    public Integer getKerberosBeforeReloginMinTime() {
        return this.kerberosBeforeReloginMinTime;
    }

    public void setKerberosBeforeReloginMinTime(Integer kerberosBeforeReloginMinTime) {
        this.kerberosBeforeReloginMinTime = kerberosBeforeReloginMinTime;
    }

    public Double getKerberosRenewJitter() {
        return this.kerberosRenewJitter;
    }

    public void setKerberosRenewJitter(Double kerberosRenewJitter) {
        this.kerberosRenewJitter = kerberosRenewJitter;
    }

    public Double getKerberosRenewWindowFactor() {
        return this.kerberosRenewWindowFactor;
    }

    public void setKerberosRenewWindowFactor(Double kerberosRenewWindowFactor) {
        this.kerberosRenewWindowFactor = kerberosRenewWindowFactor;
    }

    public String getKerberosPrincipalToLocalRules() {
        return this.kerberosPrincipalToLocalRules;
    }

    public void setKerberosPrincipalToLocalRules(String kerberosPrincipalToLocalRules) {
        this.kerberosPrincipalToLocalRules = kerberosPrincipalToLocalRules;
    }

    public String getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public void setSslCipherSuites(String sslCipherSuites) {
        this.sslCipherSuites = sslCipherSuites;
    }

    public String getSslEndpointAlgorithm() {
        return this.sslEndpointAlgorithm;
    }

    public void setSslEndpointAlgorithm(String sslEndpointAlgorithm) {
        this.sslEndpointAlgorithm = sslEndpointAlgorithm;
    }

    public String getSslKeymanagerAlgorithm() {
        return this.sslKeymanagerAlgorithm;
    }

    public void setSslKeymanagerAlgorithm(String sslKeymanagerAlgorithm) {
        this.sslKeymanagerAlgorithm = sslKeymanagerAlgorithm;
    }

    public String getSslTrustmanagerAlgorithm() {
        return this.sslTrustmanagerAlgorithm;
    }

    public void setSslTrustmanagerAlgorithm(String sslTrustmanagerAlgorithm) {
        this.sslTrustmanagerAlgorithm = sslTrustmanagerAlgorithm;
    }

    public String getSslEnabledProtocols() {
        return this.sslEnabledProtocols;
    }

    public void setSslEnabledProtocols(String sslEnabledProtocols) {
        this.sslEnabledProtocols = sslEnabledProtocols;
    }

    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getSslProvider() {
        return this.sslProvider;
    }

    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    public String getSslTruststoreType() {
        return this.sslTruststoreType;
    }

    public void setSslTruststoreType(String sslTruststoreType) {
        this.sslTruststoreType = sslTruststoreType;
    }

    public String getSaslKerberosServiceName() {
        return this.saslKerberosServiceName;
    }

    public void setSaslKerberosServiceName(String saslKerberosServiceName) {
        this.saslKerberosServiceName = saslKerberosServiceName;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public String getSaslJaasConfig() {
        return this.saslJaasConfig;
    }

    public void setSaslJaasConfig(String saslMechanism) {
        this.saslJaasConfig = saslMechanism;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslKeystoreLocation() {
        return this.sslKeystoreLocation;
    }

    public void setSslKeystoreLocation(String sslKeystoreLocation) {
        this.sslKeystoreLocation = sslKeystoreLocation;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public String getSslTruststoreLocation() {
        return this.sslTruststoreLocation;
    }

    public void setSslTruststoreLocation(String sslTruststoreLocation) {
        this.sslTruststoreLocation = sslTruststoreLocation;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public Integer getBufferMemorySize() {
        return this.bufferMemorySize;
    }

    public void setBufferMemorySize(Integer bufferMemorySize) {
        this.bufferMemorySize = bufferMemorySize;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(Integer partitionKey) {
        this.partitionKey = partitionKey;
    }

    public String getRequestRequiredAcks() {
        return this.requestRequiredAcks;
    }

    public void setRequestRequiredAcks(String requestRequiredAcks) {
        this.requestRequiredAcks = requestRequiredAcks;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Integer getProducerBatchSize() {
        return this.producerBatchSize;
    }

    public void setProducerBatchSize(Integer producerBatchSize) {
        this.producerBatchSize = producerBatchSize;
    }

    public Integer getConnectionMaxIdleMs() {
        return this.connectionMaxIdleMs;
    }

    public void setConnectionMaxIdleMs(Integer connectionMaxIdleMs) {
        this.connectionMaxIdleMs = connectionMaxIdleMs;
    }

    public Integer getLingerMs() {
        return this.lingerMs;
    }

    public void setLingerMs(Integer lingerMs) {
        this.lingerMs = lingerMs;
    }

    public Integer getMaxBlockMs() {
        return this.maxBlockMs;
    }

    public void setMaxBlockMs(Integer maxBlockMs) {
        this.maxBlockMs = maxBlockMs;
    }

    public Integer getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(Integer maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public Integer getReceiveBufferBytes() {
        return this.receiveBufferBytes;
    }

    public void setReceiveBufferBytes(Integer receiveBufferBytes) {
        this.receiveBufferBytes = receiveBufferBytes;
    }

    public Integer getMaxInFlightRequest() {
        return this.maxInFlightRequest;
    }

    public void setMaxInFlightRequest(Integer maxInFlightRequest) {
        this.maxInFlightRequest = maxInFlightRequest;
    }

    public Integer getMetadataMaxAgeMs() {
        return this.metadataMaxAgeMs;
    }

    public void setMetadataMaxAgeMs(Integer metadataMaxAgeMs) {
        this.metadataMaxAgeMs = metadataMaxAgeMs;
    }

    public String getMetricReporters() {
        return this.metricReporters;
    }

    public void setMetricReporters(String metricReporters) {
        this.metricReporters = metricReporters;
    }

    public Integer getNoOfMetricsSample() {
        return this.noOfMetricsSample;
    }

    public void setNoOfMetricsSample(Integer noOfMetricsSample) {
        this.noOfMetricsSample = noOfMetricsSample;
    }

    public Integer getMetricsSampleWindowMs() {
        return this.metricsSampleWindowMs;
    }

    public void setMetricsSampleWindowMs(Integer metricsSampleWindowMs) {
        this.metricsSampleWindowMs = metricsSampleWindowMs;
    }

    public Integer getReconnectBackoffMs() {
        return this.reconnectBackoffMs;
    }

    public void setReconnectBackoffMs(Integer reconnectBackoffMs) {
        this.reconnectBackoffMs = reconnectBackoffMs;
    }

    public Integer getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setHeartbeatIntervalMs(Integer heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public Integer getMaxPartitionFetchBytes() {
        return this.maxPartitionFetchBytes;
    }

    public void setMaxPartitionFetchBytes(Integer maxPartitionFetchBytes) {
        this.maxPartitionFetchBytes = maxPartitionFetchBytes;
    }

    public Integer getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public void setSessionTimeoutMs(Integer sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public Integer getMaxPollRecords() {
        return this.maxPollRecords;
    }

    public void setMaxPollRecords(Integer maxPollRecords) {
        this.maxPollRecords = maxPollRecords;
    }

    public Long getPollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public void setPollTimeoutMs(Long pollTimeoutMs) {
        this.pollTimeoutMs = pollTimeoutMs;
    }

    public Long getMaxPollIntervalMs() {
        return this.maxPollIntervalMs;
    }

    public void setMaxPollIntervalMs(Long maxPollIntervalMs) {
        this.maxPollIntervalMs = maxPollIntervalMs;
    }

    public String getPartitionAssignor() {
        return this.partitionAssignor;
    }

    public void setPartitionAssignor(String partitionAssignor) {
        this.partitionAssignor = partitionAssignor;
    }

    public Integer getConsumerRequestTimeoutMs() {
        return this.consumerRequestTimeoutMs;
    }

    public void setConsumerRequestTimeoutMs(Integer consumerRequestTimeoutMs) {
        this.consumerRequestTimeoutMs = consumerRequestTimeoutMs;
    }

    public Boolean getCheckCrcs() {
        return this.checkCrcs;
    }

    public void setCheckCrcs(Boolean checkCrcs) {
        this.checkCrcs = checkCrcs;
    }

    public String getKeyDeserializer() {
        return this.keyDeserializer;
    }

    public void setKeyDeserializer(String keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
    }

    public String getValueDeserializer() {
        return this.valueDeserializer;
    }

    public void setValueDeserializer(String valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
    }

    public String getSeekTo() {
        return this.seekTo;
    }

    public void setSeekTo(String seekTo) {
        this.seekTo = seekTo;
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }

    public Integer getWorkerPoolCoreSize() {
        return this.workerPoolCoreSize;
    }

    public void setWorkerPoolCoreSize(Integer workerPoolCoreSize) {
        this.workerPoolCoreSize = workerPoolCoreSize;
    }

    public Integer getWorkerPoolMaxSize() {
        return this.workerPoolMaxSize;
    }

    public void setWorkerPoolMaxSize(Integer workerPoolMaxSize) {
        this.workerPoolMaxSize = workerPoolMaxSize;
    }

    public boolean isRecordMetadata() {
        return this.recordMetadata;
    }

    public void setRecordMetadata(boolean recordMetadata) {
        this.recordMetadata = recordMetadata;
    }

    public String getInterceptorClasses() {
        return this.interceptorClasses;
    }

    public void setInterceptorClasses(String interceptorClasses) {
        this.interceptorClasses = interceptorClasses;
    }

    public boolean isEnableIdempotence() {
        return this.enableIdempotence;
    }

    public void setEnableIdempotence(boolean enableIdempotence) {
        this.enableIdempotence = enableIdempotence;
    }

    public Integer getReconnectBackoffMaxMs() {
        return this.reconnectBackoffMaxMs;
    }

    public void setReconnectBackoffMaxMs(Integer reconnectBackoffMaxMs) {
        this.reconnectBackoffMaxMs = reconnectBackoffMaxMs;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public KafkaHeaderDeserializer getKafkaHeaderDeserializer() {
        return this.kafkaHeaderDeserializer;
    }

    public void setKafkaHeaderDeserializer(KafkaHeaderDeserializer kafkaHeaderDeserializer) {
        this.kafkaHeaderDeserializer = kafkaHeaderDeserializer;
    }

    public KafkaHeaderSerializer getKafkaHeaderSerializer() {
        return this.kafkaHeaderSerializer;
    }

    public void setKafkaHeaderSerializer(KafkaHeaderSerializer kafkaHeaderSerializer) {
        this.kafkaHeaderSerializer = kafkaHeaderSerializer;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }
}

