/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaManualCommitFactory;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class KafkaComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private KafkaConfiguration getOrCreateConfiguration(KafkaComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new KafkaConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        KafkaComponent target = (KafkaComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionalproperties": 
            case "additionalProperties": {
                this.getOrCreateConfiguration(target).setAdditionalProperties((Map)KafkaComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "allowmanualcommit": 
            case "allowManualCommit": {
                this.getOrCreateConfiguration(target).setAllowManualCommit((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autocommitenable": 
            case "autoCommitEnable": {
                this.getOrCreateConfiguration(target).setAutoCommitEnable((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "autocommitintervalms": 
            case "autoCommitIntervalMs": {
                this.getOrCreateConfiguration(target).setAutoCommitIntervalMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "autocommitonstop": 
            case "autoCommitOnStop": {
                this.getOrCreateConfiguration(target).setAutoCommitOnStop((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autooffsetreset": 
            case "autoOffsetReset": {
                this.getOrCreateConfiguration(target).setAutoOffsetReset((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "breakonfirsterror": 
            case "breakOnFirstError": {
                this.getOrCreateConfiguration(target).setBreakOnFirstError((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "brokers": {
                this.getOrCreateConfiguration(target).setBrokers((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "buffermemorysize": 
            case "bufferMemorySize": {
                this.getOrCreateConfiguration(target).setBufferMemorySize((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "checkcrcs": 
            case "checkCrcs": {
                this.getOrCreateConfiguration(target).setCheckCrcs((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                this.getOrCreateConfiguration(target).setClientId((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "compressioncodec": 
            case "compressionCodec": {
                this.getOrCreateConfiguration(target).setCompressionCodec((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((KafkaConfiguration)KafkaComponentConfigurer.property((CamelContext)camelContext, KafkaConfiguration.class, (Object)value));
                return true;
            }
            case "connectionmaxidlems": 
            case "connectionMaxIdleMs": {
                this.getOrCreateConfiguration(target).setConnectionMaxIdleMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "consumerrequesttimeoutms": 
            case "consumerRequestTimeoutMs": {
                this.getOrCreateConfiguration(target).setConsumerRequestTimeoutMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "consumerstreams": 
            case "consumerStreams": {
                this.getOrCreateConfiguration(target).setConsumerStreams((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "consumerscount": 
            case "consumersCount": {
                this.getOrCreateConfiguration(target).setConsumersCount((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "enableidempotence": 
            case "enableIdempotence": {
                this.getOrCreateConfiguration(target).setEnableIdempotence((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "fetchmaxbytes": 
            case "fetchMaxBytes": {
                this.getOrCreateConfiguration(target).setFetchMaxBytes((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "fetchminbytes": 
            case "fetchMinBytes": {
                this.getOrCreateConfiguration(target).setFetchMinBytes((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "fetchwaitmaxms": 
            case "fetchWaitMaxMs": {
                this.getOrCreateConfiguration(target).setFetchWaitMaxMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "groupid": 
            case "groupId": {
                this.getOrCreateConfiguration(target).setGroupId((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                this.getOrCreateConfiguration(target).setHeaderFilterStrategy((HeaderFilterStrategy)KafkaComponentConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "heartbeatintervalms": 
            case "heartbeatIntervalMs": {
                this.getOrCreateConfiguration(target).setHeartbeatIntervalMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "interceptorclasses": 
            case "interceptorClasses": {
                this.getOrCreateConfiguration(target).setInterceptorClasses((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kafkaheaderdeserializer": 
            case "kafkaHeaderDeserializer": {
                this.getOrCreateConfiguration(target).setKafkaHeaderDeserializer((KafkaHeaderDeserializer)KafkaComponentConfigurer.property((CamelContext)camelContext, KafkaHeaderDeserializer.class, (Object)value));
                return true;
            }
            case "kafkaheaderserializer": 
            case "kafkaHeaderSerializer": {
                this.getOrCreateConfiguration(target).setKafkaHeaderSerializer((KafkaHeaderSerializer)KafkaComponentConfigurer.property((CamelContext)camelContext, KafkaHeaderSerializer.class, (Object)value));
                return true;
            }
            case "kafkamanualcommitfactory": 
            case "kafkaManualCommitFactory": {
                target.setKafkaManualCommitFactory((KafkaManualCommitFactory)KafkaComponentConfigurer.property((CamelContext)camelContext, KafkaManualCommitFactory.class, (Object)value));
                return true;
            }
            case "kerberosbeforereloginmintime": 
            case "kerberosBeforeReloginMinTime": {
                this.getOrCreateConfiguration(target).setKerberosBeforeReloginMinTime((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "kerberosinitcmd": 
            case "kerberosInitCmd": {
                this.getOrCreateConfiguration(target).setKerberosInitCmd((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosprincipaltolocalrules": 
            case "kerberosPrincipalToLocalRules": {
                this.getOrCreateConfiguration(target).setKerberosPrincipalToLocalRules((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosrenewjitter": 
            case "kerberosRenewJitter": {
                this.getOrCreateConfiguration(target).setKerberosRenewJitter((Double)KafkaComponentConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "kerberosrenewwindowfactor": 
            case "kerberosRenewWindowFactor": {
                this.getOrCreateConfiguration(target).setKerberosRenewWindowFactor((Double)KafkaComponentConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "key": {
                this.getOrCreateConfiguration(target).setKey((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keydeserializer": 
            case "keyDeserializer": {
                this.getOrCreateConfiguration(target).setKeyDeserializer((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyserializerclass": 
            case "keySerializerClass": {
                this.getOrCreateConfiguration(target).setKeySerializerClass((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lingerms": 
            case "lingerMs": {
                this.getOrCreateConfiguration(target).setLingerMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxblockms": 
            case "maxBlockMs": {
                this.getOrCreateConfiguration(target).setMaxBlockMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxinflightrequest": 
            case "maxInFlightRequest": {
                this.getOrCreateConfiguration(target).setMaxInFlightRequest((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxpartitionfetchbytes": 
            case "maxPartitionFetchBytes": {
                this.getOrCreateConfiguration(target).setMaxPartitionFetchBytes((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxpollintervalms": 
            case "maxPollIntervalMs": {
                this.getOrCreateConfiguration(target).setMaxPollIntervalMs((Long)KafkaComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "maxpollrecords": 
            case "maxPollRecords": {
                this.getOrCreateConfiguration(target).setMaxPollRecords((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxrequestsize": 
            case "maxRequestSize": {
                this.getOrCreateConfiguration(target).setMaxRequestSize((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "metadatamaxagems": 
            case "metadataMaxAgeMs": {
                this.getOrCreateConfiguration(target).setMetadataMaxAgeMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "metricreporters": 
            case "metricReporters": {
                this.getOrCreateConfiguration(target).setMetricReporters((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "metricssamplewindowms": 
            case "metricsSampleWindowMs": {
                this.getOrCreateConfiguration(target).setMetricsSampleWindowMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "noofmetricssample": 
            case "noOfMetricsSample": {
                this.getOrCreateConfiguration(target).setNoOfMetricsSample((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "offsetrepository": 
            case "offsetRepository": {
                this.getOrCreateConfiguration(target).setOffsetRepository((StateRepository<String, String>)((StateRepository)KafkaComponentConfigurer.property((CamelContext)camelContext, StateRepository.class, (Object)value)));
                return true;
            }
            case "partitionassignor": 
            case "partitionAssignor": {
                this.getOrCreateConfiguration(target).setPartitionAssignor((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "partitionkey": 
            case "partitionKey": {
                this.getOrCreateConfiguration(target).setPartitionKey((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "partitioner": {
                this.getOrCreateConfiguration(target).setPartitioner((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "polltimeoutms": 
            case "pollTimeoutMs": {
                this.getOrCreateConfiguration(target).setPollTimeoutMs((Long)KafkaComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "producerbatchsize": 
            case "producerBatchSize": {
                this.getOrCreateConfiguration(target).setProducerBatchSize((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "queuebufferingmaxmessages": 
            case "queueBufferingMaxMessages": {
                this.getOrCreateConfiguration(target).setQueueBufferingMaxMessages((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "receivebufferbytes": 
            case "receiveBufferBytes": {
                this.getOrCreateConfiguration(target).setReceiveBufferBytes((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "reconnectbackoffmaxms": 
            case "reconnectBackoffMaxMs": {
                this.getOrCreateConfiguration(target).setReconnectBackoffMaxMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "reconnectbackoffms": 
            case "reconnectBackoffMs": {
                this.getOrCreateConfiguration(target).setReconnectBackoffMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "recordmetadata": 
            case "recordMetadata": {
                this.getOrCreateConfiguration(target).setRecordMetadata((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "requestrequiredacks": 
            case "requestRequiredAcks": {
                this.getOrCreateConfiguration(target).setRequestRequiredAcks((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "requesttimeoutms": 
            case "requestTimeoutMs": {
                this.getOrCreateConfiguration(target).setRequestTimeoutMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "retries": {
                this.getOrCreateConfiguration(target).setRetries((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "retrybackoffms": 
            case "retryBackoffMs": {
                this.getOrCreateConfiguration(target).setRetryBackoffMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "sasljaasconfig": 
            case "saslJaasConfig": {
                this.getOrCreateConfiguration(target).setSaslJaasConfig((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "saslkerberosservicename": 
            case "saslKerberosServiceName": {
                this.getOrCreateConfiguration(target).setSaslKerberosServiceName((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "saslmechanism": 
            case "saslMechanism": {
                this.getOrCreateConfiguration(target).setSaslMechanism((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schemaregistryurl": 
            case "schemaRegistryURL": {
                this.getOrCreateConfiguration(target).setSchemaRegistryURL((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securityprotocol": 
            case "securityProtocol": {
                this.getOrCreateConfiguration(target).setSecurityProtocol((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "seekto": 
            case "seekTo": {
                this.getOrCreateConfiguration(target).setSeekTo((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sendbufferbytes": 
            case "sendBufferBytes": {
                this.getOrCreateConfiguration(target).setSendBufferBytes((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "serializerclass": 
            case "serializerClass": {
                this.getOrCreateConfiguration(target).setSerializerClass((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sessiontimeoutms": 
            case "sessionTimeoutMs": {
                this.getOrCreateConfiguration(target).setSessionTimeoutMs((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "shutdowntimeout": 
            case "shutdownTimeout": {
                this.getOrCreateConfiguration(target).setShutdownTimeout((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "specificavroreader": 
            case "specificAvroReader": {
                this.getOrCreateConfiguration(target).setSpecificAvroReader((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sslciphersuites": 
            case "sslCipherSuites": {
                this.getOrCreateConfiguration(target).setSslCipherSuites((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters((SSLContextParameters)KafkaComponentConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "sslenabledprotocols": 
            case "sslEnabledProtocols": {
                this.getOrCreateConfiguration(target).setSslEnabledProtocols((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslendpointalgorithm": 
            case "sslEndpointAlgorithm": {
                this.getOrCreateConfiguration(target).setSslEndpointAlgorithm((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeypassword": 
            case "sslKeyPassword": {
                this.getOrCreateConfiguration(target).setSslKeyPassword((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeymanageralgorithm": 
            case "sslKeymanagerAlgorithm": {
                this.getOrCreateConfiguration(target).setSslKeymanagerAlgorithm((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeystorelocation": 
            case "sslKeystoreLocation": {
                this.getOrCreateConfiguration(target).setSslKeystoreLocation((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeystorepassword": 
            case "sslKeystorePassword": {
                this.getOrCreateConfiguration(target).setSslKeystorePassword((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeystoretype": 
            case "sslKeystoreType": {
                this.getOrCreateConfiguration(target).setSslKeystoreType((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslprotocol": 
            case "sslProtocol": {
                this.getOrCreateConfiguration(target).setSslProtocol((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslprovider": 
            case "sslProvider": {
                this.getOrCreateConfiguration(target).setSslProvider((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ssltrustmanageralgorithm": 
            case "sslTrustmanagerAlgorithm": {
                this.getOrCreateConfiguration(target).setSslTrustmanagerAlgorithm((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ssltruststorelocation": 
            case "sslTruststoreLocation": {
                this.getOrCreateConfiguration(target).setSslTruststoreLocation((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ssltruststorepassword": 
            case "sslTruststorePassword": {
                this.getOrCreateConfiguration(target).setSslTruststorePassword((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ssltruststoretype": 
            case "sslTruststoreType": {
                this.getOrCreateConfiguration(target).setSslTruststoreType((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "topicispattern": 
            case "topicIsPattern": {
                this.getOrCreateConfiguration(target).setTopicIsPattern((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters((Boolean)KafkaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "valuedeserializer": 
            case "valueDeserializer": {
                this.getOrCreateConfiguration(target).setValueDeserializer((String)KafkaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "workerpool": 
            case "workerPool": {
                this.getOrCreateConfiguration(target).setWorkerPool((ExecutorService)KafkaComponentConfigurer.property((CamelContext)camelContext, ExecutorService.class, (Object)value));
                return true;
            }
            case "workerpoolcoresize": 
            case "workerPoolCoreSize": {
                this.getOrCreateConfiguration(target).setWorkerPoolCoreSize((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "workerpoolmaxsize": 
            case "workerPoolMaxSize": {
                this.getOrCreateConfiguration(target).setWorkerPoolMaxSize((Integer)KafkaComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        KafkaComponent target = (KafkaComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionalproperties": 
            case "additionalProperties": {
                return this.getOrCreateConfiguration(target).getAdditionalProperties();
            }
            case "allowmanualcommit": 
            case "allowManualCommit": {
                return this.getOrCreateConfiguration(target).isAllowManualCommit();
            }
            case "autocommitenable": 
            case "autoCommitEnable": {
                return this.getOrCreateConfiguration(target).getAutoCommitEnable();
            }
            case "autocommitintervalms": 
            case "autoCommitIntervalMs": {
                return this.getOrCreateConfiguration(target).getAutoCommitIntervalMs();
            }
            case "autocommitonstop": 
            case "autoCommitOnStop": {
                return this.getOrCreateConfiguration(target).getAutoCommitOnStop();
            }
            case "autooffsetreset": 
            case "autoOffsetReset": {
                return this.getOrCreateConfiguration(target).getAutoOffsetReset();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "breakonfirsterror": 
            case "breakOnFirstError": {
                return this.getOrCreateConfiguration(target).isBreakOnFirstError();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "brokers": {
                return this.getOrCreateConfiguration(target).getBrokers();
            }
            case "buffermemorysize": 
            case "bufferMemorySize": {
                return this.getOrCreateConfiguration(target).getBufferMemorySize();
            }
            case "checkcrcs": 
            case "checkCrcs": {
                return this.getOrCreateConfiguration(target).getCheckCrcs();
            }
            case "clientid": 
            case "clientId": {
                return this.getOrCreateConfiguration(target).getClientId();
            }
            case "compressioncodec": 
            case "compressionCodec": {
                return this.getOrCreateConfiguration(target).getCompressionCodec();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connectionmaxidlems": 
            case "connectionMaxIdleMs": {
                return this.getOrCreateConfiguration(target).getConnectionMaxIdleMs();
            }
            case "consumerrequesttimeoutms": 
            case "consumerRequestTimeoutMs": {
                return this.getOrCreateConfiguration(target).getConsumerRequestTimeoutMs();
            }
            case "consumerstreams": 
            case "consumerStreams": {
                return this.getOrCreateConfiguration(target).getConsumerStreams();
            }
            case "consumerscount": 
            case "consumersCount": {
                return this.getOrCreateConfiguration(target).getConsumersCount();
            }
            case "enableidempotence": 
            case "enableIdempotence": {
                return this.getOrCreateConfiguration(target).isEnableIdempotence();
            }
            case "fetchmaxbytes": 
            case "fetchMaxBytes": {
                return this.getOrCreateConfiguration(target).getFetchMaxBytes();
            }
            case "fetchminbytes": 
            case "fetchMinBytes": {
                return this.getOrCreateConfiguration(target).getFetchMinBytes();
            }
            case "fetchwaitmaxms": 
            case "fetchWaitMaxMs": {
                return this.getOrCreateConfiguration(target).getFetchWaitMaxMs();
            }
            case "groupid": 
            case "groupId": {
                return this.getOrCreateConfiguration(target).getGroupId();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return this.getOrCreateConfiguration(target).getHeaderFilterStrategy();
            }
            case "heartbeatintervalms": 
            case "heartbeatIntervalMs": {
                return this.getOrCreateConfiguration(target).getHeartbeatIntervalMs();
            }
            case "interceptorclasses": 
            case "interceptorClasses": {
                return this.getOrCreateConfiguration(target).getInterceptorClasses();
            }
            case "kafkaheaderdeserializer": 
            case "kafkaHeaderDeserializer": {
                return this.getOrCreateConfiguration(target).getKafkaHeaderDeserializer();
            }
            case "kafkaheaderserializer": 
            case "kafkaHeaderSerializer": {
                return this.getOrCreateConfiguration(target).getKafkaHeaderSerializer();
            }
            case "kafkamanualcommitfactory": 
            case "kafkaManualCommitFactory": {
                return target.getKafkaManualCommitFactory();
            }
            case "kerberosbeforereloginmintime": 
            case "kerberosBeforeReloginMinTime": {
                return this.getOrCreateConfiguration(target).getKerberosBeforeReloginMinTime();
            }
            case "kerberosinitcmd": 
            case "kerberosInitCmd": {
                return this.getOrCreateConfiguration(target).getKerberosInitCmd();
            }
            case "kerberosprincipaltolocalrules": 
            case "kerberosPrincipalToLocalRules": {
                return this.getOrCreateConfiguration(target).getKerberosPrincipalToLocalRules();
            }
            case "kerberosrenewjitter": 
            case "kerberosRenewJitter": {
                return this.getOrCreateConfiguration(target).getKerberosRenewJitter();
            }
            case "kerberosrenewwindowfactor": 
            case "kerberosRenewWindowFactor": {
                return this.getOrCreateConfiguration(target).getKerberosRenewWindowFactor();
            }
            case "key": {
                return this.getOrCreateConfiguration(target).getKey();
            }
            case "keydeserializer": 
            case "keyDeserializer": {
                return this.getOrCreateConfiguration(target).getKeyDeserializer();
            }
            case "keyserializerclass": 
            case "keySerializerClass": {
                return this.getOrCreateConfiguration(target).getKeySerializerClass();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "lingerms": 
            case "lingerMs": {
                return this.getOrCreateConfiguration(target).getLingerMs();
            }
            case "maxblockms": 
            case "maxBlockMs": {
                return this.getOrCreateConfiguration(target).getMaxBlockMs();
            }
            case "maxinflightrequest": 
            case "maxInFlightRequest": {
                return this.getOrCreateConfiguration(target).getMaxInFlightRequest();
            }
            case "maxpartitionfetchbytes": 
            case "maxPartitionFetchBytes": {
                return this.getOrCreateConfiguration(target).getMaxPartitionFetchBytes();
            }
            case "maxpollintervalms": 
            case "maxPollIntervalMs": {
                return this.getOrCreateConfiguration(target).getMaxPollIntervalMs();
            }
            case "maxpollrecords": 
            case "maxPollRecords": {
                return this.getOrCreateConfiguration(target).getMaxPollRecords();
            }
            case "maxrequestsize": 
            case "maxRequestSize": {
                return this.getOrCreateConfiguration(target).getMaxRequestSize();
            }
            case "metadatamaxagems": 
            case "metadataMaxAgeMs": {
                return this.getOrCreateConfiguration(target).getMetadataMaxAgeMs();
            }
            case "metricreporters": 
            case "metricReporters": {
                return this.getOrCreateConfiguration(target).getMetricReporters();
            }
            case "metricssamplewindowms": 
            case "metricsSampleWindowMs": {
                return this.getOrCreateConfiguration(target).getMetricsSampleWindowMs();
            }
            case "noofmetricssample": 
            case "noOfMetricsSample": {
                return this.getOrCreateConfiguration(target).getNoOfMetricsSample();
            }
            case "offsetrepository": 
            case "offsetRepository": {
                return this.getOrCreateConfiguration(target).getOffsetRepository();
            }
            case "partitionassignor": 
            case "partitionAssignor": {
                return this.getOrCreateConfiguration(target).getPartitionAssignor();
            }
            case "partitionkey": 
            case "partitionKey": {
                return this.getOrCreateConfiguration(target).getPartitionKey();
            }
            case "partitioner": {
                return this.getOrCreateConfiguration(target).getPartitioner();
            }
            case "polltimeoutms": 
            case "pollTimeoutMs": {
                return this.getOrCreateConfiguration(target).getPollTimeoutMs();
            }
            case "producerbatchsize": 
            case "producerBatchSize": {
                return this.getOrCreateConfiguration(target).getProducerBatchSize();
            }
            case "queuebufferingmaxmessages": 
            case "queueBufferingMaxMessages": {
                return this.getOrCreateConfiguration(target).getQueueBufferingMaxMessages();
            }
            case "receivebufferbytes": 
            case "receiveBufferBytes": {
                return this.getOrCreateConfiguration(target).getReceiveBufferBytes();
            }
            case "reconnectbackoffmaxms": 
            case "reconnectBackoffMaxMs": {
                return this.getOrCreateConfiguration(target).getReconnectBackoffMaxMs();
            }
            case "reconnectbackoffms": 
            case "reconnectBackoffMs": {
                return this.getOrCreateConfiguration(target).getReconnectBackoffMs();
            }
            case "recordmetadata": 
            case "recordMetadata": {
                return this.getOrCreateConfiguration(target).isRecordMetadata();
            }
            case "requestrequiredacks": 
            case "requestRequiredAcks": {
                return this.getOrCreateConfiguration(target).getRequestRequiredAcks();
            }
            case "requesttimeoutms": 
            case "requestTimeoutMs": {
                return this.getOrCreateConfiguration(target).getRequestTimeoutMs();
            }
            case "retries": {
                return this.getOrCreateConfiguration(target).getRetries();
            }
            case "retrybackoffms": 
            case "retryBackoffMs": {
                return this.getOrCreateConfiguration(target).getRetryBackoffMs();
            }
            case "sasljaasconfig": 
            case "saslJaasConfig": {
                return this.getOrCreateConfiguration(target).getSaslJaasConfig();
            }
            case "saslkerberosservicename": 
            case "saslKerberosServiceName": {
                return this.getOrCreateConfiguration(target).getSaslKerberosServiceName();
            }
            case "saslmechanism": 
            case "saslMechanism": {
                return this.getOrCreateConfiguration(target).getSaslMechanism();
            }
            case "schemaregistryurl": 
            case "schemaRegistryURL": {
                return this.getOrCreateConfiguration(target).getSchemaRegistryURL();
            }
            case "securityprotocol": 
            case "securityProtocol": {
                return this.getOrCreateConfiguration(target).getSecurityProtocol();
            }
            case "seekto": 
            case "seekTo": {
                return this.getOrCreateConfiguration(target).getSeekTo();
            }
            case "sendbufferbytes": 
            case "sendBufferBytes": {
                return this.getOrCreateConfiguration(target).getSendBufferBytes();
            }
            case "serializerclass": 
            case "serializerClass": {
                return this.getOrCreateConfiguration(target).getSerializerClass();
            }
            case "sessiontimeoutms": 
            case "sessionTimeoutMs": {
                return this.getOrCreateConfiguration(target).getSessionTimeoutMs();
            }
            case "shutdowntimeout": 
            case "shutdownTimeout": {
                return this.getOrCreateConfiguration(target).getShutdownTimeout();
            }
            case "specificavroreader": 
            case "specificAvroReader": {
                return this.getOrCreateConfiguration(target).isSpecificAvroReader();
            }
            case "sslciphersuites": 
            case "sslCipherSuites": {
                return this.getOrCreateConfiguration(target).getSslCipherSuites();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "sslenabledprotocols": 
            case "sslEnabledProtocols": {
                return this.getOrCreateConfiguration(target).getSslEnabledProtocols();
            }
            case "sslendpointalgorithm": 
            case "sslEndpointAlgorithm": {
                return this.getOrCreateConfiguration(target).getSslEndpointAlgorithm();
            }
            case "sslkeypassword": 
            case "sslKeyPassword": {
                return this.getOrCreateConfiguration(target).getSslKeyPassword();
            }
            case "sslkeymanageralgorithm": 
            case "sslKeymanagerAlgorithm": {
                return this.getOrCreateConfiguration(target).getSslKeymanagerAlgorithm();
            }
            case "sslkeystorelocation": 
            case "sslKeystoreLocation": {
                return this.getOrCreateConfiguration(target).getSslKeystoreLocation();
            }
            case "sslkeystorepassword": 
            case "sslKeystorePassword": {
                return this.getOrCreateConfiguration(target).getSslKeystorePassword();
            }
            case "sslkeystoretype": 
            case "sslKeystoreType": {
                return this.getOrCreateConfiguration(target).getSslKeystoreType();
            }
            case "sslprotocol": 
            case "sslProtocol": {
                return this.getOrCreateConfiguration(target).getSslProtocol();
            }
            case "sslprovider": 
            case "sslProvider": {
                return this.getOrCreateConfiguration(target).getSslProvider();
            }
            case "ssltrustmanageralgorithm": 
            case "sslTrustmanagerAlgorithm": {
                return this.getOrCreateConfiguration(target).getSslTrustmanagerAlgorithm();
            }
            case "ssltruststorelocation": 
            case "sslTruststoreLocation": {
                return this.getOrCreateConfiguration(target).getSslTruststoreLocation();
            }
            case "ssltruststorepassword": 
            case "sslTruststorePassword": {
                return this.getOrCreateConfiguration(target).getSslTruststorePassword();
            }
            case "ssltruststoretype": 
            case "sslTruststoreType": {
                return this.getOrCreateConfiguration(target).getSslTruststoreType();
            }
            case "topicispattern": 
            case "topicIsPattern": {
                return this.getOrCreateConfiguration(target).isTopicIsPattern();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "valuedeserializer": 
            case "valueDeserializer": {
                return this.getOrCreateConfiguration(target).getValueDeserializer();
            }
            case "workerpool": 
            case "workerPool": {
                return this.getOrCreateConfiguration(target).getWorkerPool();
            }
            case "workerpoolcoresize": 
            case "workerPoolCoreSize": {
                return this.getOrCreateConfiguration(target).getWorkerPoolCoreSize();
            }
            case "workerpoolmaxsize": 
            case "workerPoolMaxSize": {
                return this.getOrCreateConfiguration(target).getWorkerPoolMaxSize();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("additionalProperties", Map.class);
        map.put("brokers", String.class);
        map.put("clientId", String.class);
        map.put("configuration", KafkaConfiguration.class);
        map.put("headerFilterStrategy", HeaderFilterStrategy.class);
        map.put("reconnectBackoffMaxMs", Integer.class);
        map.put("shutdownTimeout", Integer.TYPE);
        map.put("allowManualCommit", Boolean.TYPE);
        map.put("autoCommitEnable", Boolean.class);
        map.put("autoCommitIntervalMs", Integer.class);
        map.put("autoCommitOnStop", String.class);
        map.put("autoOffsetReset", String.class);
        map.put("breakOnFirstError", Boolean.TYPE);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("checkCrcs", Boolean.class);
        map.put("consumerRequestTimeoutMs", Integer.class);
        map.put("consumersCount", Integer.TYPE);
        map.put("consumerStreams", Integer.TYPE);
        map.put("fetchMaxBytes", Integer.class);
        map.put("fetchMinBytes", Integer.class);
        map.put("fetchWaitMaxMs", Integer.class);
        map.put("groupId", String.class);
        map.put("heartbeatIntervalMs", Integer.class);
        map.put("kafkaHeaderDeserializer", KafkaHeaderDeserializer.class);
        map.put("keyDeserializer", String.class);
        map.put("maxPartitionFetchBytes", Integer.class);
        map.put("maxPollIntervalMs", Long.class);
        map.put("maxPollRecords", Integer.class);
        map.put("offsetRepository", StateRepository.class);
        map.put("partitionAssignor", String.class);
        map.put("pollTimeoutMs", Long.class);
        map.put("seekTo", String.class);
        map.put("sessionTimeoutMs", Integer.class);
        map.put("specificAvroReader", Boolean.TYPE);
        map.put("topicIsPattern", Boolean.TYPE);
        map.put("valueDeserializer", String.class);
        map.put("kafkaManualCommitFactory", KafkaManualCommitFactory.class);
        map.put("bufferMemorySize", Integer.class);
        map.put("compressionCodec", String.class);
        map.put("connectionMaxIdleMs", Integer.class);
        map.put("enableIdempotence", Boolean.TYPE);
        map.put("kafkaHeaderSerializer", KafkaHeaderSerializer.class);
        map.put("key", String.class);
        map.put("keySerializerClass", String.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("lingerMs", Integer.class);
        map.put("maxBlockMs", Integer.class);
        map.put("maxInFlightRequest", Integer.class);
        map.put("maxRequestSize", Integer.class);
        map.put("metadataMaxAgeMs", Integer.class);
        map.put("metricReporters", String.class);
        map.put("metricsSampleWindowMs", Integer.class);
        map.put("noOfMetricsSample", Integer.class);
        map.put("partitioner", String.class);
        map.put("partitionKey", Integer.class);
        map.put("producerBatchSize", Integer.class);
        map.put("queueBufferingMaxMessages", Integer.class);
        map.put("receiveBufferBytes", Integer.class);
        map.put("reconnectBackoffMs", Integer.class);
        map.put("recordMetadata", Boolean.TYPE);
        map.put("requestRequiredAcks", String.class);
        map.put("requestTimeoutMs", Integer.class);
        map.put("retries", Integer.class);
        map.put("retryBackoffMs", Integer.class);
        map.put("sendBufferBytes", Integer.class);
        map.put("serializerClass", String.class);
        map.put("workerPool", ExecutorService.class);
        map.put("workerPoolCoreSize", Integer.class);
        map.put("workerPoolMaxSize", Integer.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("schemaRegistryURL", String.class);
        map.put("interceptorClasses", String.class);
        map.put("kerberosBeforeReloginMinTime", Integer.class);
        map.put("kerberosInitCmd", String.class);
        map.put("kerberosPrincipalToLocalRules", String.class);
        map.put("kerberosRenewJitter", Double.class);
        map.put("kerberosRenewWindowFactor", Double.class);
        map.put("saslJaasConfig", String.class);
        map.put("saslKerberosServiceName", String.class);
        map.put("saslMechanism", String.class);
        map.put("securityProtocol", String.class);
        map.put("sslCipherSuites", String.class);
        map.put("sslContextParameters", SSLContextParameters.class);
        map.put("sslEnabledProtocols", String.class);
        map.put("sslEndpointAlgorithm", String.class);
        map.put("sslKeymanagerAlgorithm", String.class);
        map.put("sslKeyPassword", String.class);
        map.put("sslKeystoreLocation", String.class);
        map.put("sslKeystorePassword", String.class);
        map.put("sslKeystoreType", String.class);
        map.put("sslProtocol", String.class);
        map.put("sslProvider", String.class);
        map.put("sslTrustmanagerAlgorithm", String.class);
        map.put("sslTruststoreLocation", String.class);
        map.put("sslTruststorePassword", String.class);
        map.put("sslTruststoreType", String.class);
        map.put("useGlobalSslContextParameters", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

