/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.ldap;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelLdapSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_LDAP_PATH_DIR_CONTEXT_NAME_CONF = "camel.sink.path.dirContextName";
    public static final String CAMEL_SINK_LDAP_PATH_DIR_CONTEXT_NAME_DOC = "Name of either a javax.naming.directory.DirContext, or java.util.Hashtable, or Map bean to lookup in the registry. If the bean is either a Hashtable or Map then a new javax.naming.directory.DirContext instance is created for each use. If the bean is a javax.naming.directory.DirContext then the bean is used as given. The latter may not be possible in all situations where the javax.naming.directory.DirContext must not be shared, and in those situations it can be better to use java.util.Hashtable or Map instead.";
    public static final String CAMEL_SINK_LDAP_PATH_DIR_CONTEXT_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_LDAP_ENDPOINT_BASE_CONF = "camel.sink.endpoint.base";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_BASE_DOC = "The base DN for searches.";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_BASE_DEFAULT = "ou=system";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_LDAP_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_LDAP_ENDPOINT_PAGE_SIZE_CONF = "camel.sink.endpoint.pageSize";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_PAGE_SIZE_DOC = "When specified the ldap module uses paging to retrieve all results (most LDAP Servers throw an exception when trying to retrieve more than 1000 entries in one query). To be able to use this a LdapContext (subclass of DirContext) has to be passed in as ldapServerBean (otherwise an exception is thrown)";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_PAGE_SIZE_DEFAULT = null;
    public static final String CAMEL_SINK_LDAP_ENDPOINT_RETURNED_ATTRIBUTES_CONF = "camel.sink.endpoint.returnedAttributes";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_RETURNED_ATTRIBUTES_DOC = "Comma-separated list of attributes that should be set in each entry of the result";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_RETURNED_ATTRIBUTES_DEFAULT = null;
    public static final String CAMEL_SINK_LDAP_ENDPOINT_SCOPE_CONF = "camel.sink.endpoint.scope";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_SCOPE_DOC = "Specifies how deeply to search the tree of entries, starting at the base DN. One of: [object] [onelevel] [subtree]";
    public static final String CAMEL_SINK_LDAP_ENDPOINT_SCOPE_DEFAULT = "subtree";
    public static final String CAMEL_SINK_LDAP_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.ldap.lazyStartProducer";
    public static final String CAMEL_SINK_LDAP_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_LDAP_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_LDAP_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.ldap.autowiredEnabled";
    public static final String CAMEL_SINK_LDAP_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_LDAP_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelLdapSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelLdapSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_LDAP_PATH_DIR_CONTEXT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LDAP_PATH_DIR_CONTEXT_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_LDAP_PATH_DIR_CONTEXT_NAME_DOC);
        conf.define(CAMEL_SINK_LDAP_ENDPOINT_BASE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LDAP_ENDPOINT_BASE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LDAP_ENDPOINT_BASE_DOC);
        conf.define(CAMEL_SINK_LDAP_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LDAP_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LDAP_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_LDAP_ENDPOINT_PAGE_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LDAP_ENDPOINT_PAGE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LDAP_ENDPOINT_PAGE_SIZE_DOC);
        conf.define(CAMEL_SINK_LDAP_ENDPOINT_RETURNED_ATTRIBUTES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LDAP_ENDPOINT_RETURNED_ATTRIBUTES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LDAP_ENDPOINT_RETURNED_ATTRIBUTES_DOC);
        conf.define(CAMEL_SINK_LDAP_ENDPOINT_SCOPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LDAP_ENDPOINT_SCOPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LDAP_ENDPOINT_SCOPE_DOC);
        conf.define(CAMEL_SINK_LDAP_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LDAP_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LDAP_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_LDAP_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LDAP_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LDAP_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}