/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.AntlrDnTokenTypes;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.ExpansibleByteBuffer;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.Unicode;

public class AntlrDnParser
extends LLkParser
implements AntlrDnTokenTypes {
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "COMMA", "EQUALS", "PLUS", "HYPHEN", "UNDERSCORE", "DQUOTE", "SEMI", "LANGLE", "RANGLE", "SPACE", "NUMERICOID_OR_ALPHA_OR_DIGIT", "NUMERICOID", "DOT", "NUMBER", "LDIGIT", "DIGIT", "ALPHA", "HEXPAIR_OR_ESCESC_ESCSHARP_OR_ESC", "HEXPAIR", "ESC", "ESCESC", "ESCSHARP", "HEX", "HEXVALUE_OR_SHARP", "HEXVALUE", "SHARP", "UTFMB", "CHAR_REST"};
    public static final BitSet _tokenSet_0 = new BitSet(AntlrDnParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(AntlrDnParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(AntlrDnParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(AntlrDnParser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(AntlrDnParser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(AntlrDnParser.mk_tokenSet_5());

    private void matchedProduction(String msg) {
    }

    protected AntlrDnParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrDnParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 3);
    }

    protected AntlrDnParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrDnParser(TokenStream lexer) {
        this(lexer, 3);
    }

    public AntlrDnParser(ParserSharedInputState state) {
        super(state, 3);
        this.tokenNames = _tokenNames;
    }

    public final void distinguishedName(SchemaManager schemaManager, Dn dn) throws RecognitionException, TokenStreamException {
        this.matchedProduction("distinguishedName()");
        Rdn rdn = new Rdn(schemaManager);
        switch (this.LA(1)) {
            case 13: 
            case 15: 
            case 20: {
                this.relativeDistinguishedName(schemaManager, rdn);
                try {
                    dn.add(rdn);
                }
                catch (LdapInvalidDnException ldapInvalidDnException) {
                    // empty catch block
                }
                while (this.LA(1) == 4 || this.LA(1) == 10) {
                    switch (this.LA(1)) {
                        case 4: {
                            this.match(4);
                            break;
                        }
                        case 10: {
                            this.match(10);
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    rdn = new Rdn(schemaManager);
                    this.relativeDistinguishedName(schemaManager, rdn);
                    try {
                        dn.add(rdn);
                    }
                    catch (LdapInvalidDnException ldapInvalidDnException) {}
                }
                this.match(1);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void relativeDistinguishedName(SchemaManager schemaManager, Rdn rdn) throws RecognitionException, TokenStreamException {
        this.matchedProduction("relativeDistinguishedName()");
        StringBuilder rdnStr = new StringBuilder();
        StringBuilder rdnNormStr = new StringBuilder();
        int avaPos = 0;
        String tmp = this.attributeTypeAndValue(schemaManager, rdn);
        rdnStr.append(tmp);
        Ava currentAva = rdn.getAva(avaPos);
        AttributeType attributeType = currentAva.getAttributeType();
        if (schemaManager == null) {
            rdnNormStr.append(currentAva.getNormType());
            rdnNormStr.append('=');
        }
        Value val = currentAva.getValue();
        if (schemaManager == null && val != null && val.getNormalized() != null) {
            rdnNormStr.append(val.getNormalized());
        }
        while (this.LA(1) == 6) {
            this.match(6);
            rdnStr.append('+');
            if (schemaManager == null) {
                rdnNormStr.append('+');
            }
            tmp = this.attributeTypeAndValue(schemaManager, rdn);
            rdnStr.append(tmp);
            currentAva = rdn.getAva(++avaPos);
            attributeType = currentAva.getAttributeType();
            if (schemaManager == null) {
                rdnNormStr.append(tmp);
                rdnNormStr.append('=');
            }
            val = currentAva.getValue();
            if (schemaManager != null || val == null || val.getNormalized() == null) continue;
            rdnNormStr.append(val.getNormalized());
        }
        rdn.hashCode();
        rdn.setUpName(rdnStr.toString());
        if (schemaManager != null) {
            boolean isFirst = true;
            for (Ava ava : rdn) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    rdnNormStr.append('+');
                }
                rdnNormStr.append(ava.getAttributeType().getOid());
                rdnNormStr.append('=');
                val = ava.getValue();
                if (val == null || val.getNormalized() == null) continue;
                rdnNormStr.append(val.getNormalized());
            }
        }
        rdn.setNormName(rdnNormStr.toString());
    }

    public final String relativeDistinguishedNames(SchemaManager schemaManager, List<Rdn> rdns) throws RecognitionException, TokenStreamException {
        this.matchedProduction("relativeDistinguishedNames()");
        Rdn rdn = new Rdn(schemaManager);
        StringBuilder dnNormSb = new StringBuilder();
        switch (this.LA(1)) {
            case 13: 
            case 15: 
            case 20: {
                this.relativeDistinguishedName(schemaManager, rdn);
                rdns.add(rdn);
                dnNormSb.append(rdn.getNormName());
                rdn = new Rdn(schemaManager);
                while (this.LA(1) == 4 || this.LA(1) == 10) {
                    switch (this.LA(1)) {
                        case 4: {
                            this.match(4);
                            break;
                        }
                        case 10: {
                            this.match(10);
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.relativeDistinguishedName(schemaManager, rdn);
                    rdns.add(rdn);
                    dnNormSb.append(',');
                    dnNormSb.append(rdn.getNormName());
                    rdn = new Rdn(schemaManager);
                }
                this.match(1);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        String normNameStr = dnNormSb.toString();
        return normNameStr;
    }

    public final String attributeTypeAndValue(SchemaManager schemaManager, Rdn rdn) throws RecognitionException, TokenStreamException {
        this.matchedProduction("attributeTypeAndValue()");
        String type = null;
        UpAndNormValue value = new UpAndNormValue();
        StringBuilder rdnUpName = new StringBuilder();
        while (this.LA(1) == 13) {
            this.match(13);
            rdnUpName.append(' ');
        }
        type = this.attributeType();
        rdnUpName.append(type);
        while (this.LA(1) == 13) {
            this.match(13);
            rdnUpName.append(' ');
        }
        this.match(5);
        rdnUpName.append('=');
        while (this.LA(1) == 13 && _tokenSet_0.member(this.LA(2)) && _tokenSet_1.member(this.LA(3))) {
            this.match(13);
            rdnUpName.append(' ');
        }
        this.attributeValue(value);
        try {
            rdnUpName.append((CharSequence)value.upValue);
            AttributeType attributeType = null;
            Ava ava = null;
            if (schemaManager != null) {
                if (type.startsWith("oid.") || type.startsWith("OID.")) {
                    type = type.substring(4);
                }
                attributeType = schemaManager.getAttributeType(type);
            }
            if (attributeType != null && attributeType.isHR() || value.isHR) {
                int valueLength = value.upValue.length();
                int pos = value.bytes.position();
                for (int i = valueLength - 1; i >= 0 && value.upValue.charAt(i) == ' '; --i) {
                    if (i == 0) {
                        ava = new Ava(schemaManager, type, rdnUpName.toString(), (String)null);
                        break;
                    }
                    if (value.upValue.charAt(i - 1) == '\\') break;
                    value.upValue.deleteCharAt(i);
                    value.bytes.position(--pos);
                }
                if (ava == null) {
                    ava = new Ava(schemaManager, type, rdnUpName.toString(), Strings.utf8ToString((byte[])value.bytes.copyOfUsedBytes()));
                }
            } else {
                ava = new Ava(schemaManager, type, rdnUpName.toString(), value.bytes.copyOfUsedBytes());
            }
            rdn.addAVA(schemaManager, ava);
        }
        catch (LdapInvalidDnException e) {
            throw new SemanticException(e.getMessage());
        }
        while (this.LA(1) == 13) {
            this.match(13);
            rdnUpName.append(' ');
        }
        String upNameStr = rdnUpName.toString();
        return upNameStr;
    }

    public final String attributeType() throws RecognitionException, TokenStreamException {
        String attributeType;
        this.matchedProduction("attributeType()");
        switch (this.LA(1)) {
            case 20: {
                attributeType = this.descr();
                break;
            }
            case 15: {
                attributeType = this.numericoid();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return attributeType;
    }

    public final void attributeValue(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        this.matchedProduction("attributeValue()");
        switch (this.LA(1)) {
            case 9: {
                this.quotestring(value);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                this.string(value);
                break;
            }
            case 28: {
                this.hexstring(value);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 13: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final String descr() throws RecognitionException, TokenStreamException {
        Token leadkeychar = null;
        Token alpha = null;
        Token digit = null;
        this.matchedProduction("descr()");
        StringBuilder descrSb = new StringBuilder();
        leadkeychar = this.LT(1);
        this.match(20);
        descrSb.append(leadkeychar.getText());
        block6: while (true) {
            switch (this.LA(1)) {
                case 20: {
                    alpha = this.LT(1);
                    this.match(20);
                    descrSb.append(alpha.getText());
                    continue block6;
                }
                case 19: {
                    digit = this.LT(1);
                    this.match(19);
                    descrSb.append(digit.getText());
                    continue block6;
                }
                case 7: {
                    this.match(7);
                    descrSb.append('-');
                    continue block6;
                }
                case 8: {
                    this.match(8);
                    descrSb.append('_');
                    continue block6;
                }
            }
            break;
        }
        String descr = descrSb.toString();
        return descr;
    }

    public final String numericoid() throws RecognitionException, TokenStreamException {
        String numericoid = "";
        Token noid = null;
        this.matchedProduction("numericoid()");
        noid = this.LT(1);
        this.match(15);
        numericoid = noid.getText();
        return numericoid;
    }

    public final void quotestring(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token s = null;
        this.matchedProduction("quotestring()");
        this.match(9);
        value.upValue.append('\"');
        block4: while (true) {
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    s = this.LT(1);
                    this.match(_tokenSet_2);
                    value.upValue.append(s.getText());
                    value.bytes.append(Strings.getBytesUtf8((String)s.getText()));
                    continue block4;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.pair(value);
                    continue block4;
                }
            }
            break;
        }
        this.match(9);
        value.upValue.append('\"');
    }

    public final void string(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        this.matchedProduction("string()");
        switch (this.LA(1)) {
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 20: 
            case 31: {
                this.lutf1(value);
                break;
            }
            case 30: {
                this.utfmb(value);
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.pair(value);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block9: while (true) {
            switch (this.LA(1)) {
                case 30: {
                    this.utfmb(value);
                    continue block9;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.pair(value);
                    continue block9;
                }
            }
            if (!_tokenSet_3.member(this.LA(1)) || !_tokenSet_4.member(this.LA(2)) || !_tokenSet_5.member(this.LA(3))) break;
            this.sutf1(value);
        }
    }

    public final void hexstring(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token hexValue = null;
        this.matchedProduction("hexstring()");
        hexValue = this.LT(1);
        this.match(28);
        String hexStr = hexValue.getText();
        value.upValue.append('#').append(hexStr);
        value.bytes.append(Strings.toByteArray((String)hexStr));
        value.isHR = false;
    }

    public final void pair(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token hexpair = null;
        this.matchedProduction("pair()");
        switch (this.LA(1)) {
            case 24: {
                this.match(24);
                value.upValue.append("\\\\");
                value.bytes.append(92);
                break;
            }
            case 25: {
                this.match(25);
                value.upValue.append("\\#");
                value.bytes.append(35);
                break;
            }
            case 23: {
                this.match(23);
                char specialChar = this.special();
                value.upValue.append('\\').append(specialChar);
                value.bytes.append((int)specialChar);
                break;
            }
            case 22: {
                hexpair = this.LT(1);
                this.match(22);
                value.upValue.append('\\').append(hexpair.getText());
                value.bytes.append(Strings.toByteArray((String)hexpair.getText()));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void lutf1(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token rest = null;
        Token digit = null;
        Token alpha = null;
        Token numericoid = null;
        this.matchedProduction("lutf1()");
        switch (this.LA(1)) {
            case 31: {
                rest = this.LT(1);
                this.match(31);
                char c = rest.getText().charAt(0);
                value.upValue.append(c);
                value.bytes.append((byte)c);
                break;
            }
            case 5: {
                this.match(5);
                value.upValue.append('=');
                value.bytes.append(61);
                break;
            }
            case 7: {
                this.match(7);
                value.upValue.append('-');
                value.bytes.append(45);
                break;
            }
            case 8: {
                this.match(8);
                value.upValue.append('_');
                value.bytes.append(95);
                break;
            }
            case 19: {
                digit = this.LT(1);
                this.match(19);
                char c = digit.getText().charAt(0);
                value.upValue.append(c);
                value.bytes.append((byte)c);
                break;
            }
            case 20: {
                alpha = this.LT(1);
                this.match(20);
                char c = alpha.getText().charAt(0);
                value.upValue.append(c);
                value.bytes.append((byte)c);
                break;
            }
            case 15: {
                numericoid = this.LT(1);
                this.match(15);
                String number = numericoid.getText();
                value.upValue.append(number);
                value.bytes.append(Strings.getBytesUtf8((String)number));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void utfmb(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token s = null;
        this.matchedProduction("utfmb()");
        s = this.LT(1);
        this.match(30);
        char c = s.getText().charAt(0);
        value.upValue.append(c);
        value.bytes.append(Unicode.charToBytes((char)c));
    }

    public final void sutf1(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token rest = null;
        Token digit = null;
        Token alpha = null;
        Token hex = null;
        Token numericoid = null;
        this.matchedProduction("sutf1()");
        switch (this.LA(1)) {
            case 31: {
                rest = this.LT(1);
                this.match(31);
                char c = rest.getText().charAt(0);
                value.upValue.append(c);
                value.bytes.append((byte)c);
                break;
            }
            case 5: {
                this.match(5);
                value.upValue.append('=');
                value.bytes.append(61);
                break;
            }
            case 7: {
                this.match(7);
                value.upValue.append('-');
                value.bytes.append(45);
                break;
            }
            case 8: {
                this.match(8);
                value.upValue.append('_');
                value.bytes.append(95);
                break;
            }
            case 19: {
                digit = this.LT(1);
                this.match(19);
                char c = digit.getText().charAt(0);
                value.upValue.append(c);
                value.bytes.append((byte)c);
                break;
            }
            case 20: {
                alpha = this.LT(1);
                this.match(20);
                char c = alpha.getText().charAt(0);
                value.upValue.append(c);
                value.bytes.append((byte)c);
                break;
            }
            case 29: {
                this.match(29);
                value.upValue.append('#');
                value.bytes.append(35);
                break;
            }
            case 13: {
                this.match(13);
                value.upValue.append(' ');
                value.bytes.append(32);
                break;
            }
            case 28: {
                hex = this.LT(1);
                this.match(28);
                String hexStr = hex.getText();
                value.upValue.append('#').append(hexStr);
                value.bytes.append(35);
                value.bytes.append(Strings.getBytesUtf8((String)hexStr));
                break;
            }
            case 15: {
                numericoid = this.LT(1);
                this.match(15);
                String number = numericoid.getText();
                value.upValue.append(number);
                value.bytes.append(Strings.getBytesUtf8((String)number));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final char special() throws RecognitionException, TokenStreamException {
        char special;
        this.matchedProduction("special()");
        switch (this.LA(1)) {
            case 9: {
                this.match(9);
                special = '\"';
                break;
            }
            case 6: {
                this.match(6);
                special = '+';
                break;
            }
            case 4: {
                this.match(4);
                special = ',';
                break;
            }
            case 10: {
                this.match(10);
                special = ';';
                break;
            }
            case 11: {
                this.match(11);
                special = '<';
                break;
            }
            case 12: {
                this.match(12);
                special = '>';
                break;
            }
            case 13: {
                this.match(13);
                special = ' ';
                break;
            }
            case 29: {
                this.match(29);
                special = '#';
                break;
            }
            case 5: {
                this.match(5);
                special = '=';
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return special;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{3554191346L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{0xFFFFFFF2L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{4232052208L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{2954404256L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{4091061746L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{4091068402L, 0L};
        return data;
    }

    private static class UpAndNormValue {
        ExpansibleByteBuffer bytes = new ExpansibleByteBuffer();
        StringBuilder upValue = new StringBuilder();
        StringBuilder normValue = new StringBuilder();
        boolean isHR = true;

        private UpAndNormValue() {
        }
    }
}

