/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;

public class ObjectClass
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    protected ObjectClassTypeEnum objectClassType = ObjectClassTypeEnum.STRUCTURAL;
    protected transient List<String> superiorOids;
    protected transient List<ObjectClass> superiors;
    protected transient List<String> mayAttributeTypeOids = new ArrayList<String>();
    protected transient List<AttributeType> mayAttributeTypes;
    protected transient List<String> mustAttributeTypeOids = new ArrayList<String>();
    protected transient List<AttributeType> mustAttributeTypes;

    public ObjectClass(String oid) {
        super(SchemaObjectType.OBJECT_CLASS, oid);
        this.superiorOids = new ArrayList<String>();
        this.mayAttributeTypes = new ArrayList<AttributeType>();
        this.mustAttributeTypes = new ArrayList<AttributeType>();
        this.superiors = new ArrayList<ObjectClass>();
        this.objectClassType = ObjectClassTypeEnum.STRUCTURAL;
    }

    public List<String> getMayAttributeTypeOids() {
        return this.mayAttributeTypeOids;
    }

    public List<AttributeType> getMayAttributeTypes() {
        return this.mayAttributeTypes;
    }

    public List<String> getMustAttributeTypeOids() {
        return this.mustAttributeTypeOids;
    }

    public List<AttributeType> getMustAttributeTypes() {
        return this.mustAttributeTypes;
    }

    public List<ObjectClass> getSuperiors() {
        return this.superiors;
    }

    public List<String> getSuperiorOids() {
        return this.superiorOids;
    }

    public ObjectClassTypeEnum getType() {
        return this.objectClassType;
    }

    public boolean isStructural() {
        return this.objectClassType == ObjectClassTypeEnum.STRUCTURAL;
    }

    public boolean isAbstract() {
        return this.objectClassType == ObjectClassTypeEnum.ABSTRACT;
    }

    public boolean isAuxiliary() {
        return this.objectClassType == ObjectClassTypeEnum.AUXILIARY;
    }

    public String toString() {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(this);
    }

    @Override
    public ObjectClass copy() {
        ObjectClass copy = new ObjectClass(this.oid);
        copy.copy(this);
        copy.objectClassType = this.objectClassType;
        copy.superiorOids = new ArrayList<String>();
        for (String oid : this.superiorOids) {
            copy.superiorOids.add(oid);
        }
        copy.superiors = new ArrayList<ObjectClass>();
        copy.mayAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.mayAttributeTypeOids) {
            copy.mayAttributeTypeOids.add(oid);
        }
        copy.mayAttributeTypes = new ArrayList<AttributeType>();
        copy.mustAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.mustAttributeTypeOids) {
            copy.mustAttributeTypeOids.add(oid);
        }
        copy.mustAttributeTypes = new ArrayList<AttributeType>();
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ObjectClass)) {
            return false;
        }
        ObjectClass that = (ObjectClass)o;
        if (this.objectClassType != that.objectClassType) {
            return false;
        }
        if (this.superiorOids.size() != that.superiorOids.size()) {
            return false;
        }
        for (String string : this.superiorOids) {
            if (that.superiorOids.contains(string)) continue;
            return false;
        }
        for (String string : that.superiorOids) {
            if (this.superiorOids.contains(string)) continue;
            return false;
        }
        if (this.superiors.size() != that.superiors.size()) {
            return false;
        }
        for (ObjectClass objectClass : this.superiors) {
            if (that.superiors.contains(objectClass)) continue;
            return false;
        }
        for (ObjectClass objectClass : that.superiors) {
            if (this.superiors.contains(objectClass)) continue;
            return false;
        }
        if (this.mayAttributeTypeOids.size() != that.mayAttributeTypeOids.size()) {
            return false;
        }
        for (String string : this.mayAttributeTypeOids) {
            if (that.mayAttributeTypeOids.contains(string)) continue;
            return false;
        }
        for (String string : that.mayAttributeTypeOids) {
            if (this.mayAttributeTypeOids.contains(string)) continue;
            return false;
        }
        if (this.mayAttributeTypes.size() != that.mayAttributeTypes.size()) {
            return false;
        }
        for (AttributeType attributeType : this.mayAttributeTypes) {
            if (that.mayAttributeTypes.contains(attributeType)) continue;
            return false;
        }
        for (AttributeType attributeType : that.mayAttributeTypes) {
            if (this.mayAttributeTypes.contains(attributeType)) continue;
            return false;
        }
        if (this.mustAttributeTypeOids.size() != that.mustAttributeTypeOids.size()) {
            return false;
        }
        for (String string : this.mustAttributeTypeOids) {
            if (that.mustAttributeTypeOids.contains(string)) continue;
            return false;
        }
        for (String string : that.mustAttributeTypeOids) {
            if (this.mustAttributeTypeOids.contains(string)) continue;
            return false;
        }
        if (this.mustAttributeTypes.size() != that.mustAttributeTypes.size()) {
            return false;
        }
        for (AttributeType attributeType : this.mustAttributeTypes) {
            if (that.mustAttributeTypes.contains(attributeType)) continue;
            return false;
        }
        for (AttributeType attributeType : that.mustAttributeTypes) {
            if (this.mustAttributeTypes.contains(attributeType)) continue;
            return false;
        }
        return true;
    }
}

