/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.cloud.ServiceChooser;
import org.apache.camel.cloud.ServiceChooserFactory;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.cloud.ServiceCallConfiguration;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="routing,cloud,service-discovery")
@XmlRootElement(name="serviceChooserConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceCallServiceChooserConfiguration
extends ServiceCallConfiguration
implements ServiceChooserFactory {
    @XmlTransient
    private final ServiceCallDefinition parent;
    @XmlTransient
    private final String factoryKey;

    public ServiceCallServiceChooserConfiguration() {
        this(null, null);
    }

    public ServiceCallServiceChooserConfiguration(ServiceCallDefinition parent, String factoryKey) {
        this.parent = parent;
        this.factoryKey = factoryKey;
    }

    public ServiceCallDefinition end() {
        return this.parent;
    }

    public ProcessorDefinition<?> endParent() {
        return this.parent.end();
    }

    @Override
    public ServiceCallServiceChooserConfiguration property(String key, String value) {
        return (ServiceCallServiceChooserConfiguration)super.property(key, value);
    }

    public ServiceChooser newInstance(CamelContext camelContext) throws Exception {
        ServiceChooser answer;
        ObjectHelper.notNull((Object)this.factoryKey, (String)"ServiceChooser factoryKey");
        ServiceChooserFactory factory = (ServiceChooserFactory)CamelContextHelper.lookup((CamelContext)camelContext, (String)this.factoryKey, ServiceChooserFactory.class);
        if (factory != null) {
            answer = (ServiceChooser)factory.newInstance(camelContext);
        } else {
            Class type;
            try {
                type = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(this.factoryKey).orElse(null);
            }
            catch (Exception e) {
                throw new NoFactoryAvailableException("META-INF/services/org/apache/camel/cloud/" + this.factoryKey, (Throwable)e);
            }
            if (type != null) {
                if (ServiceChooserFactory.class.isAssignableFrom(type)) {
                    factory = (ServiceChooserFactory)camelContext.getInjector().newInstance(type, false);
                } else {
                    throw new NoFactoryAvailableException("Resolving ServiceChooser: " + this.factoryKey + " detected type conflict: Not a ServiceChooserFactory implementation. Found: " + type.getName());
                }
            }
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getProperties((Object)this, parameters, null, false);
                parameters.replaceAll((k, v) -> {
                    if (v instanceof String) {
                        try {
                            v = camelContext.resolvePropertyPlaceholders((String)v);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Exception while resolving %s (%s)", k, v.toString()), e);
                        }
                    }
                    return v;
                });
                parameters.put("properties", this.getPropertiesAsMap(camelContext));
                this.postProcessFactoryParameters(camelContext, parameters);
                PropertyBindingSupport.build().bind(camelContext, (Object)factory, parameters);
                answer = (ServiceChooser)factory.newInstance(camelContext);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return answer;
    }
}

