/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.InputStream;
import java.io.ObjectInput;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mina.MinaConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.mina.core.buffer.IoBuffer;

public final class MinaConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        MinaConverterLoader.addTypeConverter(registry, byte[].class, IoBuffer.class, false, (type, exchange, value) -> MinaConverter.toByteArray((IoBuffer)value));
        MinaConverterLoader.addTypeConverter(registry, InputStream.class, IoBuffer.class, false, (type, exchange, value) -> MinaConverter.toInputStream((IoBuffer)value));
        MinaConverterLoader.addTypeConverter(registry, ObjectInput.class, IoBuffer.class, false, (type, exchange, value) -> MinaConverter.toObjectInput((IoBuffer)value));
        MinaConverterLoader.addTypeConverter(registry, String.class, IoBuffer.class, false, (type, exchange, value) -> MinaConverter.toString((IoBuffer)value, exchange));
        MinaConverterLoader.addTypeConverter(registry, IoBuffer.class, byte[].class, false, (type, exchange, value) -> MinaConverter.toIoBuffer((byte[])value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

