/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MinaEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":protocol:host:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "mina".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "protocol", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(32);
        props.add("basicPropertyBinding");
        props.add("disconnect");
        props.add("lazySessionCreation");
        props.add("synchronous");
        props.add("disconnectOnNoReply");
        props.add("encoderMaxLineLength");
        props.add("sslContextParameters");
        props.add("writeTimeout");
        props.add("timeout");
        props.add("protocol");
        props.add("bridgeErrorHandler");
        props.add("autoStartTls");
        props.add("host");
        props.add("noReplyLogLevel");
        props.add("transferExchange");
        props.add("textline");
        props.add("textlineDelimiter");
        props.add("exchangePattern");
        props.add("orderedThreadPoolExecutor");
        props.add("filters");
        props.add("encoding");
        props.add("sync");
        props.add("minaLogger");
        props.add("codec");
        props.add("lazyStartProducer");
        props.add("port");
        props.add("cachedAddress");
        props.add("allowDefaultCodec");
        props.add("maximumPoolSize");
        props.add("clientMode");
        props.add("decoderMaxLineLength");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

