/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.minio.ObjectConditionalReadArgs;
import io.minio.S3Escaper;
import io.minio.Time;
import io.minio.errors.InternalException;

public class ComposeSource
extends ObjectConditionalReadArgs {
    private Long objectSize = null;
    private Multimap<String, String> headers = null;

    protected ComposeSource() {
    }

    public ComposeSource(ObjectConditionalReadArgs args) {
        this.extraHeaders = args.extraHeaders;
        this.extraQueryParams = args.extraQueryParams;
        this.bucketName = args.bucketName;
        this.region = args.region;
        this.objectName = args.objectName;
        this.versionId = args.versionId;
        this.ssec = args.ssec;
        this.offset = args.offset;
        this.length = args.length;
        this.matchETag = args.matchETag;
        this.notMatchETag = args.notMatchETag;
        this.modifiedSince = args.modifiedSince;
        this.unmodifiedSince = args.unmodifiedSince;
    }

    private void throwException(long objectsize, long arg, String argName) {
        StringBuilder builder = new StringBuilder().append("source ").append(this.bucketName).append("/").append(this.objectName);
        if (this.versionId != null) {
            builder.append("?versionId=").append(this.versionId);
        }
        builder.append(": ").append(argName).append(" ").append(arg).append(" is beyond object size ").append(this.objectSize);
        throw new IllegalArgumentException(builder.toString());
    }

    private void validateSize(long objectSize) {
        if (this.offset != null && this.offset >= objectSize) {
            this.throwException(objectSize, this.offset, "offset");
        }
        if (this.length != null) {
            if (this.length > objectSize) {
                this.throwException(objectSize, this.length, "length");
            }
            if (this.offset + this.length > objectSize) {
                this.throwException(objectSize, this.offset + this.length, "compose size");
            }
        }
    }

    public void buildHeaders(long objectSize, String etag) {
        this.validateSize(objectSize);
        this.objectSize = objectSize;
        String copySource = S3Escaper.encodePath(this.bucketName + "/" + this.objectName);
        if (this.versionId != null) {
            copySource = copySource + "?versionId=" + S3Escaper.encode(this.versionId);
        }
        HashMultimap headers = HashMultimap.create();
        headers.put((Object)"x-amz-copy-source", (Object)copySource);
        headers.put((Object)"x-amz-copy-source-if-match", (Object)(this.matchETag != null ? this.matchETag : etag));
        if (this.notMatchETag != null) {
            headers.put((Object)"x-amz-copy-source-if-none-match", (Object)this.notMatchETag);
        }
        if (this.modifiedSince != null) {
            headers.put((Object)"x-amz-copy-source-if-modified-since", (Object)this.modifiedSince.format(Time.HTTP_HEADER_DATE_FORMAT));
        }
        if (this.unmodifiedSince != null) {
            headers.put((Object)"x-amz-copy-source-if-unmodified-since", (Object)this.unmodifiedSince.format(Time.HTTP_HEADER_DATE_FORMAT));
        }
        if (this.ssec != null) {
            headers.putAll((Multimap)Multimaps.forMap(this.ssec.copySourceHeaders()));
        }
        this.headers = Multimaps.unmodifiableMultimap((Multimap)headers);
    }

    public long objectSize() throws InternalException {
        if (this.objectSize == null) {
            throw new InternalException("buildHeaders(long objectSize, String etag) must be called prior to this method invocation");
        }
        return this.objectSize;
    }

    public Multimap<String, String> headers() throws InternalException {
        if (this.headers == null) {
            throw new InternalException("buildHeaders(long objectSize, String etag) must be called prior to this method invocation");
        }
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ObjectConditionalReadArgs.Builder<Builder, ComposeSource> {
    }
}

