/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.BucketArgs;

public class ListIncompleteUploadsArgs
extends BucketArgs {
    private String prefix;
    private String delimiter;
    private String keyMarker;
    private Integer maxUploads;
    private String uploadIdMarker;
    private boolean recursive;

    public String prefix() {
        return this.prefix;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public Integer maxUploads() {
        return this.maxUploads;
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public boolean recursive() {
        return this.recursive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BucketArgs.Builder<Builder, ListIncompleteUploadsArgs> {
        public Builder prefix(String prefix) {
            this.operations.add(args -> ((ListIncompleteUploadsArgs)args).prefix = prefix);
            return this;
        }

        public Builder delimitter(String delimiter) {
            this.operations.add(args -> ((ListIncompleteUploadsArgs)args).delimiter = delimiter);
            return this;
        }

        public Builder keyMarker(String keyMarker) {
            this.validateNullOrNotEmptyString(keyMarker, "keyMarker");
            this.operations.add(args -> ((ListIncompleteUploadsArgs)args).keyMarker = keyMarker);
            return this;
        }

        public Builder maxUploads(int maxUploads) {
            if (maxUploads < 1 || maxUploads > 1000) {
                throw new IllegalArgumentException("maxUploads must be minimum 1 to maximum 1000");
            }
            this.operations.add(args -> ((ListIncompleteUploadsArgs)args).maxUploads = maxUploads);
            return this;
        }

        public Builder uploadIdMarker(String uploadIdMarker) {
            this.validateNullOrNotEmptyString(uploadIdMarker, "uploadIdMarker");
            this.operations.add(args -> ((ListIncompleteUploadsArgs)args).uploadIdMarker = uploadIdMarker);
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.operations.add(args -> ((ListIncompleteUploadsArgs)args).recursive = recursive);
            return this;
        }
    }
}

