/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioEndpoint;
import org.apache.camel.component.minio.MinioOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MinioProducer.class);
    private transient String minioProducerToString;

    public MinioProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    public void process(Exchange exchange) throws Exception {
        MinioOperations operation = this.determineOperation(exchange);
        MinioClient minioClient = this.getEndpoint().getMinioClient();
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            this.putObject(minioClient, exchange);
        } else {
            switch (operation) {
                case copyObject: {
                    this.copyObject(minioClient, exchange);
                    break;
                }
                case deleteObject: {
                    this.deleteObject(minioClient, exchange);
                    break;
                }
                case deleteObjects: {
                    this.deleteObjects(minioClient, exchange);
                    break;
                }
                case listBuckets: {
                    this.listBuckets(minioClient, exchange);
                    break;
                }
                case deleteBucket: {
                    this.deleteBucket(minioClient, exchange);
                    break;
                }
                case listObjects: {
                    this.listObjects(minioClient, exchange);
                    break;
                }
                case getObject: {
                    this.getObject(minioClient, exchange);
                    break;
                }
                case getPartialObject: {
                    this.getPartialObject(minioClient, exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    public void putObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            PutObjectArgs.Builder payload = (PutObjectArgs.Builder)exchange.getIn().getMandatoryBody(PutObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty((Object)payload)) {
                ObjectWriteResponse putObjectResult = minioClient.putObject((PutObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setHeader("CamelMinioETag", (Object)putObjectResult.etag());
                if (ObjectHelper.isNotEmpty((Object)putObjectResult.versionId())) {
                    message.setHeader("CamelMinioVersionId", (Object)putObjectResult.versionId());
                }
            }
        } else {
            InputStream inputStream;
            String bucketName = this.determineBucketName(exchange);
            String objectName = this.determineObjectName(exchange);
            Map<String, String> objectMetadata = this.determineMetadata(exchange);
            Map<String, String> extraHeaders = this.determineExtraHeaders(exchange);
            File filePayload = null;
            Object object = exchange.getIn().getMandatoryBody();
            if (object instanceof WrappedFile) {
                object = ((WrappedFile)object).getFile();
            }
            if (object instanceof File) {
                filePayload = (File)object;
                inputStream = new FileInputStream(filePayload);
            } else {
                inputStream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                if (objectMetadata.containsKey("Content-Length")) {
                    if (objectMetadata.get("Content-Length").equals("0") && ObjectHelper.isEmpty((Object)exchange.getProperty("Content-Length"))) {
                        LOG.debug("The content length is not defined. It needs to be determined by reading the data into memory");
                        ByteArrayOutputStream baos = this.determineLengthInputStream(inputStream);
                        objectMetadata.put("Content-Length", String.valueOf(baos.size()));
                        inputStream = new ByteArrayInputStream(baos.toByteArray());
                    } else if (ObjectHelper.isNotEmpty((Object)exchange.getProperty("Content-Length"))) {
                        objectMetadata.put("Content-Length", (String)exchange.getProperty("Content-Length", String.class));
                    }
                }
            }
            PutObjectArgs.Builder putObjectRequest = (PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().stream(inputStream, (long)inputStream.available(), -1L).bucket(bucketName)).object(objectName)).userMetadata(objectMetadata);
            if (!extraHeaders.isEmpty()) {
                putObjectRequest.extraHeaders(extraHeaders);
            }
            LOG.trace("Put object from exchange...");
            ObjectWriteResponse putObjectResult = this.getEndpoint().getMinioClient().putObject((PutObjectArgs)putObjectRequest.build());
            LOG.trace("Received result...");
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setHeader("CamelMinioETag", (Object)putObjectResult.etag());
            if (ObjectHelper.isNotEmpty((Object)putObjectResult.versionId())) {
                message.setHeader("CamelMinioVersionId", (Object)putObjectResult.versionId());
            }
            IOHelper.close((Closeable)inputStream);
            if (this.getConfiguration().isDeleteAfterWrite() && ObjectHelper.isNotEmpty((Object)filePayload)) {
                FileUtil.deleteFile((File)filePayload);
            }
        }
    }

    private Map<String, String> determineExtraHeaders(Exchange exchange) {
        String cannedAcl;
        HashMap<String, String> extraHeaders = new HashMap<String, String>();
        String storageClass = this.determineStorageClass(exchange);
        if (ObjectHelper.isNotEmpty((Object)storageClass)) {
            extraHeaders.put("X-Amz-Storage-Class", storageClass);
        }
        if (ObjectHelper.isNotEmpty((Object)(cannedAcl = (String)exchange.getIn().getHeader("CamelMinioCannedAcl", String.class)))) {
            extraHeaders.put("x-amz-acl", cannedAcl);
        }
        return extraHeaders;
    }

    private void copyObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            CopyObjectArgs.Builder payload = (CopyObjectArgs.Builder)exchange.getIn().getMandatoryBody(CopyObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty((Object)payload)) {
                ObjectWriteResponse result = minioClient.copyObject((CopyObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String sourceKey = this.determineObjectName(exchange);
            String destinationKey = (String)exchange.getIn().getHeader("CamelMinioDestinationObjectName", String.class);
            String destinationBucketName = (String)exchange.getIn().getHeader("CamelMinioDestinationBucketName", String.class);
            if (ObjectHelper.isEmpty((Object)destinationBucketName)) {
                throw new IllegalArgumentException("Bucket Name Destination must be specified for copyObject Operation");
            }
            if (ObjectHelper.isEmpty((Object)destinationKey)) {
                throw new IllegalArgumentException("Destination Key must be specified for copyObject Operation");
            }
            CopySource.Builder copySourceBuilder = (CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(bucketName)).object(sourceKey);
            CopyObjectArgs.Builder copyObjectRequest = ((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(destinationBucketName)).object(destinationKey)).source((CopySource)copySourceBuilder.build());
            ObjectWriteResponse copyObjectResult = minioClient.copyObject((CopyObjectArgs)copyObjectRequest.build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            if (ObjectHelper.isNotEmpty((Object)copyObjectResult.versionId())) {
                message.setHeader("CamelMinioVersionId", (Object)copyObjectResult.versionId());
            }
        }
    }

    private void deleteObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            RemoveObjectArgs.Builder payload = (RemoveObjectArgs.Builder)exchange.getIn().getMandatoryBody(RemoveObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty((Object)payload)) {
                minioClient.removeObject((RemoveObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody((Object)true);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String sourceKey = this.determineObjectName(exchange);
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(sourceKey)).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody((Object)true);
        }
    }

    private void deleteObjects(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            RemoveObjectsArgs.Builder payload = (RemoveObjectsArgs.Builder)exchange.getIn().getMandatoryBody(RemoveObjectsArgs.Builder.class);
            if (ObjectHelper.isNotEmpty((Object)payload)) {
                minioClient.removeObjects((RemoveObjectsArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody((Object)true);
            }
        } else {
            throw new IllegalArgumentException("Cannot delete multiple objects without a POJO request");
        }
    }

    private void listBuckets(MinioClient minioClient, Exchange exchange) throws Exception {
        List bucketsList = minioClient.listBuckets();
        Message message = MinioProducer.getMessageForResponse(exchange);
        message.setBody(bucketsList.iterator());
    }

    private void deleteBucket(MinioClient minioClient, Exchange exchange) throws Exception {
        String bucketName = this.determineBucketName(exchange);
        if (this.getConfiguration().isPojoRequest()) {
            RemoveBucketArgs.Builder payload = (RemoveBucketArgs.Builder)exchange.getIn().getMandatoryBody(RemoveBucketArgs.Builder.class);
            if (ObjectHelper.isNotEmpty((Object)payload)) {
                minioClient.removeBucket((RemoveBucketArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody((Object)"ok");
            }
        } else {
            minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody((Object)"ok");
        }
    }

    private void getObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            GetObjectArgs.Builder payload = (GetObjectArgs.Builder)exchange.getIn().getMandatoryBody(GetObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty((Object)payload)) {
                InputStream respond = minioClient.getObject((GetObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody((Object)respond);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String sourceKey = this.determineObjectName(exchange);
            InputStream respond = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(sourceKey)).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody((Object)respond);
        }
    }

    private void getPartialObject(MinioClient minioClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            GetObjectArgs.Builder payload = (GetObjectArgs.Builder)exchange.getIn().getMandatoryBody(GetObjectArgs.Builder.class);
            if (ObjectHelper.isNotEmpty((Object)payload)) {
                InputStream respond = minioClient.getObject((GetObjectArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody((Object)respond);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            String sourceKey = this.determineObjectName(exchange);
            String offset = (String)exchange.getIn().getHeader("CamelMinioOffset", String.class);
            String length = (String)exchange.getIn().getHeader("CamelMinioLength", String.class);
            if (ObjectHelper.isEmpty((Object)offset) || ObjectHelper.isEmpty((Object)length)) {
                throw new IllegalArgumentException("A Offset and length header must be configured to perform a partial get operation.");
            }
            InputStream respond = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(sourceKey)).offset(Long.valueOf(Long.parseLong(offset)))).length(Long.valueOf(Long.parseLong(length)))).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody((Object)respond);
        }
    }

    private void listObjects(MinioClient minioClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            ListObjectsArgs.Builder payload = (ListObjectsArgs.Builder)exchange.getIn().getMandatoryBody(ListObjectsArgs.Builder.class);
            if (ObjectHelper.isNotEmpty((Object)payload)) {
                Iterable objectList = minioClient.listObjects((ListObjectsArgs)payload.build());
                Message message = MinioProducer.getMessageForResponse(exchange);
                message.setBody((Object)objectList);
            }
        } else {
            String bucketName = this.determineBucketName(exchange);
            Iterable objectList = minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
            Message message = MinioProducer.getMessageForResponse(exchange);
            message.setBody((Object)objectList);
        }
    }

    private MinioOperations determineOperation(Exchange exchange) {
        MinioOperations operation = (MinioOperations)((Object)exchange.getIn().getHeader("CamelMinioOperation", MinioOperations.class));
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    private Map<String, String> determineMetadata(Exchange exchange) {
        String contentMD5;
        String contentEncoding;
        String contentDisposition;
        String cacheControl;
        String contentType;
        HashMap<String, String> objectMetadata = new HashMap<String, String>();
        Long contentLength = (Long)exchange.getIn().getHeader("CamelMinioContentLength", Long.class);
        if (ObjectHelper.isNotEmpty((Object)contentLength)) {
            objectMetadata.put("Content-Length", String.valueOf(contentLength));
        }
        if (ObjectHelper.isNotEmpty((Object)(contentType = (String)exchange.getIn().getHeader("CamelMinioContentType", String.class)))) {
            objectMetadata.put("Content-Type", contentType);
        }
        if (ObjectHelper.isNotEmpty((Object)(cacheControl = (String)exchange.getIn().getHeader("CamelMinioContentControl", String.class)))) {
            objectMetadata.put("Cache-Control", cacheControl);
        }
        if (ObjectHelper.isNotEmpty((Object)(contentDisposition = (String)exchange.getIn().getHeader("CamelMinioContentDisposition", String.class)))) {
            objectMetadata.put("Content-Disposition", contentDisposition);
        }
        if (ObjectHelper.isNotEmpty((Object)(contentEncoding = (String)exchange.getIn().getHeader("CamelMinioContentEncoding", String.class)))) {
            objectMetadata.put("Content-Encoding", contentEncoding);
        }
        if (ObjectHelper.isNotEmpty((Object)(contentMD5 = (String)exchange.getIn().getHeader("CamelMinioContentMD5", String.class)))) {
            objectMetadata.put("Content-Md5", contentMD5);
        }
        return objectMetadata;
    }

    private String determineBucketName(Exchange exchange) {
        String bucketName = (String)exchange.getIn().getHeader("CamelMinioBucketName", String.class);
        if (ObjectHelper.isEmpty((Object)bucketName)) {
            if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getBucketName())) {
                bucketName = this.getConfiguration().getBucketName();
                LOG.trace("Minio Bucket name header is missing, using default one {}", (Object)bucketName);
            } else {
                throw new IllegalArgumentException("Minio Bucket name header is missing or not configured.");
            }
        }
        return bucketName;
    }

    private String determineObjectName(Exchange exchange) {
        String objectName = (String)exchange.getIn().getHeader("CamelMinioObjectName", String.class);
        if (ObjectHelper.isEmpty((Object)objectName)) {
            objectName = this.getConfiguration().getKeyName();
        }
        if (ObjectHelper.isEmpty((Object)objectName)) {
            throw new IllegalArgumentException("Minio Key header is missing.");
        }
        return objectName;
    }

    private String determineStorageClass(Exchange exchange) {
        String storageClass = (String)exchange.getIn().getHeader("CamelMinioStorageClass", String.class);
        if (ObjectHelper.isEmpty((Object)storageClass)) {
            storageClass = this.getConfiguration().getStorageClass();
        }
        return storageClass;
    }

    private ByteArrayOutputStream determineLengthInputStream(InputStream inputStream) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((count = inputStream.read(bytes)) > 0) {
            out.write(bytes, 0, count);
        }
        return out;
    }

    protected MinioConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (ObjectHelper.isEmpty((Object)this.minioProducerToString)) {
            this.minioProducerToString = "MinioProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.minioProducerToString;
    }

    public MinioEndpoint getEndpoint() {
        return (MinioEndpoint)super.getEndpoint();
    }
}

