/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.CopySource;
import io.minio.Directive;
import io.minio.ObjectWriteArgs;
import okhttp3.HttpUrl;

public class CopyObjectArgs
extends ObjectWriteArgs {
    private CopySource source = null;
    private Directive metadataDirective;
    private Directive taggingDirective;

    public CopySource source() {
        return this.source;
    }

    public Directive metadataDirective() {
        return this.metadataDirective;
    }

    public Directive taggingDirective() {
        return this.taggingDirective;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validateSse(HttpUrl url) {
        super.validateSse(url);
        this.source.validateSsec(url);
    }

    public static final class Builder
    extends ObjectWriteArgs.Builder<Builder, CopyObjectArgs> {
        @Override
        protected void validate(CopyObjectArgs args) {
            super.validate(args);
            this.validateNotNull(args.source, "copy source");
            if (args.source.offset() != null || args.source.length() != null) {
                if (args.metadataDirective != null && args.metadataDirective == Directive.COPY) {
                    throw new IllegalArgumentException("COPY metadata directive is not applicable to source object with range");
                }
                if (args.taggingDirective != null && args.taggingDirective == Directive.COPY) {
                    throw new IllegalArgumentException("COPY tagging directive is not applicable to source object with range");
                }
            }
        }

        public Builder source(CopySource source) {
            this.validateNotNull(source, "copy source");
            this.operations.add(args -> ((CopyObjectArgs)args).source = source);
            return this;
        }

        public Builder metadataDirective(Directive directive) {
            this.operations.add(args -> ((CopyObjectArgs)args).metadataDirective = directive);
            return this;
        }

        public Builder taggingDirective(Directive directive) {
            this.operations.add(args -> ((CopyObjectArgs)args).taggingDirective = directive);
            return this;
        }
    }
}

