/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.BucketArgs;
import io.minio.messages.Tags;
import java.util.Map;

public class SetBucketTagsArgs
extends BucketArgs {
    private Tags tags;

    public Tags tags() {
        return this.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BucketArgs.Builder<Builder, SetBucketTagsArgs> {
        private void validateTags(Tags tags) {
            this.validateNotNull(tags, "tags");
        }

        @Override
        protected void validate(SetBucketTagsArgs args) {
            super.validate(args);
            this.validateTags(args.tags);
        }

        public Builder tags(Map<String, String> map) {
            this.validateNotNull(map, "map for tags");
            this.operations.add(args -> ((SetBucketTagsArgs)args).tags = Tags.newBucketTags(map));
            return this;
        }

        public Builder tags(Tags tags) {
            this.validateTags(tags);
            this.operations.add(args -> ((SetBucketTagsArgs)args).tags = tags);
            return this;
        }
    }
}

