/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.errors.InvalidBucketNameException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.minio.MinioChecks;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioConsumer;
import org.apache.camel.component.minio.MinioProducer;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.5.0", scheme="minio", title="Minio", syntax="minio:bucketName", category={Category.CLOUD, Category.FILE})
public class MinioEndpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MinioEndpoint.class);
    private MinioClient minioClient;
    @UriParam
    private MinioConfiguration configuration;

    public MinioEndpoint(String uri, Component component, MinioConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        MinioConsumer minioConsumer = new MinioConsumer(this, processor);
        this.configureConsumer((Consumer)minioConsumer);
        minioConsumer.setMaxMessagesPerPoll(this.configuration.getMaxMessagesPerPoll());
        return minioConsumer;
    }

    public Producer createProducer() {
        return new MinioProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.minioClient = ObjectHelper.isNotEmpty((Object)this.getConfiguration().getMinioClient()) ? this.getConfiguration().getMinioClient() : this.createMinioClient();
        String objectName = this.getConfiguration().getObjectName();
        if (ObjectHelper.isNotEmpty((Object)objectName)) {
            LOG.trace("Object name {} requested, so skipping bucket check...", (Object)objectName);
            return;
        }
        String bucketName = this.getConfiguration().getBucketName();
        LOG.trace("Querying whether bucket {} already exists...", (Object)bucketName);
        if (this.bucketExists(bucketName)) {
            LOG.trace("Bucket {} already exists", (Object)bucketName);
        } else if (this.getConfiguration().isAutoCreateBucket()) {
            LOG.trace("AutoCreateBucket set to true, Creating bucket {}...", (Object)bucketName);
            this.makeBucket(bucketName);
            LOG.trace("Bucket created");
        } else {
            throw new InvalidBucketNameException("Bucket {} does not exists, set autoCreateBucket option for bucket auto creation", bucketName);
        }
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getPolicy())) {
            LOG.trace("Updating bucket {} with policy {}", (Object)bucketName, (Object)this.configuration.getPolicy());
            this.setBucketPolicy(bucketName);
            LOG.trace("Bucket policy updated");
        }
    }

    public void doStop() throws Exception {
        super.doStop();
    }

    public Exchange createExchange(InputStream minioObject, String objectName) throws Exception {
        return this.createExchange(this.getExchangePattern(), minioObject, objectName);
    }

    public Exchange createExchange(ExchangePattern pattern, final InputStream minioObject, String objectName) throws Exception {
        LOG.trace("Getting object with objectName {} from bucket {}...", (Object)objectName, (Object)this.getConfiguration().getBucketName());
        Exchange exchange = super.createExchange(pattern);
        Message message = exchange.getIn();
        LOG.trace("Got object!");
        this.getObjectStat(objectName, message);
        if (this.getConfiguration().isIncludeBody()) {
            message.setBody((Object)this.readInputStream(minioObject));
            if (this.getConfiguration().isAutoCloseBody()) {
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new SynchronizationAdapter(){

                    public void onDone(Exchange exchange) {
                        IOHelper.close((Closeable)minioObject);
                    }
                });
            }
        } else {
            message.setBody(null);
            IOHelper.close((Closeable)minioObject);
        }
        return exchange;
    }

    public MinioConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinioConfiguration configuration) {
        this.configuration = configuration;
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    MinioClient createMinioClient() {
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getEndpoint())) {
            MinioClient.Builder minioClientRequest = MinioClient.builder();
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
                minioClientRequest.endpoint(this.configuration.getEndpoint(), this.configuration.getProxyPort().intValue(), this.configuration.isSecure());
            } else {
                minioClientRequest.endpoint(this.configuration.getEndpoint());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getAccessKey()) && ObjectHelper.isNotEmpty((Object)this.configuration.getSecretKey())) {
                minioClientRequest.credentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
                minioClientRequest.region(this.configuration.getRegion());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getCustomHttpClient())) {
                minioClientRequest.httpClient(this.configuration.getCustomHttpClient());
            }
            return minioClientRequest.build();
        }
        throw new IllegalArgumentException("Endpoint must be specified");
    }

    private String readInputStream(InputStream minioObject) throws IOException {
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(minioObject, StandardCharsets.UTF_8));){
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        return textBuilder.toString();
    }

    private boolean bucketExists(String bucketName) throws Exception {
        return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    private void makeBucket(String bucketName) throws Exception {
        MakeBucketArgs.Builder makeBucketRequest = ((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).objectLock(this.getConfiguration().isObjectLock());
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getRegion())) {
            makeBucketRequest.region(this.getConfiguration().getRegion());
        }
        this.minioClient.makeBucket((MakeBucketArgs)makeBucketRequest.build());
    }

    private void setBucketPolicy(String bucketName) throws Exception {
        LOG.trace("Updating bucket {} with policy...", (Object)bucketName);
        this.minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(this.getConfiguration().getPolicy()).build());
        LOG.trace("Bucket policy updated");
    }

    private void getObjectStat(String objectName, Message message) throws Exception {
        String bucketName = this.getConfiguration().getBucketName();
        StatObjectArgs.Builder statObjectRequest = (StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getServerSideEncryptionCustomerKey, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).ssec(arg_0));
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getOffset, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).offset(arg_0));
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getLength, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).length(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getVersionId, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).versionId(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getMatchETag, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).matchETag(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getNotMatchETag, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).notMatchETag(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getModifiedSince, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).modifiedSince(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getUnModifiedSince, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).unmodifiedSince(arg_0));
        ObjectStat stat = this.minioClient.statObject((StatObjectArgs)statObjectRequest.build());
        message.setHeader("CamelMinioObjectName", (Object)stat.name());
        message.setHeader("CamelMinioBucketName", (Object)stat.bucketName());
        message.setHeader("CamelMinioETag", (Object)stat.etag());
        message.setHeader("CamelMinioLastModified", stat.httpHeaders().get("last-modified"));
        message.setHeader("CamelMinioVersionId", stat.httpHeaders().get("x-amz-version-id"));
        message.setHeader("CamelMinioContentType", (Object)stat.contentType());
        message.setHeader("CamelMinioContentLength", (Object)stat.length());
        message.setHeader("CamelMinioContentEncoding", stat.httpHeaders().get("content-encoding"));
        message.setHeader("CamelMinioContentDisposition", stat.httpHeaders().get("content-disposition"));
        message.setHeader("CamelMinioContentControl", stat.httpHeaders().get("cache-control"));
        message.setHeader("CamelMinioServerSideEncryption", stat.httpHeaders().get("x-amz-server-side-encryption"));
        message.setHeader("CamelMinioExpirationTime", stat.httpHeaders().get("x-amz-expiration"));
        message.setHeader("CamelMinioReplicationStatus", stat.httpHeaders().get("x-amz-replication-status"));
        message.setHeader("CamelMinioStorageClass", stat.httpHeaders().get("x-amz-storage-class"));
    }
}

