/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.minio.AwsRegionCache;
import io.minio.BaseArgs;
import io.minio.BucketArgs;
import io.minio.BucketExistsArgs;
import io.minio.CloseableIterator;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.CopyConditions;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.DeleteBucketEncryptionArgs;
import io.minio.DeleteBucketLifeCycleArgs;
import io.minio.DeleteBucketNotificationArgs;
import io.minio.DeleteBucketPolicyArgs;
import io.minio.DeleteBucketTagsArgs;
import io.minio.DeleteDefaultRetentionArgs;
import io.minio.DeleteObjectTagsArgs;
import io.minio.Digest;
import io.minio.Directive;
import io.minio.DisableObjectLegalHoldArgs;
import io.minio.DisableVersioningArgs;
import io.minio.DownloadObjectArgs;
import io.minio.EnableObjectLegalHoldArgs;
import io.minio.EnableVersioningArgs;
import io.minio.ErrorCode;
import io.minio.GetBucketEncryptionArgs;
import io.minio.GetBucketLifeCycleArgs;
import io.minio.GetBucketNotificationArgs;
import io.minio.GetBucketPolicyArgs;
import io.minio.GetBucketTagsArgs;
import io.minio.GetDefaultRetentionArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectRetentionArgs;
import io.minio.GetObjectTagsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.HttpRequestBody;
import io.minio.IsObjectLegalHoldEnabledArgs;
import io.minio.IsVersioningEnabledArgs;
import io.minio.ListIncompleteUploadsArgs;
import io.minio.ListObjectsArgs;
import io.minio.ListenBucketNotificationArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioProperties;
import io.minio.ObjectArgs;
import io.minio.ObjectStat;
import io.minio.ObjectWriteArgs;
import io.minio.ObjectWriteResponse;
import io.minio.PostPolicy;
import io.minio.PutObjectArgs;
import io.minio.PutObjectOptions;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveIncompleteUploadArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.S3Escaper;
import io.minio.SelectObjectContentArgs;
import io.minio.SelectResponseStream;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import io.minio.SetBucketEncryptionArgs;
import io.minio.SetBucketLifeCycleArgs;
import io.minio.SetBucketNotificationArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.SetBucketTagsArgs;
import io.minio.SetDefaultRetentionArgs;
import io.minio.SetObjectRetentionArgs;
import io.minio.SetObjectTagsArgs;
import io.minio.Signer;
import io.minio.StatObjectArgs;
import io.minio.Time;
import io.minio.UploadObjectArgs;
import io.minio.Xml;
import io.minio.errors.BucketPolicyTooLargeException;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidExpiresRangeException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.RegionConflictException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.CopyObjectResult;
import io.minio.messages.CopyPartResult;
import io.minio.messages.CreateBucketConfiguration;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteMarker;
import io.minio.messages.DeleteObject;
import io.minio.messages.DeleteRequest;
import io.minio.messages.DeleteResult;
import io.minio.messages.ErrorResponse;
import io.minio.messages.InitiateMultipartUploadResult;
import io.minio.messages.InputSerialization;
import io.minio.messages.Item;
import io.minio.messages.LegalHold;
import io.minio.messages.ListAllMyBucketsResult;
import io.minio.messages.ListBucketResultV1;
import io.minio.messages.ListBucketResultV2;
import io.minio.messages.ListMultipartUploadsResult;
import io.minio.messages.ListObjectsResult;
import io.minio.messages.ListPartsResult;
import io.minio.messages.ListVersionsResult;
import io.minio.messages.LocationConstraint;
import io.minio.messages.NotificationConfiguration;
import io.minio.messages.NotificationRecords;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.OutputSerialization;
import io.minio.messages.Part;
import io.minio.messages.Prefix;
import io.minio.messages.Retention;
import io.minio.messages.SelectObjectContentRequest;
import io.minio.messages.SseConfiguration;
import io.minio.messages.Tags;
import io.minio.messages.Upload;
import io.minio.messages.VersioningConfiguration;
import io.minio.org.apache.commons.validator.routines.InetAddressValidator;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class MinioClient {
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final long DEFAULT_CONNECTION_TIMEOUT = 5L;
    private static final int MAX_BUCKET_POLICY_SIZE = 12288;
    private static final int DEFAULT_EXPIRY_TIME = 604800;
    private static final String DEFAULT_USER_AGENT = "MinIO (" + System.getProperty("os.arch") + "; " + System.getProperty("os.arch") + ") minio-java/" + MinioProperties.INSTANCE.getVersion();
    private static final String END_HTTP = "----------END-HTTP----------";
    private static final String US_EAST_1 = "us-east-1";
    private static final String UPLOAD_ID = "uploadId";
    private static final Set<String> amzHeaders = new HashSet<String>();
    private static final Set<String> standardHeaders;
    private String userAgent = DEFAULT_USER_AGENT;
    private PrintWriter traceStream;
    private HttpUrl baseUrl;
    private String region;
    private boolean isAwsHost;
    private boolean isAcceleratedHost;
    private boolean isDualStackHost;
    private boolean useVirtualStyle;
    private String accessKey;
    private String secretKey;
    private OkHttpClient httpClient;

    private MinioClient(HttpUrl baseUrl, String region, boolean isAwsHost, boolean isAcceleratedHost, boolean isDualStackHost, boolean useVirtualStyle, String accessKey, String secretKey, OkHttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.region = region;
        this.isAwsHost = isAwsHost;
        this.isAcceleratedHost = isAcceleratedHost;
        this.isDualStackHost = isDualStackHost;
        this.useVirtualStyle = useVirtualStyle;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.httpClient = httpClient;
    }

    private MinioClient(MinioClient client) {
        this.baseUrl = client.baseUrl;
        this.region = client.region;
        this.isAwsHost = client.isAwsHost;
        this.isAcceleratedHost = client.isAcceleratedHost;
        this.isDualStackHost = client.isDualStackHost;
        this.useVirtualStyle = client.useVirtualStyle;
        this.accessKey = client.accessKey;
        this.secretKey = client.secretKey;
        this.httpClient = client.httpClient;
    }

    @Deprecated
    public MinioClient(String endpoint) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(endpoint).build());
    }

    @Deprecated
    public MinioClient(URL url) throws InvalidEndpointException, InvalidPortException {
        this(MinioClient.builder().endpoint(url).build());
    }

    @Deprecated
    public MinioClient(HttpUrl url) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(url).build());
    }

    @Deprecated
    public MinioClient(String endpoint, String accessKey, String secretKey) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(endpoint).credentials(accessKey, secretKey).build());
    }

    @Deprecated
    public MinioClient(String endpoint, String accessKey, String secretKey, String region) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(endpoint).region(region).credentials(accessKey, secretKey).build());
    }

    @Deprecated
    public MinioClient(URL url, String accessKey, String secretKey) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(url).credentials(accessKey, secretKey).build());
    }

    @Deprecated
    public MinioClient(HttpUrl url, String accessKey, String secretKey) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(url).credentials(accessKey, secretKey).build());
    }

    @Deprecated
    public MinioClient(String endpoint, int port, String accessKey, String secretKey) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(endpoint, port, null).credentials(accessKey, secretKey).build());
    }

    @Deprecated
    public MinioClient(String endpoint, String accessKey, String secretKey, boolean secure) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(endpoint, null, secure).credentials(accessKey, secretKey).build());
    }

    @Deprecated
    public MinioClient(String endpoint, int port, String accessKey, String secretKey, boolean secure) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(endpoint, port, secure).credentials(accessKey, secretKey).build());
    }

    @Deprecated
    public MinioClient(String endpoint, int port, String accessKey, String secretKey, String region, boolean secure) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(endpoint, port, secure).region(region).credentials(accessKey, secretKey).build());
    }

    @Deprecated
    public MinioClient(String endpoint, Integer port, String accessKey, String secretKey, String region, Boolean secure, OkHttpClient httpClient) throws IllegalArgumentException {
        this(MinioClient.builder().endpoint(endpoint, port, secure).region(region).credentials(accessKey, secretKey).httpClient(httpClient).build());
    }

    private void checkArgs(BaseArgs args) {
        if (args == null) {
            throw new IllegalArgumentException("null arguments");
        }
    }

    private void checkBucketName(String name) throws InvalidBucketNameException {
        if (name == null) {
            throw new InvalidBucketNameException("(null)", "null bucket name");
        }
        if (name.length() < 3 || name.length() > 63) {
            String msg = "bucket name must be at least 3 and no more than 63 characters long";
            throw new InvalidBucketNameException(name, msg);
        }
        if (name.contains("..")) {
            String msg = "bucket name cannot contain successive periods. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
            throw new InvalidBucketNameException(name, msg);
        }
        if (!name.matches("^[a-z0-9][a-z0-9\\.\\-]+[a-z0-9]$")) {
            String msg = "bucket name does not follow Amazon S3 standards. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
            throw new InvalidBucketNameException(name, msg);
        }
    }

    private void checkObjectName(String objectName) throws IllegalArgumentException {
        if (objectName == null || objectName.isEmpty()) {
            throw new IllegalArgumentException("object name cannot be empty");
        }
    }

    private void checkReadRequestSse(ServerSideEncryption sse) throws IllegalArgumentException {
        if (sse == null) {
            return;
        }
        if (sse.type() != ServerSideEncryption.Type.SSE_C) {
            throw new IllegalArgumentException("only SSE_C is supported for all read requests.");
        }
        if (sse.type().requiresTls() && !this.baseUrl.isHttps()) {
            throw new IllegalArgumentException(sse.type().name() + "operations must be performed over a secure connection.");
        }
    }

    private Multimap<String, String> merge(Multimap<String, String> m1, Multimap<String, String> m2) {
        HashMultimap map = HashMultimap.create();
        if (m1 != null) {
            map.putAll(m1);
        }
        if (m2 != null) {
            map.putAll(m2);
        }
        return map;
    }

    private HttpUrl buildUrl(Method method, String bucketName, String objectName, String region, Multimap<String, String> queryParamMap) throws IllegalArgumentException, InvalidBucketNameException, NoSuchAlgorithmException {
        if (bucketName == null && objectName != null) {
            throw new IllegalArgumentException("null bucket name for object '" + objectName + "'");
        }
        HttpUrl.Builder urlBuilder = this.baseUrl.newBuilder();
        String host = this.baseUrl.host();
        if (bucketName != null) {
            this.checkBucketName(bucketName);
            boolean enforcePathStyle = false;
            if (method == Method.PUT && objectName == null && queryParamMap == null) {
                enforcePathStyle = true;
            } else if (queryParamMap != null && queryParamMap.containsKey((Object)"location")) {
                enforcePathStyle = true;
            } else if (bucketName.contains(".") && this.baseUrl.isHttps()) {
                enforcePathStyle = true;
            }
            if (this.isAwsHost) {
                String[] s3Domain = "s3.";
                if (this.isAcceleratedHost) {
                    if (bucketName.contains(".")) {
                        throw new IllegalArgumentException("bucket name '" + bucketName + "' with '.' is not allowed for accelerated endpoint");
                    }
                    if (!enforcePathStyle) {
                        s3Domain = "s3-accelerate.";
                    }
                }
                String dualStack = "";
                if (this.isDualStackHost) {
                    dualStack = "dualstack.";
                }
                String endpoint = (String)s3Domain + dualStack;
                if (enforcePathStyle || !this.isAcceleratedHost) {
                    endpoint = endpoint + region + ".";
                }
                host = endpoint + host;
            }
            if (enforcePathStyle || !this.useVirtualStyle) {
                urlBuilder.host(host);
                urlBuilder.addEncodedPathSegment(S3Escaper.encode(bucketName));
            } else {
                urlBuilder.host(bucketName + "." + host);
            }
            if (objectName != null) {
                for (String token : objectName.split("/")) {
                    if (!token.equals(".") && !token.equals("..")) continue;
                    throw new IllegalArgumentException("object name with '.' or '..' path segment is not supported");
                }
                urlBuilder.addEncodedPathSegments(S3Escaper.encodePath(objectName));
            }
        } else if (this.isAwsHost) {
            urlBuilder.host("s3." + region + "." + host);
        }
        if (queryParamMap != null) {
            for (Map.Entry entry : queryParamMap.entries()) {
                urlBuilder.addEncodedQueryParameter(S3Escaper.encode((String)entry.getKey()), S3Escaper.encode((String)entry.getValue()));
            }
        }
        return urlBuilder.build();
    }

    private String getHostHeader(HttpUrl url) {
        if (url.scheme().equals("http") && url.port() == 80 || url.scheme().equals("https") && url.port() == 443) {
            return url.host();
        }
        return url.host() + ":" + url.port();
    }

    private Request createRequest(HttpUrl url, Method method, Multimap<String, String> headerMap, Object body, int length) throws IllegalArgumentException, InsufficientDataException, InternalException, IOException, NoSuchAlgorithmException {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        String contentType = null;
        String contentEncoding = null;
        if (headerMap != null) {
            contentEncoding = headerMap.get((Object)"Content-Encoding").stream().distinct().filter(encoding -> !encoding.isEmpty()).collect(Collectors.joining(","));
            for (Map.Entry entry : headerMap.entries()) {
                if (((String)entry.getKey()).equals("Content-Type")) {
                    contentType = (String)entry.getValue();
                }
                if (((String)entry.getKey()).equals("Content-Encoding")) continue;
                requestBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!Strings.isNullOrEmpty(contentEncoding)) {
            requestBuilder.header("Content-Encoding", contentEncoding);
        }
        requestBuilder.header("Host", this.getHostHeader(url));
        requestBuilder.header("Accept-Encoding", "identity");
        requestBuilder.header("User-Agent", this.userAgent);
        String sha256Hash = null;
        String md5Hash = null;
        if (this.accessKey != null && this.secretKey != null) {
            if (url.isHttps()) {
                sha256Hash = "UNSIGNED-PAYLOAD";
                if (body != null) {
                    md5Hash = Digest.md5Hash(body, length);
                }
            } else {
                Object data = body;
                int len = length;
                if (data == null) {
                    data = new byte[0];
                    len = 0;
                }
                String[] hashes = Digest.sha256Md5Hashes(data, len);
                sha256Hash = hashes[0];
                md5Hash = hashes[1];
            }
        } else if (body != null) {
            md5Hash = Digest.md5Hash(body, length);
        }
        if (md5Hash != null) {
            requestBuilder.header("Content-MD5", md5Hash);
        }
        if (sha256Hash != null) {
            requestBuilder.header("x-amz-content-sha256", sha256Hash);
        }
        ZonedDateTime date = ZonedDateTime.now();
        requestBuilder.header("x-amz-date", date.format(Time.AMZ_DATE_FORMAT));
        HttpRequestBody requestBody = null;
        if (body != null) {
            requestBody = body instanceof RandomAccessFile ? new HttpRequestBody((RandomAccessFile)body, length, contentType) : (body instanceof BufferedInputStream ? new HttpRequestBody((BufferedInputStream)body, length, contentType) : new HttpRequestBody((byte[])body, length, contentType));
        }
        requestBuilder.method(method.toString(), requestBody);
        return requestBuilder.build();
    }

    private Response execute(Method method, BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams, Object body, int length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        String bucketName = null;
        String region = null;
        String objectName = null;
        if (args instanceof BucketArgs) {
            bucketName = ((BucketArgs)args).bucket();
            region = ((BucketArgs)args).region();
        }
        if (args instanceof ObjectArgs) {
            objectName = ((ObjectArgs)args).object();
        }
        return this.execute(method, bucketName, objectName, this.getRegion(bucketName, region), this.merge(args.extraHeaders(), headers), this.merge(args.extraQueryParams(), queryParams), body, length);
    }

    private Response execute(Method method, String bucketName, String objectName, String region, Multimap<String, String> headerMap, Multimap<String, String> queryParamMap, Object body, int length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        boolean traceRequestBody = false;
        if (!(body == null || body instanceof InputStream || body instanceof RandomAccessFile || body instanceof byte[])) {
            byte[] bytes = body instanceof CharSequence ? body.toString().getBytes(StandardCharsets.UTF_8) : Xml.marshal(body).getBytes(StandardCharsets.UTF_8);
            body = bytes;
            length = bytes.length;
            traceRequestBody = true;
        }
        if (body == null && (method == Method.PUT || method == Method.POST)) {
            body = EMPTY_BODY;
        }
        HttpUrl url = this.buildUrl(method, bucketName, objectName, region, queryParamMap);
        Request request = this.createRequest(url, method, headerMap, body, length);
        if (this.accessKey != null && this.secretKey != null) {
            request = Signer.signV4(request, region, this.accessKey, this.secretKey);
        }
        if (this.traceStream != null) {
            this.traceStream.println("---------START-HTTP---------");
            String encodedPath = request.url().encodedPath();
            String encodedQuery = request.url().encodedQuery();
            if (encodedQuery != null) {
                encodedPath = encodedPath + "?" + encodedQuery;
            }
            this.traceStream.println(request.method() + " " + encodedPath + " HTTP/1.1");
            String headers = request.headers().toString().replaceAll("Signature=([0-9a-f]+)", "Signature=*REDACTED*").replaceAll("Credential=([^/]+)", "Credential=*REDACTED*");
            this.traceStream.println(headers);
            if (traceRequestBody) {
                this.traceStream.println(new String((byte[])body, StandardCharsets.UTF_8));
            }
        }
        OkHttpClient httpClient = this.httpClient;
        if (method == Method.PUT || method == Method.POST) {
            httpClient = this.httpClient.newBuilder().retryOnConnectionFailure(false).build();
        }
        Response response = httpClient.newCall(request).execute();
        if (this.traceStream != null) {
            this.traceStream.println(response.protocol().toString().toUpperCase(Locale.US) + " " + response.code());
            this.traceStream.println(response.headers());
        }
        if (response.isSuccessful()) {
            if (this.traceStream != null) {
                this.traceStream.println(END_HTTP);
            }
            return response;
        }
        String errorXml = null;
        try (ResponseBody responseBody = response.body();){
            errorXml = new String(responseBody.bytes(), StandardCharsets.UTF_8);
        }
        if (!(this.traceStream == null || "".equals(errorXml) && method.equals((Object)Method.HEAD))) {
            this.traceStream.println(errorXml);
        }
        String contentType = response.headers().get("content-type");
        if (!(method.equals((Object)Method.HEAD) || contentType != null && Arrays.asList(contentType.split(";")).contains("application/xml"))) {
            if (this.traceStream != null) {
                this.traceStream.println(END_HTTP);
            }
            throw new InvalidResponseException();
        }
        ErrorResponse errorResponse = null;
        if (!"".equals(errorXml)) {
            errorResponse = Xml.unmarshal(ErrorResponse.class, errorXml);
        } else if (!method.equals((Object)Method.HEAD)) {
            if (this.traceStream != null) {
                this.traceStream.println(END_HTTP);
            }
            throw new InvalidResponseException();
        }
        if (this.traceStream != null) {
            this.traceStream.println(END_HTTP);
        }
        if (errorResponse == null) {
            ErrorCode ec;
            switch (response.code()) {
                case 307: {
                    ec = ErrorCode.REDIRECT;
                    break;
                }
                case 400: {
                    if (method.equals((Object)Method.HEAD) && bucketName != null && objectName == null && this.isAwsHost && AwsRegionCache.INSTANCE.get(bucketName) != null) {
                        ec = ErrorCode.RETRY_HEAD_BUCKET;
                        break;
                    }
                    ec = ErrorCode.INVALID_URI;
                    break;
                }
                case 404: {
                    if (objectName != null) {
                        ec = ErrorCode.NO_SUCH_KEY;
                        break;
                    }
                    if (bucketName != null) {
                        ec = ErrorCode.NO_SUCH_BUCKET;
                        break;
                    }
                    ec = ErrorCode.RESOURCE_NOT_FOUND;
                    break;
                }
                case 405: 
                case 501: {
                    ec = ErrorCode.METHOD_NOT_ALLOWED;
                    break;
                }
                case 409: {
                    if (bucketName != null) {
                        ec = ErrorCode.NO_SUCH_BUCKET;
                        break;
                    }
                    ec = ErrorCode.RESOURCE_CONFLICT;
                    break;
                }
                case 403: {
                    ec = ErrorCode.ACCESS_DENIED;
                    break;
                }
                default: {
                    if (response.code() >= 500) {
                        throw new ServerException("server failed with HTTP status code " + response.code());
                    }
                    throw new InternalException("unhandled HTTP code " + response.code() + ".  Please report this issue at https://github.com/minio/minio-java/issues");
                }
            }
            errorResponse = new ErrorResponse(ec, bucketName, objectName, request.url().encodedPath(), response.header("x-amz-request-id"), response.header("x-amz-id-2"));
        }
        if ((errorResponse.errorCode() == ErrorCode.NO_SUCH_BUCKET || errorResponse.errorCode() == ErrorCode.RETRY_HEAD_BUCKET) && this.isAwsHost) {
            AwsRegionCache.INSTANCE.remove(bucketName);
        }
        throw new ErrorResponseException(errorResponse, response);
    }

    private String getRegion(String bucketName, String region) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        if (region != null) {
            if (this.region != null && !this.region.equals(region)) {
                throw new IllegalArgumentException("region must be " + this.region + ", but passed " + region);
            }
            return region;
        }
        if (this.region != null && !this.region.equals("")) {
            return this.region;
        }
        if (!this.isAwsHost || bucketName == null || this.accessKey == null) {
            return US_EAST_1;
        }
        region = AwsRegionCache.INSTANCE.get(bucketName);
        if (region != null) {
            return region;
        }
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"location", null);
        Response response = this.execute(Method.GET, bucketName, null, US_EAST_1, null, (Multimap<String, String>)queryParams, null, 0);
        try (ResponseBody body = response.body();){
            LocationConstraint lc = Xml.unmarshal(LocationConstraint.class, body.charStream());
            region = lc.location() == null || lc.location().equals("") ? US_EAST_1 : (lc.location().equals("EU") ? "eu-west-1" : lc.location());
        }
        AwsRegionCache.INSTANCE.set(bucketName, region);
        return region;
    }

    private Response executeGet(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.execute(Method.GET, args, headers, queryParams, null, 0);
    }

    private Response executeHead(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            Response response = this.execute(Method.HEAD, args, headers, queryParams, null, 0);
            response.body().close();
            return response;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.RETRY_HEAD_BUCKET) {
                throw e;
            }
            Response response = this.execute(Method.HEAD, args, headers, queryParams, null, 0);
            response.body().close();
            return response;
        }
    }

    private Response executeDelete(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        Response response = this.execute(Method.DELETE, args, headers, queryParams, null, 0);
        response.body().close();
        return response;
    }

    private Response executePost(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams, Object data) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.execute(Method.POST, args, headers, queryParams, data, 0);
    }

    private Response executePut(BaseArgs args, Multimap<String, String> headers, Multimap<String, String> queryParams, Object data, int length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.execute(Method.PUT, args, headers, queryParams, data, length);
    }

    @Deprecated
    public ObjectStat statObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    @Deprecated
    public ObjectStat statObject(String bucketName, String objectName, ServerSideEncryptionCustomerKey ssec) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).ssec(ssec)).build());
    }

    public ObjectStat statObject(StatObjectArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSsec(this.baseUrl);
        SetMultimap ssecHeaders = null;
        if (args.ssec() != null) {
            ssecHeaders = Multimaps.forMap(args.ssec().headers());
        }
        HashMultimap queryParams = HashMultimap.create();
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executeHead(args, (Multimap<String, String>)ssecHeaders, (Multimap<String, String>)queryParams);
        return new ObjectStat(args.bucket(), args.object(), response.headers());
    }

    public String getObjectUrl(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkObjectName(objectName);
        HttpUrl url = this.buildUrl(Method.GET, bucketName, objectName, this.getRegion(bucketName, this.region), null);
        return url.toString();
    }

    @Deprecated
    public InputStream getObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    @Deprecated
    public InputStream getObject(String bucketName, String objectName, ServerSideEncryptionCustomerKey ssec) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).ssec(ssec)).build());
    }

    @Deprecated
    public InputStream getObject(String bucketName, String objectName, long offset) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).offset(offset)).build());
    }

    @Deprecated
    public InputStream getObject(String bucketName, String objectName, long offset, Long length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).offset(offset)).length(length)).build());
    }

    @Deprecated
    public InputStream getObject(String bucketName, String objectName, Long offset, Long length, ServerSideEncryptionCustomerKey ssec) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).offset(offset)).length(length)).ssec(ssec)).build());
    }

    public InputStream getObject(GetObjectArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSsec(this.baseUrl);
        Long offset = args.offset();
        Long length = args.length();
        if (length != null && offset == null) {
            offset = 0L;
        }
        HashMultimap headers = HashMultimap.create();
        if (length != null) {
            headers.put((Object)"Range", (Object)("bytes=" + offset + "-" + (offset + length - 1L)));
        } else if (offset != null) {
            headers.put((Object)"Range", (Object)("bytes=" + offset + "-"));
        }
        if (args.ssec() != null) {
            headers.putAll((Multimap)Multimaps.forMap(args.ssec().headers()));
        }
        HashMultimap queryParams = HashMultimap.create();
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executeGet(args, (Multimap<String, String>)headers, (Multimap<String, String>)queryParams);
        return response.body().byteStream();
    }

    @Deprecated
    public void getObject(String bucketName, String objectName, String fileName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(fileName).build());
    }

    @Deprecated
    public void getObject(String bucketName, String objectName, ServerSideEncryptionCustomerKey ssec, String fileName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(objectName)).ssec(ssec)).filename(fileName).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadObject(DownloadObjectArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        String filename = args.filename();
        Path filePath = Paths.get(filename, new String[0]);
        boolean fileExists = Files.exists(filePath, new LinkOption[0]);
        ObjectStat objectStat = this.statObject(new StatObjectArgs(args));
        long length = objectStat.length();
        String etag = objectStat.etag();
        String tempFilename = filename + "." + etag + ".part.minio";
        Path tempFilePath = Paths.get(tempFilename, new String[0]);
        boolean tempFileExists = Files.exists(tempFilePath, new LinkOption[0]);
        if (tempFileExists && !Files.isRegularFile(tempFilePath, new LinkOption[0])) {
            throw new IOException(tempFilename + ": not a regular file");
        }
        long tempFileSize = 0L;
        if (tempFileExists && (tempFileSize = Files.size(tempFilePath)) > length) {
            Files.delete(tempFilePath);
            tempFileExists = false;
            tempFileSize = 0L;
        }
        if (fileExists) {
            long fileSize = Files.size(filePath);
            if (fileSize == length) {
                return;
            }
            if (fileSize > length) {
                throw new IllegalArgumentException("Source object, '" + args.object() + "', size:" + length + " is smaller than the destination file, '" + filename + "', size:" + fileSize);
            }
            if (!tempFileExists) {
                Files.copy(filePath, tempFilePath, new CopyOption[0]);
                tempFileSize = fileSize;
                tempFileExists = true;
            }
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.getObject(new GetObjectArgs(args));
            os = Files.newOutputStream(tempFilePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            long bytesWritten = ByteStreams.copy((InputStream)is, (OutputStream)os);
            is.close();
            os.close();
            if (bytesWritten != length - tempFileSize) {
                throw new IOException(tempFilename + ": unexpected data written.  expected = " + (length - tempFileSize) + ", written = " + bytesWritten);
            }
            Files.move(tempFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    @Deprecated
    public void copyObject(String bucketName, String objectName, Map<String, String> headerMap, ServerSideEncryption sse, String srcBucketName, String srcObjectName, ServerSideEncryption srcSse, CopyConditions copyConditions) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        ServerSideEncryptionCustomerKey srcSsec = null;
        if (srcSse instanceof ServerSideEncryptionCustomerKey) {
            srcSsec = (ServerSideEncryptionCustomerKey)srcSse;
        }
        this.checkReadRequestSse(srcSse);
        CopyObjectArgs.Builder argBuilder = (CopyObjectArgs.Builder)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(bucketName)).object(objectName)).headers(headerMap)).sse(sse);
        CopySource.Builder sourceBuilder = (CopySource.Builder)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(srcBucketName)).object(srcObjectName)).ssec(srcSsec);
        if (copyConditions != null) {
            Map<String, String> map = copyConditions.getConditions();
            sourceBuilder.matchETag(map.get("x-amz-copy-source-if-match"));
            sourceBuilder.notMatchETag(map.get("x-amz-copy-source-if-none-match"));
            String value = map.get("x-amz-copy-source-if-modified-since");
            if (value != null) {
                sourceBuilder.modifiedSince(ZonedDateTime.parse(value, Time.HTTP_HEADER_DATE_FORMAT));
            }
            if ((value = map.get("x-amz-copy-source-if-unmodified-since")) != null) {
                sourceBuilder.unmodifiedSince(ZonedDateTime.parse(value, Time.HTTP_HEADER_DATE_FORMAT));
            }
            if ((value = map.get("x-amz-metadata-directive")) != null) {
                argBuilder.metadataDirective(Directive.valueOf(value));
            }
        }
        this.copyObject((CopyObjectArgs)argBuilder.source((CopySource)sourceBuilder.build()).build());
    }

    public ObjectWriteResponse copyObject(CopyObjectArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSse(this.baseUrl);
        if (args.source().offset != null || args.source().length != null) {
            return this.composeObject(new ComposeObjectArgs(args));
        }
        Multimap<String, String> headers = args.genHeaders();
        if (args.metadataDirective() != null) {
            headers.put((Object)"x-amz-metadata-directive", (Object)args.metadataDirective().name());
        }
        if (args.taggingDirective() != null) {
            headers.put((Object)"x-amz-tagging-directive", (Object)args.taggingDirective().name());
        }
        headers.putAll(args.source().genCopyHeaders());
        try (Response response = this.executePut(args, headers, null, null, 0);){
            CopyObjectResult result = Xml.unmarshal(CopyObjectResult.class, response.body().charStream());
            ObjectWriteResponse objectWriteResponse = new ObjectWriteResponse(response.headers(), args.bucket(), args.region(), args.object(), result.etag(), response.header("x-amz-version-id"));
            return objectWriteResponse;
        }
    }

    @Deprecated
    public void composeObject(String bucketName, String objectName, List<ComposeSource> sources, Map<String, String> headerMap, ServerSideEncryption sse) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        ComposeObjectArgs.Builder builder = (ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)ComposeObjectArgs.builder().bucket(bucketName)).object(objectName)).headers((Multimap<String, String>)Multimaps.forMap(headerMap))).sources(sources).sse(sse);
        this.composeObject((ComposeObjectArgs)builder.build());
    }

    private int calculatePartCount(List<ComposeSource> sources) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        long objectSize = 0L;
        int partCount = 0;
        int i = 0;
        for (ComposeSource src : sources) {
            ++i;
            ObjectStat stat = this.statObject(new StatObjectArgs(src));
            src.buildHeaders(stat.length(), stat.etag());
            long size = stat.length();
            if (src.length() != null) {
                size = src.length();
            } else if (src.offset() != null) {
                size -= src.offset().longValue();
            }
            if (size < 0x500000L && sources.size() != 1 && i != sources.size()) {
                throw new IllegalArgumentException("source " + src.bucket() + "/" + src.object() + ": size " + size + " must be greater than " + 0x500000);
            }
            if ((objectSize += size) > 0x50000000000L) {
                throw new IllegalArgumentException("destination object size must be less than 5497558138880");
            }
            if (size > 0x140000000L) {
                long count = size / 0x140000000L;
                long lastPartSize = size - count * 0x140000000L;
                if (lastPartSize > 0L) {
                    ++count;
                } else {
                    lastPartSize = 0x140000000L;
                }
                if (lastPartSize < 0x500000L && sources.size() != 1 && i != sources.size()) {
                    throw new IllegalArgumentException("source " + src.bucket() + "/" + src.object() + ": for multipart split upload of " + size + ", last part size is less than " + 0x500000);
                }
                partCount += (int)count;
            } else {
                ++partCount;
            }
            if (partCount <= 10000) continue;
            throw new IllegalArgumentException("Compose sources create more than allowed multipart count 10000");
        }
        return partCount;
    }

    public ObjectWriteResponse composeObject(ComposeObjectArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSse(this.baseUrl);
        List<ComposeSource> sources = args.sources();
        int partCount = this.calculatePartCount(sources);
        HashMultimap headers = HashMultimap.create();
        headers.putAll(args.extraHeaders());
        headers.putAll(args.genHeaders());
        String uploadId = this.createMultipartUpload(args.bucket(), args.region(), args.object(), (Multimap<String, String>)headers, args.extraQueryParams());
        HashMultimap ssecHeaders = HashMultimap.create();
        if (args.sse() != null && args.sse().type() == ServerSideEncryption.Type.SSE_C) {
            ssecHeaders.putAll((Multimap)Multimaps.forMap(args.sse().headers()));
        }
        try {
            int partNumber = 0;
            Part[] totalParts = new Part[partCount];
            for (ComposeSource src : sources) {
                long size = src.objectSize();
                if (src.length() != null) {
                    size = src.length();
                } else if (src.offset() != null) {
                    size -= src.offset().longValue();
                }
                long offset = 0L;
                if (src.offset() != null) {
                    offset = src.offset();
                }
                headers = HashMultimap.create();
                headers.putAll(src.headers());
                headers.putAll((Multimap)ssecHeaders);
                if (size <= 0x140000000L) {
                    ++partNumber;
                    if (src.length() != null) {
                        headers.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + offset + "-" + (offset + src.length() - 1L)));
                    } else if (src.offset() != null) {
                        headers.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + offset + "-" + (offset + size - 1L)));
                    }
                    String eTag = this.uploadPartCopy(args.bucket(), args.object(), uploadId, partNumber, (Multimap<String, String>)headers);
                    totalParts[partNumber - 1] = new Part(partNumber, eTag);
                    continue;
                }
                while (size > 0L) {
                    ++partNumber;
                    long startBytes = offset;
                    long endBytes = startBytes + 0x140000000L;
                    if (size < 0x140000000L) {
                        endBytes = startBytes + size;
                    }
                    HashMultimap headersCopy = HashMultimap.create();
                    headers.putAll((Multimap)headers);
                    headers.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + startBytes + "-" + endBytes));
                    String eTag = this.uploadPartCopy(args.bucket(), args.object(), uploadId, partNumber, (Multimap<String, String>)headersCopy);
                    totalParts[partNumber - 1] = new Part(partNumber, eTag);
                    offset = startBytes;
                    size -= endBytes - startBytes;
                }
            }
            return this.completeMultipartUpload(args.bucket(), this.getRegion(args.bucket(), args.region()), args.object(), uploadId, totalParts, null, null);
        }
        catch (RuntimeException e) {
            this.abortMultipartUpload(args.bucket(), args.object(), uploadId);
            throw e;
        }
        catch (Exception e) {
            this.abortMultipartUpload(args.bucket(), args.object(), uploadId);
            throw e;
        }
    }

    @Deprecated
    public String getPresignedObjectUrl(Method method, String bucketName, String objectName, Integer expires, Map<String, String> reqParams) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(objectName)).method(method).expiry(expires).extraQueryParams(reqParams)).build());
    }

    public String getPresignedObjectUrl(GetPresignedObjectUrlArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException, ServerException {
        this.checkArgs(args);
        byte[] body = null;
        if (args.method() == Method.PUT || args.method() == Method.POST) {
            body = EMPTY_BODY;
        }
        HashMultimap queryParams = HashMultimap.create();
        queryParams.putAll(args.extraQueryParams());
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        String region = this.getRegion(args.bucket(), args.region());
        HttpUrl url = this.buildUrl(args.method(), args.bucket(), args.object(), region, (Multimap<String, String>)queryParams);
        Request request = this.createRequest(url, args.method(), null, body, 0);
        url = Signer.presignV4(request, region, this.accessKey, this.secretKey, args.expiry());
        return url.toString();
    }

    @Deprecated
    public String presignedGetObject(String bucketName, String objectName, Integer expires, Map<String, String> reqParams) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).expiry(expires).extraQueryParams(reqParams)).build());
    }

    @Deprecated
    public String presignedGetObject(String bucketName, String objectName, Integer expires) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).expiry(expires).build());
    }

    @Deprecated
    public String presignedGetObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).build());
    }

    @Deprecated
    public String presignedPutObject(String bucketName, String objectName, Integer expires) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.PUT).bucket(bucketName)).object(objectName)).expiry(expires).build());
    }

    @Deprecated
    public String presignedPutObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.PUT).bucket(bucketName)).object(objectName)).build());
    }

    public Map<String, String> presignedPostPolicy(PostPolicy policy) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return policy.formData(this.accessKey, this.secretKey, this.getRegion(policy.bucketName(), null));
    }

    @Deprecated
    public void removeObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public void removeObject(RemoveObjectArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap headers = HashMultimap.create();
        if (args.bypassGovernanceMode()) {
            headers.put((Object)"x-amz-bypass-governance-retention", (Object)"true");
        }
        HashMultimap queryParams = HashMultimap.create();
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        this.executeDelete(args, (Multimap<String, String>)headers, (Multimap<String, String>)queryParams);
    }

    @Deprecated
    public Iterable<Result<DeleteError>> removeObjects(String bucketName, Iterable<String> objectNames) {
        Stream<DeleteObject> stream = StreamSupport.stream(objectNames.spliterator(), false).map(name -> new DeleteObject((String)name));
        return this.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects(stream::iterator).build());
    }

    public Iterable<Result<DeleteError>> removeObjects(final RemoveObjectsArgs args) {
        this.checkArgs(args);
        return new Iterable<Result<DeleteError>>(){

            @Override
            public Iterator<Result<DeleteError>> iterator() {
                return new Iterator<Result<DeleteError>>(){
                    private Result<DeleteError> error;
                    private Iterator<DeleteError> errorIterator;
                    private boolean completed = false;
                    private Iterator<DeleteObject> objectIter;
                    {
                        this.objectIter = args.objects().iterator();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private synchronized void populate() {
                        List<DeleteError> errorList = null;
                        try {
                            LinkedList<DeleteObject> objectList = new LinkedList<DeleteObject>();
                            for (int i = 0; this.objectIter.hasNext() && i < 1000; ++i) {
                                objectList.add(this.objectIter.next());
                            }
                            if (objectList.size() > 0) {
                                DeleteResult result = MinioClient.this.deleteObjects(args.bucket(), objectList, args.quiet(), args.bypassGovernanceMode());
                                errorList = result.errorList();
                            }
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                        }
                        finally {
                            this.errorIterator = errorList != null ? errorList.iterator() : new LinkedList().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.errorIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && this.errorIterator != null && !this.errorIterator.hasNext()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.errorIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<DeleteError> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.errorIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && this.errorIterator != null && !this.errorIterator.hasNext()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.errorIterator.hasNext()) {
                            return new Result<DeleteError>(this.errorIterator.next());
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Deprecated
    public Iterable<Result<Item>> listObjects(String bucketName) throws XmlParserException {
        return this.listObjects(bucketName, null);
    }

    @Deprecated
    public Iterable<Result<Item>> listObjects(String bucketName, String prefix) throws XmlParserException {
        return this.listObjects(bucketName, prefix, true);
    }

    @Deprecated
    public Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive) {
        return this.listObjects(bucketName, prefix, recursive, false);
    }

    @Deprecated
    public Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive, boolean useVersion1) {
        return this.listObjects(bucketName, prefix, recursive, false, useVersion1);
    }

    @Deprecated
    public Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive, boolean includeUserMetadata, boolean useVersion1) {
        return this.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(recursive).includeUserMetadata(includeUserMetadata).useApiVersion1(useVersion1).build());
    }

    public Iterable<Result<Item>> listObjects(ListObjectsArgs args) {
        if (args.includeVersions() || args.versionIdMarker() != null) {
            return this.listObjectVersions(args);
        }
        if (args.useApiVersion1()) {
            return this.listObjectsV1(args);
        }
        return this.listObjectsV2(args);
    }

    private Iterable<Result<Item>> listObjectsV2(final ListObjectsArgs args) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new ObjectIterator(){
                    private ListBucketResultV2 result = null;

                    @Override
                    protected void populateResult() throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
                        this.listObjectsResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        this.result = MinioClient.this.listObjectsV2(args.bucket(), args.region(), args.delimiter(), args.useUrlEncodingType(), args.startAfter(), args.maxKeys(), args.prefix(), this.result == null ? args.continuationToken() : this.result.nextContinuationToken(), args.fetchOwner(), args.includeUserMetadata(), args.extraHeaders(), args.extraQueryParams());
                        this.listObjectsResult = this.result;
                    }
                };
            }
        };
    }

    private Iterable<Result<Item>> listObjectsV1(final ListObjectsArgs args) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new ObjectIterator(){
                    private ListBucketResultV1 result = null;

                    @Override
                    protected void populateResult() throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
                        String nextMarker;
                        this.listObjectsResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        String string = nextMarker = this.result == null ? args.marker() : this.result.nextMarker();
                        if (nextMarker == null) {
                            nextMarker = this.lastObjectName;
                        }
                        this.result = MinioClient.this.listObjectsV1(args.bucket(), args.region(), args.delimiter(), args.useUrlEncodingType(), nextMarker, args.maxKeys(), args.prefix(), args.extraHeaders(), args.extraQueryParams());
                        this.listObjectsResult = this.result;
                    }
                };
            }
        };
    }

    private Iterable<Result<Item>> listObjectVersions(final ListObjectsArgs args) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new ObjectIterator(){
                    private ListVersionsResult result = null;

                    @Override
                    protected void populateResult() throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
                        this.listObjectsResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        this.result = MinioClient.this.listObjectVersions(args.bucket(), args.region(), args.delimiter(), args.useUrlEncodingType(), this.result == null ? args.keyMarker() : this.result.nextKeyMarker(), args.maxKeys(), args.prefix(), this.result == null ? args.versionIdMarker() : this.result.nextVersionIdMarker(), args.extraHeaders(), args.extraQueryParams());
                        this.listObjectsResult = this.result;
                    }
                };
            }
        };
    }

    public List<Bucket> listBuckets() throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try (Response response = this.execute(Method.GET, null, null, this.region != null ? this.region : US_EAST_1, null, null, null, 0);){
            ListAllMyBucketsResult result = Xml.unmarshal(ListAllMyBucketsResult.class, response.body().charStream());
            List<Bucket> list = result.buckets();
            return list;
        }
    }

    @Deprecated
    public boolean bucketExists(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    public boolean bucketExists(BucketExistsArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.executeHead(args, null, null);
            return true;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.NO_SUCH_BUCKET) {
                throw e;
            }
            return false;
        }
    }

    @Deprecated
    public void makeBucket(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, RegionConflictException, ServerException, XmlParserException {
        this.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
    }

    @Deprecated
    public void makeBucket(String bucketName, String region) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, RegionConflictException, ServerException, XmlParserException {
        this.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).region(region)).build());
    }

    @Deprecated
    public void makeBucket(String bucketName, String region, boolean objectLock) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, RegionConflictException, ServerException, XmlParserException {
        this.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).region(region)).objectLock(objectLock).build());
    }

    public void makeBucket(MakeBucketArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, RegionConflictException, ServerException, XmlParserException {
        this.checkArgs(args);
        String region = args.region();
        if (this.region != null && !this.region.isEmpty()) {
            if (region != null && !region.equals(this.region)) {
                throw new IllegalArgumentException("region must be " + this.region + ", but passed " + region);
            }
            region = this.region;
        }
        if (region == null) {
            region = US_EAST_1;
        }
        CreateBucketConfiguration config = null;
        if (!region.equals(US_EAST_1)) {
            config = new CreateBucketConfiguration(region);
        }
        HashMultimap headers = null;
        if (args.objectLock()) {
            headers = HashMultimap.create();
            headers.put((Object)"x-amz-bucket-object-lock-enabled", (Object)"true");
        }
        try (Response response = this.execute(Method.PUT, args.bucket(), null, region, this.merge(args.extraHeaders(), (Multimap<String, String>)headers), args.extraQueryParams(), config, 0);){
            if (this.isAwsHost) {
                AwsRegionCache.INSTANCE.set(args.bucket(), region);
            }
        }
    }

    @Deprecated
    public void enableVersioning(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.enableVersioning((EnableVersioningArgs)((EnableVersioningArgs.Builder)EnableVersioningArgs.builder().bucket(bucketName)).build());
    }

    public void enableVersioning(EnableVersioningArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"versioning", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, new VersioningConfiguration(true), 0);
        response.close();
    }

    @Deprecated
    public void disableVersioning(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.disableVersioning((DisableVersioningArgs)((DisableVersioningArgs.Builder)DisableVersioningArgs.builder().bucket(bucketName)).build());
    }

    public void disableVersioning(DisableVersioningArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"versioning", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, new VersioningConfiguration(false), 0);
        response.close();
    }

    public boolean isVersioningEnabled(IsVersioningEnabledArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"versioning", (Object)"");
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            VersioningConfiguration result = Xml.unmarshal(VersioningConfiguration.class, response.body().charStream());
            boolean bl = result.status();
            return bl;
        }
    }

    @Deprecated
    public void setDefaultRetention(String bucketName, ObjectLockConfiguration config) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.setDefaultRetention((SetDefaultRetentionArgs)((SetDefaultRetentionArgs.Builder)SetDefaultRetentionArgs.builder().bucket(bucketName)).config(config).build());
    }

    public void setDefaultRetention(SetDefaultRetentionArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"object-lock", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, args.config(), 0);
        response.close();
    }

    public void deleteDefaultRetention(DeleteDefaultRetentionArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"object-lock", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, new ObjectLockConfiguration(), 0);
        response.close();
    }

    @Deprecated
    public ObjectLockConfiguration getDefaultRetention(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getDefaultRetention((GetDefaultRetentionArgs)((GetDefaultRetentionArgs.Builder)GetDefaultRetentionArgs.builder().bucket(bucketName)).build());
    }

    public ObjectLockConfiguration getDefaultRetention(GetDefaultRetentionArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"object-lock", (Object)"");
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            ObjectLockConfiguration objectLockConfiguration = Xml.unmarshal(ObjectLockConfiguration.class, response.body().charStream());
            return objectLockConfiguration;
        }
    }

    @Deprecated
    public void setObjectRetention(String bucketName, String objectName, String versionId, Retention config, boolean bypassGovernanceMode) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.setObjectRetention((SetObjectRetentionArgs)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)SetObjectRetentionArgs.builder().bucket(bucketName)).object(objectName)).versionId(versionId)).config(config).bypassGovernanceMode(bypassGovernanceMode).build());
    }

    public void setObjectRetention(SetObjectRetentionArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"retention", (Object)"");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        HashMultimap headers = HashMultimap.create();
        if (args.bypassGovernanceMode()) {
            headers.put((Object)"x-amz-bypass-governance-retention", (Object)"True");
        }
        Response response = this.executePut(args, (Multimap<String, String>)headers, (Multimap<String, String>)queryParams, args.config(), 0);
        response.close();
    }

    @Deprecated
    public Retention getObjectRetention(String bucketName, String objectName, String versionId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getObjectRetention((GetObjectRetentionArgs)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)GetObjectRetentionArgs.builder().bucket(bucketName)).object(objectName)).versionId(versionId)).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Retention getObjectRetention(GetObjectRetentionArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"retention", (Object)"");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            Retention retention = Xml.unmarshal(Retention.class, response.body().charStream());
            return retention;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_OBJECT_LOCK_CONFIGURATION) return null;
            throw e;
        }
    }

    @Deprecated
    public void enableObjectLegalHold(String bucketName, String objectName, String versionId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.enableObjectLegalHold((EnableObjectLegalHoldArgs)((EnableObjectLegalHoldArgs.Builder)((EnableObjectLegalHoldArgs.Builder)((EnableObjectLegalHoldArgs.Builder)EnableObjectLegalHoldArgs.builder().bucket(bucketName)).object(objectName)).versionId(versionId)).build());
    }

    public void enableObjectLegalHold(EnableObjectLegalHoldArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"legal-hold", (Object)"");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, new LegalHold(true), 0);
        response.close();
    }

    @Deprecated
    public void disableObjectLegalHold(String bucketName, String objectName, String versionId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.disableObjectLegalHold((DisableObjectLegalHoldArgs)((DisableObjectLegalHoldArgs.Builder)((DisableObjectLegalHoldArgs.Builder)((DisableObjectLegalHoldArgs.Builder)DisableObjectLegalHoldArgs.builder().bucket(bucketName)).object(objectName)).versionId(versionId)).build());
    }

    public void disableObjectLegalHold(DisableObjectLegalHoldArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"legal-hold", (Object)"");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, new LegalHold(false), 0);
        response.close();
    }

    @Deprecated
    public boolean isObjectLegalHoldEnabled(String bucketName, String objectName, String versionId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.isObjectLegalHoldEnabled((IsObjectLegalHoldEnabledArgs)((IsObjectLegalHoldEnabledArgs.Builder)((IsObjectLegalHoldEnabledArgs.Builder)((IsObjectLegalHoldEnabledArgs.Builder)IsObjectLegalHoldEnabledArgs.builder().bucket(bucketName)).object(objectName)).versionId(versionId)).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isObjectLegalHoldEnabled(IsObjectLegalHoldEnabledArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"legal-hold", (Object)"");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            LegalHold result = Xml.unmarshal(LegalHold.class, response.body().charStream());
            boolean bl = result.status();
            return bl;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_OBJECT_LOCK_CONFIGURATION) return false;
            throw e;
        }
    }

    @Deprecated
    public void removeBucket(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public void removeBucket(RemoveBucketArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        this.executeDelete(args, null, null);
    }

    private ObjectWriteResponse putObject(ObjectWriteArgs args, Object data, long objectSize, long partSize, int partCount, String contentType) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        HashMultimap headers = HashMultimap.create();
        headers.putAll(args.extraHeaders());
        headers.putAll(args.genHeaders());
        if (!headers.containsKey((Object)"Content-Type")) {
            headers.put((Object)"Content-Type", (Object)contentType);
        }
        String uploadId = null;
        long uploadedSize = 0L;
        Part[] parts = null;
        try {
            for (int partNumber = 1; partNumber <= partCount || partCount < 0; ++partNumber) {
                long availableSize = partSize;
                if (partCount > 0) {
                    if (partNumber == partCount) {
                        availableSize = objectSize - uploadedSize;
                    }
                } else {
                    availableSize = this.getAvailableSize(data, partSize + 1L);
                    if (availableSize <= partSize) {
                        partCount = partNumber;
                    } else {
                        availableSize = partSize;
                    }
                }
                if (partCount == 1) {
                    return this.putObject(args.bucket(), args.region(), args.object(), data, (int)availableSize, (Multimap<String, String>)headers, args.extraQueryParams());
                }
                if (uploadId == null) {
                    uploadId = this.createMultipartUpload(args.bucket(), args.region(), args.object(), (Multimap<String, String>)headers, args.extraQueryParams());
                    parts = new Part[10000];
                }
                Map<String, String> ssecHeaders = null;
                if (args.sse() != null && args.sse().type() == ServerSideEncryption.Type.SSE_C) {
                    ssecHeaders = args.sse().headers();
                }
                String etag = this.uploadPart(args.bucket(), args.object(), data, (int)availableSize, uploadId, partNumber, ssecHeaders);
                parts[partNumber - 1] = new Part(partNumber, etag);
                uploadedSize += availableSize;
            }
            return this.completeMultipartUpload(args.bucket(), args.region(), args.object(), uploadId, parts, null, null);
        }
        catch (RuntimeException e) {
            if (uploadId != null) {
                this.abortMultipartUpload(args.bucket(), args.object(), uploadId);
            }
            throw e;
        }
        catch (Exception e) {
            if (uploadId != null) {
                this.abortMultipartUpload(args.bucket(), args.object(), uploadId);
            }
            throw e;
        }
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, String filename, PutObjectOptions options) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        UploadObjectArgs.Builder builder = ((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(filename);
        if (options != null) {
            builder.sse(options.sse());
            if (!options.contentType().equals("application/octet-stream")) {
                builder.contentType(options.contentType());
            }
        }
        this.uploadObject((UploadObjectArgs)builder.build());
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, InputStream stream, PutObjectOptions options) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(stream, options.objectSize(), options.partSize()).contentType(options.contentType()).headers(options.headers())).sse(options.sse())).build());
    }

    public ObjectWriteResponse putObject(PutObjectArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSse(this.baseUrl);
        return this.putObject(args, args.stream(), args.objectSize(), args.partSize(), args.partCount(), args.contentType());
    }

    public ObjectWriteResponse uploadObject(UploadObjectArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSse(this.baseUrl);
        try (RandomAccessFile file = new RandomAccessFile(args.filename(), "r");){
            ObjectWriteResponse objectWriteResponse = this.putObject(args, file, args.objectSize(), args.partSize(), args.partCount(), args.contentType());
            return objectWriteResponse;
        }
    }

    @Deprecated
    public String getBucketPolicy(String bucketName) throws BucketPolicyTooLargeException, ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getBucketPolicy((GetBucketPolicyArgs)((GetBucketPolicyArgs.Builder)GetBucketPolicyArgs.builder().bucket(bucketName)).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBucketPolicy(GetBucketPolicyArgs args) throws BucketPolicyTooLargeException, ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"policy", (Object)"");
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            byte[] buf = new byte[12288];
            int bytesRead = 0;
            bytesRead = response.body().byteStream().read(buf, 0, 12288);
            if (bytesRead < 0) {
                throw new IOException("unexpected EOF when reading bucket policy");
            }
            if (bytesRead == 12288) {
                int byteRead = 0;
                while (byteRead == 0 && (byteRead = response.body().byteStream().read()) >= 0) {
                    if (byteRead <= 0) continue;
                    throw new BucketPolicyTooLargeException(args.bucket());
                }
            }
            String string = new String(buf, 0, bytesRead, StandardCharsets.UTF_8);
            return string;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_BUCKET_POLICY) return "";
            throw e;
        }
    }

    @Deprecated
    public void setBucketPolicy(String bucketName, String policy) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(policy).build());
    }

    public void setBucketPolicy(SetBucketPolicyArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"policy", (Object)"");
        HashMultimap headers = HashMultimap.create();
        headers.put((Object)"Content-Type", (Object)"application/json");
        Response response = this.executePut(args, (Multimap<String, String>)headers, (Multimap<String, String>)queryParams, args.config(), 0);
        response.close();
    }

    public void deleteBucketPolicy(DeleteBucketPolicyArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        block2: {
            this.checkArgs(args);
            HashMultimap queryParams = HashMultimap.create();
            queryParams.put((Object)"policy", (Object)"");
            try {
                this.executeDelete(args, null, (Multimap<String, String>)queryParams);
            }
            catch (ErrorResponseException e) {
                if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_BUCKET_POLICY) break block2;
                throw e;
            }
        }
    }

    @Deprecated
    public void setBucketLifeCycle(String bucketName, String lifeCycle) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.setBucketLifeCycle((SetBucketLifeCycleArgs)((SetBucketLifeCycleArgs.Builder)SetBucketLifeCycleArgs.builder().bucket(bucketName)).config(lifeCycle).build());
    }

    public void setBucketLifeCycle(SetBucketLifeCycleArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"lifecycle", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, args.config(), 0);
        response.close();
    }

    @Deprecated
    public void deleteBucketLifeCycle(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.deleteBucketLifeCycle((DeleteBucketLifeCycleArgs)((DeleteBucketLifeCycleArgs.Builder)DeleteBucketLifeCycleArgs.builder().bucket(bucketName)).build());
    }

    public void deleteBucketLifeCycle(DeleteBucketLifeCycleArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"lifecycle", (Object)"");
        this.executeDelete(args, null, (Multimap<String, String>)queryParams);
    }

    @Deprecated
    public String getBucketLifeCycle(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getBucketLifeCycle((GetBucketLifeCycleArgs)((GetBucketLifeCycleArgs.Builder)GetBucketLifeCycleArgs.builder().bucket(bucketName)).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBucketLifeCycle(GetBucketLifeCycleArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"lifecycle", (Object)"");
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            String string = new String(response.body().bytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_LIFECYCLE_CONFIGURATION) return "";
            throw e;
        }
    }

    @Deprecated
    public NotificationConfiguration getBucketNotification(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.getBucketNotification((GetBucketNotificationArgs)((GetBucketNotificationArgs.Builder)GetBucketNotificationArgs.builder().bucket(bucketName)).build());
    }

    public NotificationConfiguration getBucketNotification(GetBucketNotificationArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"notification", (Object)"");
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            NotificationConfiguration notificationConfiguration = Xml.unmarshal(NotificationConfiguration.class, response.body().charStream());
            return notificationConfiguration;
        }
    }

    @Deprecated
    public void setBucketNotification(String bucketName, NotificationConfiguration notificationConfiguration) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.setBucketNotification((SetBucketNotificationArgs)((SetBucketNotificationArgs.Builder)SetBucketNotificationArgs.builder().bucket(bucketName)).config(notificationConfiguration).build());
    }

    public void setBucketNotification(SetBucketNotificationArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"notification", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, args.config(), 0);
        response.close();
    }

    @Deprecated
    public void removeAllBucketNotification(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.deleteBucketNotification((DeleteBucketNotificationArgs)((DeleteBucketNotificationArgs.Builder)DeleteBucketNotificationArgs.builder().bucket(bucketName)).build());
    }

    public void deleteBucketNotification(DeleteBucketNotificationArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"notification", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, new NotificationConfiguration(), 0);
        response.close();
    }

    @Deprecated
    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName) throws XmlParserException {
        return this.listIncompleteUploads((ListIncompleteUploadsArgs)((ListIncompleteUploadsArgs.Builder)ListIncompleteUploadsArgs.builder().bucket(bucketName)).recursive(true).build());
    }

    @Deprecated
    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName, String prefix) throws XmlParserException {
        return this.listIncompleteUploads((ListIncompleteUploadsArgs)((ListIncompleteUploadsArgs.Builder)ListIncompleteUploadsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(true).build());
    }

    @Deprecated
    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName, String prefix, boolean recursive) {
        return this.listIncompleteUploads((ListIncompleteUploadsArgs)((ListIncompleteUploadsArgs.Builder)ListIncompleteUploadsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(recursive).build());
    }

    public Iterable<Result<Upload>> listIncompleteUploads(ListIncompleteUploadsArgs args) {
        this.checkArgs(args);
        return this.listIncompleteUploads(args, true);
    }

    private Iterable<Result<Upload>> listIncompleteUploads(final ListIncompleteUploadsArgs args, final boolean aggregatePartSize) {
        return new Iterable<Result<Upload>>(){

            @Override
            public Iterator<Result<Upload>> iterator() {
                return new Iterator<Result<Upload>>(){
                    private String nextKeyMarker;
                    private String nextUploadIdMarker;
                    private ListMultipartUploadsResult listMultipartUploadsResult;
                    private Result<Upload> error;
                    private Iterator<Upload> uploadIterator;
                    private boolean completed;
                    {
                        this.nextKeyMarker = args.keyMarker();
                        this.nextUploadIdMarker = args.uploadIdMarker();
                        this.completed = false;
                    }

                    private synchronized void populate() {
                        String delimiter = args.delimiter();
                        if (args.recursive()) {
                            delimiter = null;
                        }
                        this.listMultipartUploadsResult = null;
                        this.uploadIterator = null;
                        try {
                            this.listMultipartUploadsResult = MinioClient.this.listMultipartUploads(args.bucket(), delimiter, this.nextKeyMarker, args.maxUploads(), args.prefix(), this.nextUploadIdMarker);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                        }
                        finally {
                            this.uploadIterator = this.listMultipartUploadsResult != null ? this.listMultipartUploadsResult.uploads().iterator() : new LinkedList().iterator();
                        }
                    }

                    private synchronized long getAggregatedPartSize(String objectName, String uploadId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
                        long aggregatedPartSize = 0L;
                        for (Result result : MinioClient.this.listObjectParts(args.bucket(), objectName, uploadId)) {
                            aggregatedPartSize += ((Part)result.get()).partSize();
                        }
                        return aggregatedPartSize;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.uploadIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.uploadIterator.hasNext() && this.listMultipartUploadsResult.isTruncated()) {
                            this.nextKeyMarker = this.listMultipartUploadsResult.nextKeyMarker();
                            this.nextUploadIdMarker = this.listMultipartUploadsResult.nextUploadIdMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.uploadIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Upload> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.uploadIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.uploadIterator.hasNext() && this.listMultipartUploadsResult.isTruncated()) {
                            this.nextKeyMarker = this.listMultipartUploadsResult.nextKeyMarker();
                            this.nextUploadIdMarker = this.listMultipartUploadsResult.nextUploadIdMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.uploadIterator.hasNext()) {
                            Upload upload = this.uploadIterator.next();
                            if (aggregatePartSize) {
                                long aggregatedPartSize;
                                try {
                                    aggregatedPartSize = this.getAggregatedPartSize(upload.objectName(), upload.uploadId());
                                }
                                catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                                    aggregatedPartSize = -1L;
                                }
                                upload.setAggregatedPartSize(aggregatedPartSize);
                            }
                            return new Result<Upload>(upload);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private Iterable<Result<Part>> listObjectParts(final String bucketName, final String objectName, final String uploadId) {
        return new Iterable<Result<Part>>(){

            @Override
            public Iterator<Result<Part>> iterator() {
                return new Iterator<Result<Part>>(){
                    private int nextPartNumberMarker;
                    private ListPartsResult listPartsResult;
                    private Result<Part> error;
                    private Iterator<Part> partIterator;
                    private boolean completed = false;

                    private synchronized void populate() {
                        this.listPartsResult = null;
                        this.partIterator = null;
                        try {
                            this.listPartsResult = MinioClient.this.listParts(bucketName, objectName, null, this.nextPartNumberMarker, uploadId);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                        }
                        finally {
                            this.partIterator = this.listPartsResult != null ? this.listPartsResult.partList().iterator() : new LinkedList().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.partIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.partIterator.hasNext() && this.listPartsResult.isTruncated()) {
                            this.nextPartNumberMarker = this.listPartsResult.nextPartNumberMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.partIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Part> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.partIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.partIterator.hasNext() && this.listPartsResult.isTruncated()) {
                            this.nextPartNumberMarker = this.listPartsResult.nextPartNumberMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.partIterator.hasNext()) {
                            return new Result<Part>(this.partIterator.next());
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Deprecated
    public void removeIncompleteUpload(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.removeIncompleteUpload((RemoveIncompleteUploadArgs)((RemoveIncompleteUploadArgs.Builder)((RemoveIncompleteUploadArgs.Builder)RemoveIncompleteUploadArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public void removeIncompleteUpload(RemoveIncompleteUploadArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        for (Result<Upload> r : this.listIncompleteUploads((ListIncompleteUploadsArgs)((ListIncompleteUploadsArgs.Builder)ListIncompleteUploadsArgs.builder().bucket(args.bucket())).prefix(args.object()).recursive(true).build(), false)) {
            Upload upload = r.get();
            if (!args.object().equals(upload.objectName())) continue;
            this.abortMultipartUpload(args.bucket(), args.object(), upload.uploadId());
            return;
        }
    }

    @Deprecated
    public CloseableIterator<Result<NotificationRecords>> listenBucketNotification(String bucketName, String prefix, String suffix, String[] events) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.listenBucketNotification((ListenBucketNotificationArgs)((ListenBucketNotificationArgs.Builder)ListenBucketNotificationArgs.builder().bucket(bucketName)).prefix(prefix).suffix(suffix).events(events).build());
    }

    public CloseableIterator<Result<NotificationRecords>> listenBucketNotification(ListenBucketNotificationArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"prefix", (Object)args.prefix());
        queryParams.put((Object)"suffix", (Object)args.suffix());
        for (String event : args.events()) {
            queryParams.put((Object)"events", (Object)event);
        }
        Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);
        NotificationResultRecords result = new NotificationResultRecords(response);
        return result.closeableIterator();
    }

    @Deprecated
    public SelectResponseStream selectObjectContent(String bucketName, String objectName, String sqlExpression, InputSerialization is, OutputSerialization os, boolean requestProgress, Long scanStartRange, Long scanEndRange, ServerSideEncryptionCustomerKey ssec) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.selectObjectContent((SelectObjectContentArgs)((SelectObjectContentArgs.Builder)((SelectObjectContentArgs.Builder)SelectObjectContentArgs.builder().bucket(bucketName)).object(objectName)).sqlExpression(sqlExpression).inputSerialization(is).outputSerialization(os).requestProgress(requestProgress).scanStartRange(scanStartRange).scanEndRange(scanEndRange).build());
    }

    public SelectResponseStream selectObjectContent(SelectObjectContentArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSsec(this.baseUrl);
        SetMultimap headers = null;
        if (args.ssec() != null) {
            headers = Multimaps.forMap(args.ssec().headers());
        }
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"select", (Object)"");
        queryParams.put((Object)"select-type", (Object)"2");
        Response response = this.executePost(args, (Multimap<String, String>)headers, (Multimap<String, String>)queryParams, new SelectObjectContentRequest(args.sqlExpression(), args.requestProgress(), args.inputSerialization(), args.outputSerialization(), args.scanStartRange(), args.scanEndRange()));
        return new SelectResponseStream(response.body().byteStream());
    }

    public void setBucketEncryption(SetBucketEncryptionArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"encryption", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, args.config(), 0);
        response.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SseConfiguration getBucketEncryption(GetBucketEncryptionArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"encryption", (Object)"");
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            SseConfiguration sseConfiguration = Xml.unmarshal(SseConfiguration.class, response.body().charStream());
            return sseConfiguration;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() == ErrorCode.SERVER_SIDE_ENCRYPTION_CONFIGURATION_NOT_FOUND_ERROR) return new SseConfiguration();
            throw e;
        }
    }

    public void deleteBucketEncryption(DeleteBucketEncryptionArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        block2: {
            this.checkArgs(args);
            HashMultimap queryParams = HashMultimap.create();
            queryParams.put((Object)"encryption", (Object)"");
            try {
                this.executeDelete(args, null, (Multimap<String, String>)queryParams);
            }
            catch (ErrorResponseException e) {
                if (e.errorResponse().errorCode() == ErrorCode.SERVER_SIDE_ENCRYPTION_CONFIGURATION_NOT_FOUND_ERROR) break block2;
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tags getBucketTags(GetBucketTagsArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"tagging", (Object)"");
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            Tags tags = Xml.unmarshal(Tags.class, response.body().charStream());
            return tags;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_TAG_SET) return new Tags();
            throw e;
        }
    }

    public void setBucketTags(SetBucketTagsArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"tagging", (Object)"");
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, args.tags(), 0);
        response.close();
    }

    public void deleteBucketTags(DeleteBucketTagsArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"tagging", (Object)"");
        this.executeDelete(args, null, (Multimap<String, String>)queryParams);
    }

    public Tags getObjectTags(GetObjectTagsArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"tagging", (Object)"");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        try (Response response = this.executeGet(args, null, (Multimap<String, String>)queryParams);){
            Tags tags = Xml.unmarshal(Tags.class, response.body().charStream());
            return tags;
        }
    }

    public void setObjectTags(SetObjectTagsArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"tagging", (Object)"");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut(args, null, (Multimap<String, String>)queryParams, args.tags(), 0);
        response.close();
    }

    public void deleteObjectTags(DeleteObjectTagsArgs args) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"tagging", (Object)"");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        this.executeDelete(args, null, (Multimap<String, String>)queryParams);
    }

    private long getAvailableSize(Object data, long expectedReadSize) throws IOException, InternalException {
        long totalBytesRead;
        int bytesRead;
        if (!(data instanceof BufferedInputStream)) {
            throw new InternalException("data must be BufferedInputStream. This should not happen.  Please report to https://github.com/minio/minio-java/issues/");
        }
        BufferedInputStream stream = (BufferedInputStream)data;
        stream.mark((int)expectedReadSize);
        byte[] buf = new byte[16384];
        for (totalBytesRead = 0L; totalBytesRead < expectedReadSize; totalBytesRead += (long)bytesRead) {
            long bytesToRead = expectedReadSize - totalBytesRead;
            if (bytesToRead > (long)buf.length) {
                bytesToRead = buf.length;
            }
            if ((bytesRead = stream.read(buf, 0, (int)bytesToRead)) < 0) break;
        }
        stream.reset();
        return totalBytesRead;
    }

    public void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        this.httpClient = this.httpClient.newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).build();
    }

    @SuppressFBWarnings(value={"SIC"}, justification="Should not be used in production anyways.")
    public void ignoreCertCheck() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        this.httpClient = this.httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
    }

    public void setAppInfo(String name, String version) {
        if (name == null || version == null) {
            return;
        }
        this.userAgent = DEFAULT_USER_AGENT + " " + name.trim() + "/" + version.trim();
    }

    public void traceOn(OutputStream traceStream) {
        if (traceStream == null) {
            throw new NullPointerException();
        }
        this.traceStream = new PrintWriter((Writer)new OutputStreamWriter(traceStream, StandardCharsets.UTF_8), true);
    }

    public void traceOff() throws IOException {
        this.traceStream = null;
    }

    public void enableAccelerateEndpoint() {
        this.isAcceleratedHost = true;
    }

    public void disableAccelerateEndpoint() {
        this.isAcceleratedHost = false;
    }

    public void enableDualStackEndpoint() {
        this.isDualStackHost = true;
    }

    public void disableDualStackEndpoint() {
        this.isDualStackHost = false;
    }

    public void enableVirtualStyleEndpoint() {
        this.useVirtualStyle = true;
    }

    public void disableVirtualStyleEndpoint() {
        this.useVirtualStyle = false;
    }

    protected void abortMultipartUpload(String bucketName, String objectName, String uploadId) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)UPLOAD_ID, (Object)uploadId);
        Response response = this.execute(Method.DELETE, bucketName, objectName, this.getRegion(bucketName, this.region), null, (Multimap<String, String>)queryParams, null, 0);
        response.close();
    }

    @Deprecated
    protected void completeMultipartUpload(String bucketName, String objectName, String uploadId, Part[] parts) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        this.completeMultipartUpload(bucketName, null, objectName, uploadId, parts, null, null);
    }

    /*
     * Exception decompiling
     */
    protected ObjectWriteResponse completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    protected String createMultipartUpload(String bucketName, String objectName, Map<String, String> headerMap) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        return this.createMultipartUpload(bucketName, this.getRegion(bucketName, null), objectName, (Multimap<String, String>)Multimaps.forMap(headerMap), null);
    }

    protected String createMultipartUpload(String bucketName, String region, String objectName, Multimap<String, String> headers, Multimap<String, String> extraQueryParams) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParams = HashMultimap.create();
        if (extraQueryParams != null) {
            queryParams.putAll(extraQueryParams);
        }
        queryParams.put((Object)"uploads", (Object)"");
        HashMultimap headersCopy = HashMultimap.create();
        if (headers != null) {
            headersCopy.putAll(headers);
        }
        if (!headersCopy.containsKey((Object)"Content-Type")) {
            headersCopy.put((Object)"Content-Type", (Object)"application/octet-stream");
        }
        try (Response response = this.execute(Method.POST, bucketName, objectName, this.getRegion(bucketName, region), (Multimap<String, String>)headersCopy, (Multimap<String, String>)queryParams, null, 0);){
            InitiateMultipartUploadResult result = Xml.unmarshal(InitiateMultipartUploadResult.class, response.body().charStream());
            String string = result.uploadId();
            return string;
        }
    }

    protected DeleteResult deleteObjects(String bucketName, List<DeleteObject> objectList, boolean quiet, boolean bypassGovernanceMode) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"delete", (Object)"");
        HashMultimap headers = null;
        if (bypassGovernanceMode) {
            headers = HashMultimap.create();
            headers.put((Object)"x-amz-bypass-governance-retention", (Object)"true");
        }
        try (Response response = this.execute(Method.POST, bucketName, null, this.getRegion(bucketName, null), (Multimap<String, String>)headers, (Multimap<String, String>)queryParams, new DeleteRequest(objectList, quiet), 0);){
            String bodyContent = new String(response.body().bytes(), StandardCharsets.UTF_8);
            try {
                if (Xml.validate(DeleteError.class, bodyContent)) {
                    DeleteError error = Xml.unmarshal(DeleteError.class, bodyContent);
                    DeleteResult deleteResult = new DeleteResult(error);
                    return deleteResult;
                }
            }
            catch (XmlParserException xmlParserException) {
                // empty catch block
            }
            DeleteResult deleteResult = Xml.unmarshal(DeleteResult.class, bodyContent);
            return deleteResult;
        }
    }

    private Multimap<String, String> getCommonListObjectsQueryParams(String delimiter, boolean useUrlEncodingType, int maxKeys, String prefix) {
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"delimiter", (Object)(delimiter == null ? "" : delimiter));
        if (useUrlEncodingType) {
            queryParams.put((Object)"encoding-type", (Object)"url");
        }
        queryParams.put((Object)"max-keys", (Object)Integer.toString(maxKeys > 0 ? maxKeys : 1000));
        queryParams.put((Object)"prefix", (Object)(prefix == null ? "" : prefix));
        return queryParams;
    }

    protected ListBucketResultV2 listObjectsV2(String bucketName, String region, String delimiter, boolean useUrlEncodingType, String startAfter, int maxKeys, String prefix, String continuationToken, boolean fetchOwner, boolean includeUserMetadata, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws InvalidKeyException, InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException, IOException {
        HashMultimap queryParams = HashMultimap.create();
        if (extraQueryParams != null) {
            queryParams.putAll(extraQueryParams);
        }
        queryParams.putAll(this.getCommonListObjectsQueryParams(delimiter, useUrlEncodingType, maxKeys, prefix));
        queryParams.put((Object)"list-type", (Object)"2");
        if (continuationToken != null) {
            queryParams.put((Object)"continuation-token", (Object)continuationToken);
        }
        if (fetchOwner) {
            queryParams.put((Object)"fetch-owner", (Object)"true");
        }
        if (startAfter != null) {
            queryParams.put((Object)"start-after", (Object)startAfter);
        }
        if (includeUserMetadata) {
            queryParams.put((Object)"metadata", (Object)"true");
        }
        try (Response response = this.execute(Method.GET, bucketName, null, this.getRegion(bucketName, region), extraHeaders, (Multimap<String, String>)queryParams, null, 0);){
            ListBucketResultV2 listBucketResultV2 = Xml.unmarshal(ListBucketResultV2.class, response.body().charStream());
            return listBucketResultV2;
        }
    }

    protected ListBucketResultV1 listObjectsV1(String bucketName, String region, String delimiter, boolean useUrlEncodingType, String marker, int maxKeys, String prefix, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParams = HashMultimap.create();
        if (extraQueryParams != null) {
            queryParams.putAll(extraQueryParams);
        }
        queryParams.putAll(this.getCommonListObjectsQueryParams(delimiter, useUrlEncodingType, maxKeys, prefix));
        if (marker != null) {
            queryParams.put((Object)"marker", (Object)marker);
        }
        try (Response response = this.execute(Method.GET, bucketName, null, this.getRegion(bucketName, region), extraHeaders, (Multimap<String, String>)queryParams, null, 0);){
            ListBucketResultV1 listBucketResultV1 = Xml.unmarshal(ListBucketResultV1.class, response.body().charStream());
            return listBucketResultV1;
        }
    }

    protected ListVersionsResult listObjectVersions(String bucketName, String region, String delimiter, boolean useUrlEncodingType, String keyMarker, int maxKeys, String prefix, String versionIdMarker, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParams = HashMultimap.create();
        if (extraQueryParams != null) {
            queryParams.putAll(extraQueryParams);
        }
        queryParams.putAll(this.getCommonListObjectsQueryParams(delimiter, useUrlEncodingType, maxKeys, prefix));
        if (keyMarker != null) {
            queryParams.put((Object)"key-marker", (Object)keyMarker);
        }
        if (versionIdMarker != null) {
            queryParams.put((Object)"version-id-marker", (Object)versionIdMarker);
        }
        queryParams.put((Object)"versions", (Object)"");
        try (Response response = this.execute(Method.GET, bucketName, null, this.getRegion(bucketName, region), extraHeaders, (Multimap<String, String>)queryParams, null, 0);){
            ListVersionsResult listVersionsResult = Xml.unmarshal(ListVersionsResult.class, response.body().charStream());
            return listVersionsResult;
        }
    }

    @Deprecated
    protected String putObject(String bucketName, String objectName, Object data, int length, Map<String, String> headerMap) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        ObjectWriteResponse reply = this.putObject(bucketName, null, objectName, data, length, (Multimap<String, String>)(headerMap != null ? Multimaps.forMap(headerMap) : null), null);
        return reply.etag();
    }

    protected ObjectWriteResponse putObject(String bucketName, String region, String objectName, Object data, int length, Multimap<String, String> headers, Multimap<String, String> extraQueryParams) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (!(data instanceof BufferedInputStream || data instanceof RandomAccessFile || data instanceof byte[] || data instanceof CharSequence)) {
            throw new IllegalArgumentException("data must be BufferedInputStream, RandomAccessFile, byte[] or String");
        }
        try (Response response = this.execute(Method.PUT, bucketName, objectName, this.getRegion(bucketName, region), headers, extraQueryParams, data, length);){
            ObjectWriteResponse objectWriteResponse = new ObjectWriteResponse(response.headers(), bucketName, region, objectName, response.header("ETag").replaceAll("\"", ""), response.header("x-amz-version-id"));
            return objectWriteResponse;
        }
    }

    protected ListMultipartUploadsResult listMultipartUploads(String bucketName, String delimiter, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"uploads", (Object)"");
        if (delimiter != null) {
            queryParams.put((Object)"delimiter", (Object)delimiter);
        } else {
            queryParams.put((Object)"delimiter", (Object)"");
        }
        if (keyMarker != null) {
            queryParams.put((Object)"key-marker", (Object)keyMarker);
        }
        if (maxUploads != null) {
            queryParams.put((Object)"max-uploads", (Object)Integer.toString(maxUploads));
        }
        if (prefix != null) {
            queryParams.put((Object)"prefix", (Object)prefix);
        } else {
            queryParams.put((Object)"prefix", (Object)"");
        }
        if (uploadIdMarker != null) {
            queryParams.put((Object)"upload-id-marker", (Object)uploadIdMarker);
        }
        queryParams.put((Object)"encoding-type", (Object)"url");
        Response response = this.execute(Method.GET, bucketName, null, this.getRegion(bucketName, null), null, (Multimap<String, String>)queryParams, null, 0);
        try (ResponseBody body = response.body();){
            ListMultipartUploadsResult listMultipartUploadsResult = Xml.unmarshal(ListMultipartUploadsResult.class, body.charStream());
            return listMultipartUploadsResult;
        }
    }

    protected ListPartsResult listParts(String bucketName, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParams = HashMultimap.create();
        if (maxParts != null) {
            queryParams.put((Object)"max-parts", (Object)Integer.toString(maxParts));
        }
        if (partNumberMarker != null) {
            queryParams.put((Object)"part-number-marker", (Object)Integer.toString(partNumberMarker));
        }
        queryParams.put((Object)UPLOAD_ID, (Object)uploadId);
        Response response = this.execute(Method.GET, bucketName, objectName, this.getRegion(bucketName, null), null, (Multimap<String, String>)queryParams, null, 0);
        try (ResponseBody body = response.body();){
            ListPartsResult listPartsResult = Xml.unmarshal(ListPartsResult.class, body.charStream());
            return listPartsResult;
        }
    }

    protected String uploadPart(String bucketName, String objectName, Object data, int length, String uploadId, int partNumber, Map<String, String> headerMap) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (!(data instanceof BufferedInputStream || data instanceof RandomAccessFile || data instanceof byte[] || data instanceof CharSequence)) {
            throw new IllegalArgumentException("data must be BufferedInputStream, RandomAccessFile, byte[] or String");
        }
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"partNumber", (Object)Integer.toString(partNumber));
        queryParams.put((Object)UPLOAD_ID, (Object)uploadId);
        try (Response response = this.execute(Method.PUT, bucketName, objectName, this.getRegion(bucketName, null), (Multimap<String, String>)(headerMap != null ? Multimaps.forMap(headerMap) : null), (Multimap<String, String>)queryParams, data, length);){
            String string = response.header("ETag").replaceAll("\"", "");
            return string;
        }
    }

    protected String uploadPartCopy(String bucketName, String objectName, String uploadId, int partNumber, Multimap<String, String> headers) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, ServerException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"partNumber", (Object)Integer.toString(partNumber));
        queryParams.put((Object)UPLOAD_ID, (Object)uploadId);
        Response response = this.execute(Method.PUT, bucketName, objectName, this.getRegion(bucketName, null), headers, (Multimap<String, String>)queryParams, null, 0);
        try (ResponseBody body = response.body();){
            CopyPartResult result = Xml.unmarshal(CopyPartResult.class, body.charStream());
            String string = result.etag();
            return string;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        amzHeaders.add("server-side-encryption");
        amzHeaders.add("server-side-encryption-aws-kms-key-id");
        amzHeaders.add("server-side-encryption-context");
        amzHeaders.add("server-side-encryption-customer-algorithm");
        amzHeaders.add("server-side-encryption-customer-key");
        amzHeaders.add("server-side-encryption-customer-key-md5");
        amzHeaders.add("website-redirect-location");
        amzHeaders.add("storage-class");
        standardHeaders = new HashSet<String>();
        standardHeaders.add("content-type");
        standardHeaders.add("cache-control");
        standardHeaders.add("content-encoding");
        standardHeaders.add("content-disposition");
        standardHeaders.add("content-language");
        standardHeaders.add("expires");
        standardHeaders.add("range");
    }

    public static final class Builder {
        HttpUrl baseUrl;
        String region;
        String accessKey;
        String secretKey;
        OkHttpClient httpClient;
        boolean isAwsHost;
        boolean isAwsChinaHost;
        boolean isAcceleratedHost;
        boolean isDualStackHost;
        boolean useVirtualStyle;
        String regionInUrl;

        private boolean isAwsEndpoint(String endpoint) {
            return !(!endpoint.startsWith("s3.") && !this.isAwsAccelerateEndpoint(endpoint) || !endpoint.endsWith(".amazonaws.com") && !endpoint.endsWith(".amazonaws.com.cn"));
        }

        private boolean isAwsAccelerateEndpoint(String endpoint) {
            return endpoint.startsWith("s3-accelerate.");
        }

        private boolean isAwsDualStackEndpoint(String endpoint) {
            return endpoint.contains(".dualstack.");
        }

        private String extractRegion(String endpoint) {
            String[] tokens = endpoint.split("\\.");
            String token = tokens[1];
            if (token.equals("dualstack")) {
                token = tokens[2];
            }
            if (token.equals("amazonaws")) {
                return null;
            }
            return token;
        }

        private void setBaseUrl(HttpUrl url) {
            String host = url.host();
            this.isAwsHost = this.isAwsEndpoint(host);
            this.isAwsChinaHost = false;
            if (this.isAwsHost) {
                this.isAwsChinaHost = host.endsWith(".cn");
                url = url.newBuilder().host(this.isAwsChinaHost ? "amazonaws.com.cn" : "amazonaws.com").build();
                this.isAcceleratedHost = this.isAwsAccelerateEndpoint(host);
                this.isDualStackHost = this.isAwsDualStackEndpoint(host);
                this.regionInUrl = this.extractRegion(host);
                this.useVirtualStyle = true;
            } else {
                this.useVirtualStyle = host.endsWith("aliyuncs.com");
            }
            this.baseUrl = url;
        }

        private OkHttpClient enableExternalCertificates(OkHttpClient httpClient, String filename) throws GeneralSecurityException, IOException {
            Collection<? extends Certificate> certificates = null;
            try (FileInputStream fis = new FileInputStream(filename);){
                certificates = CertificateFactory.getInstance("X.509").generateCertificates(fis);
            }
            if (certificates == null || certificates.isEmpty()) {
                throw new IllegalArgumentException("expected non-empty set of trusted certificates");
            }
            char[] password = "password".toCharArray();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            int index = 0;
            for (Certificate certificate : certificates) {
                String certificateAlias = Integer.toString(index++);
                keyStore.setCertificateEntry(certificateAlias, certificate);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManagers[0]).build();
        }

        protected void validateNotNull(Object arg, String argName) {
            if (arg == null) {
                throw new IllegalArgumentException(argName + " must not be null.");
            }
        }

        protected void validateNotEmptyString(String arg, String argName) {
            this.validateNotNull(arg, argName);
            if (arg.isEmpty()) {
                throw new IllegalArgumentException(argName + " must be a non-empty string.");
            }
        }

        protected void validateNullOrNotEmptyString(String arg, String argName) {
            if (arg != null && arg.isEmpty()) {
                throw new IllegalArgumentException(argName + " must be a non-empty string.");
            }
        }

        private void validateUrl(HttpUrl url) {
            if (!url.encodedPath().equals("/")) {
                throw new IllegalArgumentException("no path allowed in endpoint " + url);
            }
        }

        private void validateHostnameOrIPAddress(String endpoint) {
            if (InetAddressValidator.getInstance().isValid(endpoint)) {
                return;
            }
            if (endpoint.length() < 1 || endpoint.length() > 253) {
                throw new IllegalArgumentException("invalid hostname");
            }
            for (String label : endpoint.split("\\.")) {
                if (label.length() < 1 || label.length() > 63) {
                    throw new IllegalArgumentException("invalid hostname");
                }
                if (label.matches("^[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?$")) continue;
                throw new IllegalArgumentException("invalid hostname");
            }
        }

        private HttpUrl getBaseUrl(String endpoint) {
            this.validateNotEmptyString(endpoint, "endpoint");
            HttpUrl url = HttpUrl.parse((String)endpoint);
            if (url == null) {
                this.validateHostnameOrIPAddress(endpoint);
                url = new HttpUrl.Builder().scheme("https").host(endpoint).build();
            } else {
                this.validateUrl(url);
            }
            return url;
        }

        public Builder endpoint(String endpoint) {
            this.setBaseUrl(this.getBaseUrl(endpoint));
            return this;
        }

        public Builder endpoint(String endpoint, int port, boolean secure) {
            HttpUrl url = this.getBaseUrl(endpoint);
            if (port < 1 || port > 65535) {
                throw new IllegalArgumentException("port must be in range of 1 to 65535");
            }
            url = url.newBuilder().port(port).scheme(secure ? "https" : "http").build();
            this.setBaseUrl(url);
            return this;
        }

        private Builder endpoint(String endpoint, Integer port, Boolean secure) {
            HttpUrl url = this.getBaseUrl(endpoint);
            if (port != null) {
                if (port < 1 || port > 65535) {
                    throw new IllegalArgumentException("port must be in range of 1 to 65535");
                }
                url = url.newBuilder().port(port.intValue()).build();
            }
            if (secure != null) {
                url = url.newBuilder().scheme(secure != false ? "https" : "http").build();
            }
            this.setBaseUrl(url);
            return this;
        }

        public Builder endpoint(URL url) {
            this.validateNotNull(url, "url");
            return this.endpoint(HttpUrl.get((URL)url));
        }

        public Builder endpoint(HttpUrl url) {
            this.validateNotNull(url, "url");
            this.validateUrl(url);
            this.setBaseUrl(url);
            return this;
        }

        public Builder region(String region) {
            this.validateNullOrNotEmptyString(region, "region");
            this.region = region;
            this.regionInUrl = region;
            return this;
        }

        public Builder credentials(String accessKey, String secretKey) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.validateNotNull(httpClient, "http client");
            this.httpClient = httpClient;
            return this;
        }

        public MinioClient build() {
            this.validateNotNull(this.baseUrl, "endpoint");
            if (this.isAwsChinaHost && this.regionInUrl == null && this.region == null) {
                throw new IllegalArgumentException("Region missing in Amazon S3 China endpoint " + this.baseUrl);
            }
            if (this.httpClient == null) {
                this.httpClient = new OkHttpClient().newBuilder().connectTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).protocols(Arrays.asList(Protocol.HTTP_1_1)).build();
                String filename = System.getenv("SSL_CERT_FILE");
                if (filename != null && !filename.isEmpty()) {
                    try {
                        this.httpClient = this.enableExternalCertificates(this.httpClient, filename);
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return new MinioClient(this.baseUrl, this.region != null ? this.region : this.regionInUrl, this.isAwsHost, this.isAcceleratedHost, this.isDualStackHost, this.useVirtualStyle, this.accessKey, this.secretKey, this.httpClient);
        }
    }

    private static class NotificationResultRecords {
        Response response = null;
        Scanner scanner = null;
        ObjectMapper mapper = null;

        public NotificationResultRecords(Response response) {
            this.response = response;
            this.scanner = new Scanner(response.body().charStream()).useDelimiter("\n");
            this.mapper = new ObjectMapper();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        }

        public CloseableIterator<Result<NotificationRecords>> closeableIterator() {
            return new CloseableIterator<Result<NotificationRecords>>(){
                String recordsString = null;
                NotificationRecords records = null;
                boolean isClosed = false;

                @Override
                public void close() throws IOException {
                    if (!this.isClosed) {
                        try {
                            response.body().close();
                            scanner.close();
                        }
                        finally {
                            this.isClosed = true;
                        }
                    }
                }

                public boolean populate() {
                    if (this.isClosed) {
                        return false;
                    }
                    if (this.recordsString != null) {
                        return true;
                    }
                    while (scanner.hasNext()) {
                        this.recordsString = scanner.next().trim();
                        if (this.recordsString.equals("")) continue;
                    }
                    if (this.recordsString == null || this.recordsString.equals("")) {
                        try {
                            this.close();
                        }
                        catch (IOException e) {
                            this.isClosed = true;
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean hasNext() {
                    return this.populate();
                }

                @Override
                public Result<NotificationRecords> next() {
                    if (this.isClosed) {
                        throw new NoSuchElementException();
                    }
                    if ((this.recordsString == null || this.recordsString.equals("")) && !this.populate()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        this.records = (NotificationRecords)mapper.readValue(this.recordsString, NotificationRecords.class);
                        Result<NotificationRecords> result = new Result<NotificationRecords>(this.records);
                        return result;
                    }
                    catch (JsonMappingException e) {
                        Result<NotificationRecords> result = new Result<NotificationRecords>((Exception)((Object)e));
                        return result;
                    }
                    catch (JsonParseException e) {
                        Result<NotificationRecords> result = new Result<NotificationRecords>((Exception)((Object)e));
                        return result;
                    }
                    catch (IOException e) {
                        Result<NotificationRecords> result = new Result<NotificationRecords>(e);
                        return result;
                    }
                    finally {
                        this.recordsString = null;
                        this.records = null;
                    }
                }
            };
        }
    }

    private abstract class ObjectIterator
    implements Iterator<Result<Item>> {
        protected Result<Item> error;
        protected Iterator<? extends Item> itemIterator;
        protected Iterator<DeleteMarker> deleteMarkerIterator;
        protected Iterator<Prefix> prefixIterator;
        protected boolean completed = false;
        protected ListObjectsResult listObjectsResult;
        protected String lastObjectName;

        private ObjectIterator() {
        }

        protected abstract void populateResult() throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException;

        protected synchronized void populate() {
            try {
                this.populateResult();
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                this.error = new Result(e);
            }
            if (this.listObjectsResult != null) {
                this.itemIterator = this.listObjectsResult.contents().iterator();
                this.deleteMarkerIterator = this.listObjectsResult.deleteMarkers().iterator();
                this.prefixIterator = this.listObjectsResult.commonPrefixes().iterator();
            } else {
                this.itemIterator = new LinkedList().iterator();
                this.deleteMarkerIterator = new LinkedList().iterator();
                this.prefixIterator = new LinkedList().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.completed) {
                return false;
            }
            if (this.error == null && this.itemIterator == null && this.deleteMarkerIterator == null && this.prefixIterator == null) {
                this.populate();
            }
            if (this.error == null && !this.itemIterator.hasNext() && !this.deleteMarkerIterator.hasNext() && !this.prefixIterator.hasNext() && this.listObjectsResult.isTruncated()) {
                this.populate();
            }
            if (this.error != null) {
                return true;
            }
            if (this.itemIterator.hasNext()) {
                return true;
            }
            if (this.deleteMarkerIterator.hasNext()) {
                return true;
            }
            if (this.prefixIterator.hasNext()) {
                return true;
            }
            this.completed = true;
            return false;
        }

        @Override
        public Result<Item> next() {
            if (this.completed) {
                throw new NoSuchElementException();
            }
            if (this.error == null && this.itemIterator == null && this.deleteMarkerIterator == null && this.prefixIterator == null) {
                this.populate();
            }
            if (this.error == null && !this.itemIterator.hasNext() && !this.deleteMarkerIterator.hasNext() && !this.prefixIterator.hasNext() && this.listObjectsResult.isTruncated()) {
                this.populate();
            }
            if (this.error != null) {
                this.completed = true;
                return this.error;
            }
            if (this.itemIterator.hasNext()) {
                Item item = this.itemIterator.next();
                this.lastObjectName = item.objectName();
                return new Result<Item>(item);
            }
            if (this.deleteMarkerIterator.hasNext()) {
                return new Result<Item>(this.deleteMarkerIterator.next());
            }
            if (this.prefixIterator.hasNext()) {
                return new Result<Item>(this.prefixIterator.next().toItem());
            }
            this.completed = true;
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

