/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.minio.ObjectReadArgs;
import io.minio.S3Escaper;
import io.minio.Time;
import java.time.ZonedDateTime;

public abstract class ObjectConditionalReadArgs
extends ObjectReadArgs {
    protected Long offset;
    protected Long length;
    protected String matchETag;
    protected String notMatchETag;
    protected ZonedDateTime modifiedSince;
    protected ZonedDateTime unmodifiedSince;

    public Long offset() {
        return this.offset;
    }

    public Long length() {
        return this.length;
    }

    public String matchETag() {
        return this.matchETag;
    }

    public String notMatchETag() {
        return this.notMatchETag;
    }

    public ZonedDateTime modifiedSince() {
        return this.modifiedSince;
    }

    public ZonedDateTime unmodifiedSince() {
        return this.unmodifiedSince;
    }

    public Multimap<String, String> genCopyHeaders() {
        HashMultimap headers = HashMultimap.create();
        String copySource = S3Escaper.encodePath("/" + this.bucketName + "/" + this.objectName);
        if (this.versionId != null) {
            copySource = copySource + "?versionId=" + S3Escaper.encode(this.versionId);
        }
        headers.put((Object)"x-amz-copy-source", (Object)copySource);
        if (this.ssec != null) {
            headers.putAll((Multimap)Multimaps.forMap(this.ssec.copySourceHeaders()));
        }
        if (this.matchETag != null) {
            headers.put((Object)"x-amz-copy-source-if-match", (Object)this.matchETag);
        }
        if (this.notMatchETag != null) {
            headers.put((Object)"x-amz-copy-source-if-none-match", (Object)this.notMatchETag);
        }
        if (this.modifiedSince != null) {
            headers.put((Object)"x-amz-copy-source-if-modified-since", (Object)this.modifiedSince.format(Time.HTTP_HEADER_DATE_FORMAT));
        }
        if (this.unmodifiedSince != null) {
            headers.put((Object)"x-amz-copy-source-if-unmodified-since", (Object)this.unmodifiedSince.format(Time.HTTP_HEADER_DATE_FORMAT));
        }
        return headers;
    }

    public static abstract class Builder<B extends Builder<B, A>, A extends ObjectConditionalReadArgs>
    extends ObjectReadArgs.Builder<B, A> {
        private void validateLength(Long length) {
            if (length != null && length <= 0L) {
                throw new IllegalArgumentException("length should be greater than zero");
            }
        }

        private void validateOffset(Long offset) {
            if (offset != null && offset < 0L) {
                throw new IllegalArgumentException("offset should be zero or greater");
            }
        }

        public B offset(Long offset) {
            this.validateOffset(offset);
            this.operations.add(args -> {
                args.offset = offset;
            });
            return (B)this;
        }

        public B length(Long length) {
            this.validateLength(length);
            this.operations.add(args -> {
                args.length = length;
            });
            return (B)this;
        }

        public B matchETag(String etag) {
            this.validateNullOrNotEmptyString(etag, "etag");
            this.operations.add(args -> {
                args.matchETag = etag;
            });
            return (B)this;
        }

        public B notMatchETag(String etag) {
            this.validateNullOrNotEmptyString(etag, "etag");
            this.operations.add(args -> {
                args.notMatchETag = etag;
            });
            return (B)this;
        }

        public B modifiedSince(ZonedDateTime modifiedTime) {
            this.operations.add(args -> {
                args.modifiedSince = modifiedTime;
            });
            return (B)this;
        }

        public B unmodifiedSince(ZonedDateTime unmodifiedTime) {
            this.operations.add(args -> {
                args.unmodifiedSince = unmodifiedTime;
            });
            return (B)this;
        }
    }
}

