/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import io.minio.Signer;
import io.minio.Time;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public class PostPolicy {
    private static final String ALGORITHM = "AWS4-HMAC-SHA256";
    private final String bucketName;
    private final String objectName;
    private final boolean startsWith;
    private final ZonedDateTime expirationDate;
    private String contentType;
    private int successActionStatus;
    private String contentEncoding;
    private long contentRangeStart;
    private long contentRangeEnd;

    public PostPolicy(String bucketName, String objectName, ZonedDateTime expirationDate) throws IllegalArgumentException {
        this(bucketName, objectName, false, expirationDate);
    }

    public PostPolicy(String bucketName, String objectName, boolean startsWith, ZonedDateTime expirationDate) throws IllegalArgumentException {
        if (bucketName == null) {
            throw new IllegalArgumentException("null bucket name");
        }
        this.bucketName = bucketName;
        if (objectName == null) {
            throw new IllegalArgumentException("null object name or prefix");
        }
        this.objectName = objectName;
        this.startsWith = startsWith;
        if (expirationDate == null) {
            throw new IllegalArgumentException("null expiration date");
        }
        this.expirationDate = expirationDate;
    }

    public void setContentType(String contentType) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)contentType)) {
            throw new IllegalArgumentException("empty content type");
        }
        this.contentType = contentType;
    }

    public void setSuccessActionStatus(int successActionStatus) throws IllegalArgumentException {
        if (successActionStatus != 200 && successActionStatus != 201 && successActionStatus != 204) {
            throw new IllegalArgumentException("Invalid action status, acceptable values are 200, 201, or 204");
        }
        this.successActionStatus = successActionStatus;
    }

    public void setContentEncoding(String contentEncoding) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)contentEncoding)) {
            throw new IllegalArgumentException("empty content encoding");
        }
        this.contentEncoding = contentEncoding;
    }

    public void setContentLength(long contentLength) throws IllegalArgumentException {
        if (contentLength <= 0L) {
            throw new IllegalArgumentException("negative content length");
        }
        this.setContentRange(contentLength, contentLength);
    }

    public void setContentRange(long startRange, long endRange) throws IllegalArgumentException {
        if (startRange <= 0L || endRange <= 0L) {
            throw new IllegalArgumentException("negative start/end range");
        }
        if (startRange > endRange) {
            throw new IllegalArgumentException("start range is higher than end range");
        }
        this.contentRangeStart = startRange;
        this.contentRangeEnd = endRange;
    }

    public String bucketName() {
        return this.bucketName;
    }

    private byte[] marshalJson(ArrayList<String[]> conditions) {
        StringBuilder sb = new StringBuilder();
        Joiner joiner = Joiner.on((String)"\",\"");
        sb.append("{");
        if (this.expirationDate != null) {
            sb.append("\"expiration\":\"" + this.expirationDate.format(Time.EXPIRATION_DATE_FORMAT) + "\"");
        }
        if (!conditions.isEmpty()) {
            sb.append(",\"conditions\":[");
            ListIterator<String[]> iterator = conditions.listIterator();
            while (iterator.hasNext()) {
                sb.append("[\"" + joiner.join((Object[])iterator.next()) + "\"]");
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    public Map<String, String> formData(String accessKey, String secretKey, String region) throws NoSuchAlgorithmException, InvalidKeyException, IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)region)) {
            throw new IllegalArgumentException("empty region");
        }
        return Collections.unmodifiableMap(this.makeFormData(accessKey, secretKey, region));
    }

    protected Map<String, String> makeFormData(String accessKey, String secretKey, String region) throws NoSuchAlgorithmException, InvalidKeyException {
        ArrayList<String[]> conditions = new ArrayList<String[]>();
        HashMap<String, String> formData = new HashMap<String, String>();
        conditions.add(new String[]{"eq", "$bucket", this.bucketName});
        formData.put("bucket", this.bucketName);
        if (this.startsWith) {
            conditions.add(new String[]{"starts-with", "$key", this.objectName});
            formData.put("key", this.objectName);
        } else {
            conditions.add(new String[]{"eq", "$key", this.objectName});
            formData.put("key", this.objectName);
        }
        if (this.contentType != null) {
            conditions.add(new String[]{"eq", "$Content-Type", this.contentType});
            formData.put("Content-Type", this.contentType);
        }
        if (this.contentEncoding != null) {
            conditions.add(new String[]{"eq", "$Content-Encoding", this.contentEncoding});
            formData.put("Content-Encoding", this.contentEncoding);
        }
        if (this.successActionStatus > 0) {
            conditions.add(new String[]{"eq", "$success_action_status", Integer.toString(this.successActionStatus)});
            formData.put("success_action_status", Integer.toString(this.successActionStatus));
        }
        if (this.contentRangeStart > 0L && this.contentRangeEnd > 0L) {
            conditions.add(new String[]{"content-length-range", Long.toString(this.contentRangeStart), Long.toString(this.contentRangeEnd)});
        }
        conditions.add(new String[]{"eq", "$x-amz-algorithm", ALGORITHM});
        formData.put("x-amz-algorithm", ALGORITHM);
        ZonedDateTime utcNow = ZonedDateTime.now(Time.UTC);
        String credential = Signer.credential(accessKey, utcNow, region);
        conditions.add(new String[]{"eq", "$x-amz-credential", credential});
        formData.put("x-amz-credential", credential);
        String amzDate = utcNow.format(Time.AMZ_DATE_FORMAT);
        conditions.add(new String[]{"eq", "$x-amz-date", amzDate});
        formData.put("x-amz-date", amzDate);
        String policybase64 = BaseEncoding.base64().encode(this.marshalJson(conditions));
        String signature = Signer.postPresignV4(policybase64, secretKey, utcNow, region);
        formData.put("policy", policybase64);
        formData.put("x-amz-signature", signature);
        return formData;
    }
}

