/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MinioEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":bucketName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "minio".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "bucketName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(65);
        props.add("bucketName");
        props.add("serverSideEncryption");
        props.add("prefix");
        props.add("synchronous");
        props.add("initialDelay");
        props.add("secure");
        props.add("useVersion1");
        props.add("notMatchETag");
        props.add("unModifiedSince");
        props.add("pojoRequest");
        props.add("proxyPort");
        props.add("bridgeErrorHandler");
        props.add("startAfter");
        props.add("delimiter");
        props.add("objectLock");
        props.add("greedy");
        props.add("maxMessagesPerPoll");
        props.add("scheduledExecutorService");
        props.add("bypassGovernanceMode");
        props.add("repeatCount");
        props.add("offset");
        props.add("moveAfterRead");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("backoffIdleThreshold");
        props.add("destinationObjectName");
        props.add("versionId");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("includeBody");
        props.add("startScheduler");
        props.add("accessKey");
        props.add("deleteAfterWrite");
        props.add("region");
        props.add("autoCloseBody");
        props.add("exceptionHandler");
        props.add("customHttpClient");
        props.add("backoffMultiplier");
        props.add("includeVersions");
        props.add("matchETag");
        props.add("recursive");
        props.add("scheduler");
        props.add("endpoint");
        props.add("storageClass");
        props.add("modifiedSince");
        props.add("useFixedDelay");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("serverSideEncryptionCustomerKey");
        props.add("policy");
        props.add("maxConnections");
        props.add("timeUnit");
        props.add("autoCreateBucket");
        props.add("secretKey");
        props.add("length");
        props.add("exchangePattern");
        props.add("keyName");
        props.add("includeFolders");
        props.add("destinationBucketName");
        props.add("minioClient");
        props.add("pollStrategy");
        props.add("deleteAfterRead");
        props.add("includeUserMetadata");
        props.add("objectName");
        props.add("operation");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("secretKey");
        secretProps.add("accessKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

