/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Objects;
import io.minio.BaseArgs;

public abstract class BucketArgs
extends BaseArgs {
    protected String bucketName;
    protected String region;

    public String bucket() {
        return this.bucketName;
    }

    public String region() {
        return this.region;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BucketArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BucketArgs that = (BucketArgs)o;
        return Objects.equal((Object)this.bucketName, (Object)that.bucketName) && Objects.equal((Object)this.region, (Object)that.region);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.bucketName, this.region});
    }

    public static abstract class Builder<B extends Builder<B, A>, A extends BucketArgs>
    extends BaseArgs.Builder<B, A> {
        protected void validateBucketName(String name) {
            this.validateNotNull(name, "bucket name");
            if (name.length() < 3 || name.length() > 63) {
                throw new IllegalArgumentException(name + " : bucket name must be at least 3 and no more than 63 characters long");
            }
            if (name.contains("..")) {
                String msg = "bucket name cannot contain successive periods. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
                throw new IllegalArgumentException(name + " : " + msg);
            }
            if (!name.matches("^[a-z0-9][a-z0-9\\.\\-]+[a-z0-9]$")) {
                String msg = "bucket name does not follow Amazon S3 standards. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
                throw new IllegalArgumentException(name + " : " + msg);
            }
        }

        private void validateRegion(String region) {
            this.validateNullOrNotEmptyString(region, "region");
        }

        @Override
        protected void validate(A args) {
            this.validateBucketName(((BucketArgs)args).bucketName);
        }

        public B bucket(String name) {
            this.validateBucketName(name);
            this.operations.add(args -> {
                args.bucketName = name;
            });
            return (B)this;
        }

        public B region(String region) {
            this.validateRegion(region);
            this.operations.add(args -> {
                args.region = region;
            });
            return (B)this;
        }
    }
}

