/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.schema.validation;

import com.worldturner.medeia.api.FailedValidationResult;
import com.worldturner.medeia.api.OkValidationResult;
import com.worldturner.medeia.api.ValidationResult;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import com.worldturner.medeia.schema.validation.SchemaValidatorKt;
import com.worldturner.medeia.schema.validation.stream.SchemaValidatorInstance;
import java.net.URI;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB%\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/worldturner/medeia/schema/validation/StringValidator;", "Lcom/worldturner/medeia/schema/validation/SchemaValidator;", "Lcom/worldturner/medeia/schema/validation/stream/SchemaValidatorInstance;", "maxLength", "", "minLength", "pattern", "Lkotlin/text/Regex;", "(Ljava/lang/Integer;Ljava/lang/Integer;Lkotlin/text/Regex;)V", "getMaxLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMinLength", "getPattern", "()Lkotlin/text/Regex;", "createInstance", "startLevel", "recordUnknownRefs", "", "unknownRefs", "", "Ljava/net/URI;", "validate", "Lcom/worldturner/medeia/api/ValidationResult;", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "location", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "validateText", "string", "", "Companion", "medeia-validator-core"})
public final class StringValidator
implements SchemaValidator,
SchemaValidatorInstance {
    @Nullable
    private final Integer maxLength;
    @Nullable
    private final Integer minLength;
    @Nullable
    private final Regex pattern;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SchemaValidatorInstance createInstance(int startLevel) {
        return this;
    }

    @Override
    public void recordUnknownRefs(@NotNull Collection<URI> unknownRefs) {
        Intrinsics.checkParameterIsNotNull(unknownRefs, (String)"unknownRefs");
    }

    @Override
    @Nullable
    public ValidationResult validate(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        if (token.getType() != JsonTokenType.VALUE_TEXT) {
            return OkValidationResult.INSTANCE;
        }
        String string = token.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return this.validateText(string, location);
    }

    private final ValidationResult validateText(String string, JsonTokenLocation location) {
        int it;
        Object object = string;
        int n = 0;
        int n2 = string.length();
        String string2 = object;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        int codePoints = string2.codePointCount(n, n2);
        Integer n3 = this.maxLength;
        if (n3 != null) {
            object = n3;
            it = ((Number)object).intValue();
            boolean bl = false;
            if (codePoints > it) {
                Collection collection = null;
                String string3 = "String length " + codePoints + " is greater than maxLength " + it;
                String string4 = "maxLength";
                String string5 = null;
                JsonTokenLocation jsonTokenLocation = location;
                return new FailedValidationResult(string4, string5, string3, jsonTokenLocation, collection, 18, null);
            }
        }
        Integer n4 = this.minLength;
        if (n4 != null) {
            object = n4;
            it = ((Number)object).intValue();
            boolean bl = false;
            if (codePoints < it) {
                Collection collection = null;
                String string6 = "String length " + codePoints + " is smaller than maxLength " + it;
                String string7 = "minLength";
                String string8 = null;
                JsonTokenLocation jsonTokenLocation = location;
                return new FailedValidationResult(string7, string8, string6, jsonTokenLocation, collection, 18, null);
            }
        }
        Regex regex = this.pattern;
        if (regex != null) {
            Object it2 = object = regex;
            boolean bl = false;
            if (!it2.containsMatchIn((CharSequence)string)) {
                Collection collection = null;
                String string9 = "Pattern " + it2 + " is not contained in text";
                String string10 = "pattern";
                String string11 = null;
                JsonTokenLocation jsonTokenLocation = location;
                return new FailedValidationResult(string10, string11, string9, jsonTokenLocation, collection, 18, null);
            }
        }
        return OkValidationResult.INSTANCE;
    }

    @Nullable
    public final Integer getMaxLength() {
        return this.maxLength;
    }

    @Nullable
    public final Integer getMinLength() {
        return this.minLength;
    }

    @Nullable
    public final Regex getPattern() {
        return this.pattern;
    }

    private StringValidator(Integer maxLength, Integer minLength, Regex pattern) {
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.pattern = pattern;
    }

    public /* synthetic */ StringValidator(Integer maxLength, Integer minLength, Regex pattern, DefaultConstructorMarker $constructor_marker) {
        this(maxLength, minLength, pattern);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/worldturner/medeia/schema/validation/StringValidator$Companion;", "", "()V", "create", "Lcom/worldturner/medeia/schema/validation/StringValidator;", "maxLength", "", "minLength", "pattern", "Lkotlin/text/Regex;", "(Ljava/lang/Integer;Ljava/lang/Integer;Lkotlin/text/Regex;)Lcom/worldturner/medeia/schema/validation/StringValidator;", "medeia-validator-core"})
    public static final class Companion {
        @Nullable
        public final StringValidator create(@Nullable Integer maxLength, @Nullable Integer minLength, @Nullable Regex pattern) {
            return SchemaValidatorKt.isAnyNotNull(maxLength, minLength, pattern) ? new StringValidator(maxLength, minLength, pattern, null) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

