/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.camel.Route;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TcpServerBindThread
extends Thread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MllpTcpServerConsumer consumer;

    public TcpServerBindThread(MllpTcpServerConsumer consumer) {
        this.consumer = consumer;
        String fullEndpointKey = consumer.getEndpoint().getEndpointKey();
        String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
        this.setName(String.format("%s - %s", this.getClass().getSimpleName(), endpointKey));
    }

    @Override
    public void run() {
        String routeId;
        MDC.put((String)"camel.contextId", (String)this.consumer.getEndpoint().getCamelContext().getName());
        Route route = this.consumer.getRoute();
        if (route != null && (routeId = route.getId()) != null) {
            MDC.put((String)"camel.routeId", (String)route.getId());
        }
        try {
            ServerSocket serverSocket = new ServerSocket();
            if (this.consumer.getConfiguration().hasReceiveBufferSize()) {
                serverSocket.setReceiveBufferSize(this.consumer.getConfiguration().getReceiveBufferSize());
            }
            if (this.consumer.getConfiguration().hasReuseAddress()) {
                serverSocket.setReuseAddress(this.consumer.getConfiguration().getReuseAddress());
            }
            serverSocket.setSoTimeout(this.consumer.getConfiguration().getAcceptTimeout());
            InetSocketAddress socketAddress = null == this.consumer.getEndpoint().getHostname() ? new InetSocketAddress(this.consumer.getEndpoint().getPort()) : new InetSocketAddress(this.consumer.getEndpoint().getHostname(), this.consumer.getEndpoint().getPort());
            this.log.debug("Attempting to bind to {}", (Object)socketAddress);
            long startTicks = System.currentTimeMillis();
            do {
                try {
                    if (this.consumer.getConfiguration().hasBacklog()) {
                        serverSocket.bind(socketAddress, this.consumer.getConfiguration().getBacklog());
                    } else {
                        serverSocket.bind(socketAddress);
                    }
                    this.consumer.startAcceptThread(serverSocket);
                }
                catch (BindException bindException) {
                    if (System.currentTimeMillis() > startTicks + (long)this.consumer.getConfiguration().getBindTimeout()) {
                        this.log.error("Failed to bind to address {} within timeout {}", new Object[]{socketAddress, this.consumer.getConfiguration().getBindTimeout(), bindException});
                        break;
                    }
                    this.log.warn("Failed to bind to address {} - retrying in {} milliseconds", (Object)socketAddress, (Object)this.consumer.getConfiguration().getBindRetryInterval());
                    try {
                        Thread.sleep(this.consumer.getConfiguration().getBindRetryInterval());
                    }
                    catch (InterruptedException interruptedEx) {
                        this.log.info("Bind to address {} interrupted", (Object)socketAddress, (Object)interruptedEx);
                        if (!this.isInterrupted()) {
                            super.interrupt();
                        }
                        break;
                    }
                }
                catch (IOException unexpectedEx) {
                    this.log.error("Unexpected exception encountered binding to address {}", (Object)socketAddress, (Object)unexpectedEx);
                    break;
                }
            } while (!this.isInterrupted() && !serverSocket.isBound());
        }
        catch (IOException ioEx) {
            this.log.error("Unexpected exception encountered initializing ServerSocket before attempting to bind", (Throwable)ioEx);
        }
    }
}

