/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AuthHandler;
import io.nats.client.Connection;
import io.nats.client.Options;
import io.nats.client.impl.NatsImpl;
import java.io.IOException;

public class Nats {
    public static final String CLIENT_VERSION = "2.6.6";
    public static final String CLIENT_LANGUAGE = "java";

    public static Connection connect() throws IOException, InterruptedException {
        Options options = new Options.Builder().server("nats://localhost:4222").build();
        return Nats.createConnection(options, false);
    }

    public static Connection connect(String url) throws IOException, InterruptedException {
        Options options = new Options.Builder().server(url).build();
        return Nats.createConnection(options, false);
    }

    public static Connection connect(Options options) throws IOException, InterruptedException {
        return Nats.createConnection(options, false);
    }

    public static void connectAsynchronously(Options options, boolean reconnectOnConnect) throws InterruptedException {
        if (options.getConnectionListener() == null) {
            throw new IllegalArgumentException("Connection Listener required in connectAsynchronously");
        }
        Thread t = new Thread(() -> {
            block2: {
                try {
                    NatsImpl.createConnection(options, reconnectOnConnect);
                }
                catch (Exception ex) {
                    if (options.getErrorListener() == null) break block2;
                    options.getErrorListener().exceptionOccurred(null, ex);
                }
            }
        });
        t.setName("NATS - async connection");
        t.start();
    }

    public static AuthHandler credentials(String credsFile) {
        return NatsImpl.credentials(credsFile);
    }

    public static AuthHandler credentials(String jwtFile, String nkeyFile) {
        return NatsImpl.credentials(jwtFile, nkeyFile);
    }

    public static AuthHandler staticCredentials(char[] jwt, char[] nkey) {
        return NatsImpl.staticCredentials(jwt, nkey);
    }

    private static Connection createConnection(Options options, boolean reconnectOnConnect) throws IOException, InterruptedException {
        return NatsImpl.createConnection(options, reconnectOnConnect);
    }

    private Nats() {
        throw new UnsupportedOperationException("Nats is a static class");
    }
}

