/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import java.time.Duration;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NatsProducer.class);
    private Connection connection;

    public NatsProducer(NatsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public NatsEndpoint getEndpoint() {
        return (NatsEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        NatsConfiguration config = this.getEndpoint().getConfiguration();
        byte[] body = (byte[])exchange.getIn().getBody(byte[].class);
        if (body == null) {
            body = ((String)exchange.getIn().getMandatoryBody(String.class)).getBytes();
        }
        LOG.debug("Publishing to topic: {}", (Object)config.getTopic());
        if (ObjectHelper.isNotEmpty((Object)config.getReplySubject())) {
            String replySubject = config.getReplySubject();
            this.connection.publish(config.getTopic(), replySubject, body);
        } else {
            this.connection.publish(config.getTopic(), body);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Starting Nats Producer");
        LOG.debug("Getting Nats Connection");
        this.connection = this.getEndpoint().getConfiguration().getConnection() != null ? this.getEndpoint().getConfiguration().getConnection() : this.getEndpoint().getConnection();
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping Nats Producer");
        if (ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getConnection())) {
            LOG.debug("Closing Nats Connection");
            if (this.connection != null && !this.connection.getStatus().equals((Object)Connection.Status.CLOSED)) {
                if (this.getEndpoint().getConfiguration().isFlushConnection()) {
                    LOG.debug("Flushing Nats Connection");
                    this.connection.flush(Duration.ofMillis(this.getEndpoint().getConfiguration().getFlushTimeout()));
                }
                this.connection.close();
            }
        }
        super.doStop();
    }
}

