/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.netty;

import java.util.Map;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

public class CamelNettySinkConnectorConfig
extends CamelSinkConnectorConfig {
    public static final String CAMEL_SINK_NETTY_PATH_PROTOCOL_CONF = "camel.sink.path.protocol";
    public static final String CAMEL_SINK_NETTY_PATH_PROTOCOL_DOC = "The protocol to use which can be tcp or udp. One of: [tcp] [udp]";
    public static final String CAMEL_SINK_NETTY_PATH_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_PATH_HOST_CONF = "camel.sink.path.host";
    public static final String CAMEL_SINK_NETTY_PATH_HOST_DOC = "The hostname. For the consumer the hostname is localhost or 0.0.0.0. For the producer the hostname is the remote host to connect to";
    public static final String CAMEL_SINK_NETTY_PATH_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_PATH_PORT_CONF = "camel.sink.path.port";
    public static final String CAMEL_SINK_NETTY_PATH_PORT_DOC = "The host port number";
    public static final Integer CAMEL_SINK_NETTY_PATH_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DISCONNECT_CONF = "camel.sink.endpoint.disconnect";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DISCONNECT_DOC = "Whether or not to disconnect(close) from Netty Channel right after use. Can be used for both consumer and producer.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_DISCONNECT_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEEP_ALIVE_CONF = "camel.sink.endpoint.keepAlive";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEEP_ALIVE_DOC = "Setting to ensure socket is not closed due to inactivity";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_KEEP_ALIVE_DEFAULT = true;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_REUSE_ADDRESS_CONF = "camel.sink.endpoint.reuseAddress";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_REUSE_ADDRESS_DOC = "Setting to facilitate socket multiplexing";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_REUSE_ADDRESS_DEFAULT = true;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_REUSE_CHANNEL_CONF = "camel.sink.endpoint.reuseChannel";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_REUSE_CHANNEL_DOC = "This option allows producers and consumers (in client mode) to reuse the same Netty Channel for the lifecycle of processing the Exchange. This is useful if you need to call a server multiple times in a Camel route and want to use the same network connection. When using this, the channel is not returned to the connection pool until the Exchange is done; or disconnected if the disconnect option is set to true. The reused Channel is stored on the Exchange as an exchange property with the key NettyConstants#NETTY_CHANNEL which allows you to obtain the channel during routing and use it as well.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_REUSE_CHANNEL_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SYNC_CONF = "camel.sink.endpoint.sync";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SYNC_DOC = "Setting to set endpoint as one-way or request-response";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_SYNC_DEFAULT = true;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TCP_NO_DELAY_CONF = "camel.sink.endpoint.tcpNoDelay";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TCP_NO_DELAY_DOC = "Setting to improve TCP protocol performance";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_TCP_NO_DELAY_DEFAULT = true;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CONNECT_TIMEOUT_CONF = "camel.sink.endpoint.connectTimeout";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CONNECT_TIMEOUT_DOC = "Time to wait for a socket connection to be available. Value is in milliseconds.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_CONNECT_TIMEOUT_DEFAULT = 10000;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_REQUEST_TIMEOUT_CONF = "camel.sink.endpoint.requestTimeout";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_REQUEST_TIMEOUT_DOC = "Allows to use a timeout for the Netty producer when calling a remote server. By default no timeout is in use. The value is in milli seconds, so eg 30000 is 30 seconds. The requestTimeout is using Netty's ReadTimeoutHandler to trigger the timeout.";
    public static final Long CAMEL_SINK_NETTY_ENDPOINT_REQUEST_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CLIENT_INITIALIZER_FACTORY_CONF = "camel.sink.endpoint.clientInitializerFactory";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CLIENT_INITIALIZER_FACTORY_DOC = "To use a custom ClientInitializerFactory";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CLIENT_INITIALIZER_FACTORY_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CORRELATION_MANAGER_CONF = "camel.sink.endpoint.correlationManager";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CORRELATION_MANAGER_DOC = "To use a custom correlation manager to manage how request and reply messages are mapped when using request/reply with the netty producer. This should only be used if you have a way to map requests together with replies such as if there is correlation ids in both the request and reply messages. This can be used if you want to multiplex concurrent messages on the same channel (aka connection) in netty. When doing this you must have a way to correlate the request and reply messages so you can store the right reply on the inflight Camel Exchange before its continued routed. We recommend extending the TimeoutCorrelationManagerSupport when you build custom correlation managers. This provides support for timeout and other complexities you otherwise would need to implement as well. See also the producerPoolEnabled option for more details.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CORRELATION_MANAGER_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_LAZY_CHANNEL_CREATION_CONF = "camel.sink.endpoint.lazyChannelCreation";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_LAZY_CHANNEL_CREATION_DOC = "Channels can be lazily created to avoid exceptions, if the remote server is not up and running when the Camel producer is started.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_LAZY_CHANNEL_CREATION_DEFAULT = true;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_ENABLED_CONF = "camel.sink.endpoint.producerPoolEnabled";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_ENABLED_DOC = "Whether producer pool is enabled or not. Important: If you turn this off then a single shared connection is used for the producer, also if you are doing request/reply. That means there is a potential issue with interleaved responses if replies comes back out-of-order. Therefore you need to have a correlation id in both the request and reply messages so you can properly correlate the replies to the Camel callback that is responsible for continue processing the message in Camel. To do this you need to implement NettyCamelStateCorrelationManager as correlation manager and configure it via the correlationManager option. See also the correlationManager option for more details.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_ACTIVE_CONF = "camel.sink.endpoint.producerPoolMaxActive";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_ACTIVE_DOC = "Sets the cap on the number of objects that can be allocated by the pool (checked out to clients, or idle awaiting checkout) at a given time. Use a negative value for no limit.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_ACTIVE_DEFAULT = -1;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_IDLE_CONF = "camel.sink.endpoint.producerPoolMaxIdle";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_IDLE_DOC = "Sets the cap on the number of idle instances in the pool.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_IDLE_DEFAULT = 100;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_EVICTABLE_IDLE_CONF = "camel.sink.endpoint.producerPoolMinEvictableIdle";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_EVICTABLE_IDLE_DOC = "Sets the minimum amount of time (value in millis) an object may sit idle in the pool before it is eligible for eviction by the idle object evictor.";
    public static final Long CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_EVICTABLE_IDLE_DEFAULT = 300000L;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_IDLE_CONF = "camel.sink.endpoint.producerPoolMinIdle";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_IDLE_DOC = "Sets the minimum number of instances allowed in the producer pool before the evictor thread (if active) spawns new objects.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_IDLE_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_UDP_CONNECTIONLESS_SENDING_CONF = "camel.sink.endpoint.udpConnectionlessSending";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_UDP_CONNECTIONLESS_SENDING_DOC = "This option supports connection less udp sending which is a real fire and forget. A connected udp send receive the PortUnreachableException if no one is listen on the receiving port.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_UDP_CONNECTIONLESS_SENDING_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_USE_BYTE_BUF_CONF = "camel.sink.endpoint.useByteBuf";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_USE_BYTE_BUF_DOC = "If the useByteBuf is true, netty producer will turn the message body into ByteBuf before sending it out.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_USE_BYTE_BUF_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_CONF = "camel.sink.endpoint.allowSerializedHeaders";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DOC = "Only used for TCP when transferExchange is true. When set to true, serializable objects in headers and properties will be added to the exchange. Otherwise Camel will exclude any non-serializable objects and log it at WARN level.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CHANNEL_GROUP_CONF = "camel.sink.endpoint.channelGroup";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CHANNEL_GROUP_DOC = "To use a explicit ChannelGroup.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_CHANNEL_GROUP_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_NATIVE_TRANSPORT_CONF = "camel.sink.endpoint.nativeTransport";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_NATIVE_TRANSPORT_DOC = "Whether to use native transport instead of NIO. Native transport takes advantage of the host operating system and is only supported on some platforms. You need to add the netty JAR for the host operating system you are using. See more details at: http://netty.io/wiki/native-transports.html";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_NATIVE_TRANSPORT_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_OPTIONS_CONF = "camel.sink.endpoint.options";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_OPTIONS_DOC = "Allows to configure additional netty options using option. as prefix. For example option.child.keepAlive=false to set the netty option child.keepAlive=false. See the Netty documentation for possible options that can be used.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_CONF = "camel.sink.endpoint.receiveBufferSize";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_DOC = "The TCP/UDP buffer sizes to be used during inbound communication. Size is bytes.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_DEFAULT = 65536;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_CONF = "camel.sink.endpoint.receiveBufferSizePredictor";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_DOC = "Configures the buffer size predictor. See details at Jetty documentation and this mail thread.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SEND_BUFFER_SIZE_CONF = "camel.sink.endpoint.sendBufferSize";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SEND_BUFFER_SIZE_DOC = "The TCP/UDP buffer sizes to be used during outbound communication. Size is bytes.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_SEND_BUFFER_SIZE_DEFAULT = 65536;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TRANSFER_EXCHANGE_CONF = "camel.sink.endpoint.transferExchange";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TRANSFER_EXCHANGE_DOC = "Only used for TCP. You can transfer the exchange over the wire instead of just the body. The following fields are transferred: In body, Out body, fault body, In headers, Out headers, fault headers, exchange properties, exchange exception. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_TRANSFER_EXCHANGE_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_CONF = "camel.sink.endpoint.udpByteArrayCodec";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_DOC = "For UDP only. If enabled the using byte array codec instead of Java serialization protocol.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_WORKER_COUNT_CONF = "camel.sink.endpoint.workerCount";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_WORKER_COUNT_DOC = "When netty works on nio mode, it uses default workerCount parameter from Netty (which is cpu_core_threads x 2). User can use this option to override the default workerCount from Netty.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_WORKER_COUNT_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_WORKER_GROUP_CONF = "camel.sink.endpoint.workerGroup";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_WORKER_GROUP_DOC = "To use a explicit EventLoopGroup as the boss thread pool. For example to share a thread pool with multiple consumers or producers. By default each consumer or producer has their own worker pool with 2 x cpu count core threads.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_WORKER_GROUP_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_CONF = "camel.sink.endpoint.allowDefaultCodec";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_DOC = "The netty component installs a default codec if both, encoder/decoder is null and textline is false. Setting allowDefaultCodec to false prevents the netty component from installing a default codec as the first element in the filter chain.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_DEFAULT = true;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_CONF = "camel.sink.endpoint.autoAppendDelimiter";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_DOC = "Whether or not to auto append missing end delimiter when sending using the textline codec.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_DEFAULT = true;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_CONF = "camel.sink.endpoint.decoderMaxLineLength";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_DOC = "The max line length to use for the textline codec.";
    public static final Integer CAMEL_SINK_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_DEFAULT = 1024;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DECODERS_CONF = "camel.sink.endpoint.decoders";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DECODERS_DOC = "A list of decoders to be used. You can use a String which have values separated by comma, and have the values be looked up in the Registry. Just remember to prefix the value with # so Camel knows it should lookup.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DECODERS_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DELIMITER_CONF = "camel.sink.endpoint.delimiter";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DELIMITER_DOC = "The delimiter to use for the textline codec. Possible values are LINE and NULL. One of: [LINE] [NULL]";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_DELIMITER_DEFAULT = "LINE";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENCODERS_CONF = "camel.sink.endpoint.encoders";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENCODERS_DOC = "A list of encoders to be used. You can use a String which have values separated by comma, and have the values be looked up in the Registry. Just remember to prefix the value with # so Camel knows it should lookup.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENCODERS_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENCODING_CONF = "camel.sink.endpoint.encoding";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENCODING_DOC = "The encoding (a charset name) to use for the textline codec. If not provided, Camel will use the JVM default Charset.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENCODING_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TEXTLINE_CONF = "camel.sink.endpoint.textline";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TEXTLINE_DOC = "Only used for TCP. If no codec is specified, you can use this flag to indicate a text line based codec; if not specified or the value is false, then Object Serialization is assumed over TCP - however only Strings are allowed to be serialized by default.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_TEXTLINE_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENABLED_PROTOCOLS_CONF = "camel.sink.endpoint.enabledProtocols";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENABLED_PROTOCOLS_DOC = "Which protocols to enable when using SSL";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_ENABLED_PROTOCOLS_DEFAULT = "TLSv1,TLSv1.1,TLSv1.2";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FILE_CONF = "camel.sink.endpoint.keyStoreFile";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FILE_DOC = "Client side certificate keystore to be used for encryption";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FILE_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FORMAT_CONF = "camel.sink.endpoint.keyStoreFormat";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FORMAT_DOC = "Keystore format to be used for payload encryption. Defaults to JKS if not set";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FORMAT_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_RESOURCE_CONF = "camel.sink.endpoint.keyStoreResource";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_RESOURCE_DOC = "Client side certificate keystore to be used for encryption. Is loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_RESOURCE_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PASSPHRASE_CONF = "camel.sink.endpoint.passphrase";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PASSPHRASE_DOC = "Password setting to use in order to encrypt/decrypt payloads sent using SSH";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_PASSPHRASE_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SECURITY_PROVIDER_CONF = "camel.sink.endpoint.securityProvider";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SECURITY_PROVIDER_DOC = "Security provider to be used for payload encryption. Defaults to SunX509 if not set.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SECURITY_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_CONF = "camel.sink.endpoint.ssl";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_DOC = "Setting to specify whether SSL encryption is applied to this endpoint";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_SSL_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_CONF = "camel.sink.endpoint.sslClientCertHeaders";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_DOC = "When enabled and in SSL mode, then the Netty consumer will enrich the Camel Message with headers having information about the client certificate such as subject name, issuer name, serial number, and the valid date range.";
    public static final Boolean CAMEL_SINK_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF = "camel.sink.endpoint.sslContextParameters";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_HANDLER_CONF = "camel.sink.endpoint.sslHandler";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_HANDLER_DOC = "Reference to a class that could be used to return an SSL Handler";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_SSL_HANDLER_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_FILE_CONF = "camel.sink.endpoint.trustStoreFile";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_FILE_DOC = "Server side certificate keystore to be used for encryption";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_FILE_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_CONF = "camel.sink.endpoint.trustStoreResource";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_DOC = "Server side certificate keystore to be used for encryption. Is loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.";
    public static final String CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.netty.lazyStartProducer";
    public static final String CAMEL_SINK_NETTY_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_NETTY_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.netty.basicPropertyBinding";
    public static final String CAMEL_SINK_NETTY_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_NETTY_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_NETTY_COMPONENT_CONFIGURATION_CONF = "camel.component.netty.configuration";
    public static final String CAMEL_SINK_NETTY_COMPONENT_CONFIGURATION_DOC = "To use the NettyConfiguration as configuration when creating endpoints.";
    public static final String CAMEL_SINK_NETTY_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.netty.sslContextParameters";
    public static final String CAMEL_SINK_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters";
    public static final String CAMEL_SINK_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.netty.useGlobalSslContextParameters";
    public static final String CAMEL_SINK_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters.";
    public static final Boolean CAMEL_SINK_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;

    public CamelNettySinkConnectorConfig(ConfigDef config, Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelNettySinkConnectorConfig(Map<String, String> parsedConfig) {
        this(CamelNettySinkConnectorConfig.conf(), parsedConfig);
    }

    public static ConfigDef conf(Map<String, String> parsedConfig) {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_NETTY_PATH_PROTOCOL_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_PATH_PROTOCOL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_NETTY_PATH_PROTOCOL_DOC);
        conf.define(CAMEL_SINK_NETTY_PATH_HOST_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_PATH_HOST_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_NETTY_PATH_HOST_DOC);
        conf.define(CAMEL_SINK_NETTY_PATH_PORT_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_PATH_PORT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_NETTY_PATH_PORT_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_DISCONNECT_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_DISCONNECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_DISCONNECT_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_KEEP_ALIVE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_KEEP_ALIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_KEEP_ALIVE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_REUSE_ADDRESS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_REUSE_ADDRESS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_REUSE_ADDRESS_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_REUSE_CHANNEL_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_REUSE_CHANNEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_REUSE_CHANNEL_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_SYNC_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_SYNC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_SYNC_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_TCP_NO_DELAY_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_TCP_NO_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_TCP_NO_DELAY_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_CONNECT_TIMEOUT_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_CONNECT_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_CONNECT_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.");
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_REQUEST_TIMEOUT_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SINK_NETTY_ENDPOINT_REQUEST_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_REQUEST_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_CLIENT_INITIALIZER_FACTORY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_CLIENT_INITIALIZER_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_CLIENT_INITIALIZER_FACTORY_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_CORRELATION_MANAGER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_CORRELATION_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_CORRELATION_MANAGER_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_LAZY_CHANNEL_CREATION_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_LAZY_CHANNEL_CREATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_LAZY_CHANNEL_CREATION_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_ENABLED_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_ENABLED_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_ACTIVE_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_ACTIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_ACTIVE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_IDLE_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_IDLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MAX_IDLE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_EVICTABLE_IDLE_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_EVICTABLE_IDLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_EVICTABLE_IDLE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_IDLE_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_IDLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_PRODUCER_POOL_MIN_IDLE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_UDP_CONNECTIONLESS_SENDING_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_UDP_CONNECTIONLESS_SENDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_UDP_CONNECTIONLESS_SENDING_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_USE_BYTE_BUF_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_USE_BYTE_BUF_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_USE_BYTE_BUF_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_CHANNEL_GROUP_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_CHANNEL_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_CHANNEL_GROUP_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_NATIVE_TRANSPORT_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_NATIVE_TRANSPORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_NATIVE_TRANSPORT_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_OPTIONS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_OPTIONS_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_SEND_BUFFER_SIZE_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_SEND_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_SEND_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_TRANSFER_EXCHANGE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_TRANSFER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_TRANSFER_EXCHANGE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_WORKER_COUNT_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_WORKER_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_WORKER_COUNT_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_WORKER_GROUP_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_WORKER_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_WORKER_GROUP_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_DECODERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_DECODERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_DECODERS_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_DELIMITER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_DELIMITER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_DELIMITER_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_ENCODERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_ENCODERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_ENCODERS_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_ENCODING_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_ENCODING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_ENCODING_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_TEXTLINE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_TEXTLINE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_TEXTLINE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_ENABLED_PROTOCOLS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_ENABLED_PROTOCOLS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_ENABLED_PROTOCOLS_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FILE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FILE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FORMAT_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_FORMAT_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_RESOURCE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_RESOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_KEY_STORE_RESOURCE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_PASSPHRASE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_PASSPHRASE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_PASSPHRASE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_SECURITY_PROVIDER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_SECURITY_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_SECURITY_PROVIDER_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_SSL_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_SSL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_SSL_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, "To configure security using SSLContextParameters");
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_SSL_HANDLER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_SSL_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_SSL_HANDLER_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_FILE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_FILE_DOC);
        conf.define(CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_DOC);
        conf.define(CAMEL_SINK_NETTY_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.");
        conf.define(CAMEL_SINK_NETTY_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_NETTY_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, "To configure security using SSLContextParameters");
        conf.define(CAMEL_SINK_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        return conf;
    }
}

