/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.pdf;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelPdfSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_PDF_PATH_OPERATION_CONF = "camel.sink.path.operation";
    public static final String CAMEL_SINK_PDF_PATH_OPERATION_DOC = "Operation type One of: [create] [append] [extractText]";
    public static final String CAMEL_SINK_PDF_PATH_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_PDF_ENDPOINT_FONT_CONF = "camel.sink.endpoint.font";
    public static final String CAMEL_SINK_PDF_ENDPOINT_FONT_DOC = "Font One of: [Courier] [Courier-Bold] [Courier-Oblique] [Courier-BoldOblique] [Helvetica] [Helvetica-Bold] [Helvetica-Oblique] [Helvetica-BoldOblique] [Times-Roman] [Times-Bold] [Times-Italic] [Times-BoldItalic] [Symbol] [ZapfDingbats]";
    public static final String CAMEL_SINK_PDF_ENDPOINT_FONT_DEFAULT = "Helvetica";
    public static final String CAMEL_SINK_PDF_ENDPOINT_FONT_SIZE_CONF = "camel.sink.endpoint.fontSize";
    public static final String CAMEL_SINK_PDF_ENDPOINT_FONT_SIZE_DOC = "Font size in pixels";
    public static final Float CAMEL_SINK_PDF_ENDPOINT_FONT_SIZE_DEFAULT = 14F;
    public static final String CAMEL_SINK_PDF_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_PDF_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_PDF_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_PDF_ENDPOINT_MARGIN_BOTTOM_CONF = "camel.sink.endpoint.marginBottom";
    public static final String CAMEL_SINK_PDF_ENDPOINT_MARGIN_BOTTOM_DOC = "Margin bottom in pixels";
    public static final Integer CAMEL_SINK_PDF_ENDPOINT_MARGIN_BOTTOM_DEFAULT = 20;
    public static final String CAMEL_SINK_PDF_ENDPOINT_MARGIN_LEFT_CONF = "camel.sink.endpoint.marginLeft";
    public static final String CAMEL_SINK_PDF_ENDPOINT_MARGIN_LEFT_DOC = "Margin left in pixels";
    public static final Integer CAMEL_SINK_PDF_ENDPOINT_MARGIN_LEFT_DEFAULT = 20;
    public static final String CAMEL_SINK_PDF_ENDPOINT_MARGIN_RIGHT_CONF = "camel.sink.endpoint.marginRight";
    public static final String CAMEL_SINK_PDF_ENDPOINT_MARGIN_RIGHT_DOC = "Margin right in pixels";
    public static final Integer CAMEL_SINK_PDF_ENDPOINT_MARGIN_RIGHT_DEFAULT = 40;
    public static final String CAMEL_SINK_PDF_ENDPOINT_MARGIN_TOP_CONF = "camel.sink.endpoint.marginTop";
    public static final String CAMEL_SINK_PDF_ENDPOINT_MARGIN_TOP_DOC = "Margin top in pixels";
    public static final Integer CAMEL_SINK_PDF_ENDPOINT_MARGIN_TOP_DEFAULT = 20;
    public static final String CAMEL_SINK_PDF_ENDPOINT_PAGE_SIZE_CONF = "camel.sink.endpoint.pageSize";
    public static final String CAMEL_SINK_PDF_ENDPOINT_PAGE_SIZE_DOC = "Page size One of: [LETTER] [LEGAL] [A0] [A1] [A2] [A3] [A4] [A5] [A6]";
    public static final String CAMEL_SINK_PDF_ENDPOINT_PAGE_SIZE_DEFAULT = "A4";
    public static final String CAMEL_SINK_PDF_ENDPOINT_TEXT_PROCESSING_FACTORY_CONF = "camel.sink.endpoint.textProcessingFactory";
    public static final String CAMEL_SINK_PDF_ENDPOINT_TEXT_PROCESSING_FACTORY_DOC = "Text processing to use. autoFormatting: Text is getting sliced by words, then max amount of words that fits in the line will be written into pdf document. With this strategy all words that doesn't fit in the line will be moved to the new line. lineTermination: Builds set of classes for line-termination writing strategy. Text getting sliced by line termination symbol and then it will be written regardless it fits in the line or not. One of: [autoFormatting] [lineTermination]";
    public static final String CAMEL_SINK_PDF_ENDPOINT_TEXT_PROCESSING_FACTORY_DEFAULT = "lineTermination";
    public static final String CAMEL_SINK_PDF_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_PDF_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_PDF_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_PDF_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_PDF_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_PDF_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_PDF_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.pdf.lazyStartProducer";
    public static final String CAMEL_SINK_PDF_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_PDF_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_PDF_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.pdf.basicPropertyBinding";
    public static final String CAMEL_SINK_PDF_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_PDF_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelPdfSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelPdfSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_PDF_PATH_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_PDF_PATH_OPERATION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_PDF_PATH_OPERATION_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_FONT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_PDF_ENDPOINT_FONT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_FONT_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_FONT_SIZE_CONF, ConfigDef.Type.DOUBLE, CAMEL_SINK_PDF_ENDPOINT_FONT_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_FONT_SIZE_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_PDF_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_MARGIN_BOTTOM_CONF, ConfigDef.Type.INT, CAMEL_SINK_PDF_ENDPOINT_MARGIN_BOTTOM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_MARGIN_BOTTOM_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_MARGIN_LEFT_CONF, ConfigDef.Type.INT, CAMEL_SINK_PDF_ENDPOINT_MARGIN_LEFT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_MARGIN_LEFT_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_MARGIN_RIGHT_CONF, ConfigDef.Type.INT, CAMEL_SINK_PDF_ENDPOINT_MARGIN_RIGHT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_MARGIN_RIGHT_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_MARGIN_TOP_CONF, ConfigDef.Type.INT, CAMEL_SINK_PDF_ENDPOINT_MARGIN_TOP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_MARGIN_TOP_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_PAGE_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_PDF_ENDPOINT_PAGE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_PAGE_SIZE_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_TEXT_PROCESSING_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_PDF_ENDPOINT_TEXT_PROCESSING_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_TEXT_PROCESSING_FACTORY_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_PDF_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_PDF_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_PDF_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_PDF_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_PDF_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_PDF_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_PDF_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_PDF_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}