/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class RestEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":method:path:uriTemplate";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "rest".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "method", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "path", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "uriTemplate", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(20);
        props.add("method");
        props.add("consumerComponentName");
        props.add("uriTemplate");
        props.add("synchronous");
        props.add("exchangePattern");
        props.add("description");
        props.add("outType");
        props.add("path");
        props.add("lazyStartProducer");
        props.add("routeId");
        props.add("bridgeErrorHandler");
        props.add("bindingMode");
        props.add("queryParameters");
        props.add("produces");
        props.add("host");
        props.add("producerComponentName");
        props.add("inType");
        props.add("exceptionHandler");
        props.add("consumes");
        props.add("apiDoc");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

