/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteTemplateDefinition;

public final class TemplatedRouteBuilder {
    private final CamelContext camelContext;
    private final String routeTemplateId;
    private String routeId;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private Consumer<RouteTemplateDefinition> handler;

    private TemplatedRouteBuilder(CamelContext camelContext, String routeTemplateId) {
        this.camelContext = camelContext;
        this.routeTemplateId = routeTemplateId;
    }

    public static TemplatedRouteBuilder builder(CamelContext camelContext, String routeTemplateId) {
        return new TemplatedRouteBuilder(camelContext, routeTemplateId);
    }

    public TemplatedRouteBuilder routeId(String routeId) {
        this.routeId = routeId;
        return this;
    }

    public TemplatedRouteBuilder parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public TemplatedRouteBuilder handler(Consumer<RouteTemplateDefinition> handler) {
        this.handler = handler;
        return this;
    }

    public String add() {
        try {
            if (this.handler != null) {
                RouteTemplateDefinition def = ((ModelCamelContext)this.camelContext.adapt(ModelCamelContext.class)).getRouteTemplateDefinition(this.routeTemplateId);
                if (def == null) {
                    throw new IllegalArgumentException("Cannot find RouteTemplate with id " + this.routeTemplateId);
                }
                this.handler.accept(def);
            }
            return this.camelContext.addRouteFromTemplate(this.routeId, this.routeTemplateId, this.parameters);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }
}

