/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.CollectionStringBuffer;

@Metadata(firstVersion="1.3.0", label="dataformat,transformation,xml,json", title="XStream")
@XmlRootElement(name="xstream")
@XmlAccessorType(value=XmlAccessType.NONE)
public class XStreamDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String permissions;
    @XmlAttribute
    private String encoding;
    @XmlAttribute
    private String driver;
    @XmlAttribute
    private String driverRef;
    @XmlAttribute
    private String mode;
    @XmlElement(name="converters")
    private List<PropertyDefinition> converters;
    @XmlElement(name="aliases")
    private List<PropertyDefinition> aliases;
    @XmlElement(name="omitFields")
    private List<PropertyDefinition> omitFields;
    @XmlElement(name="implicitCollections")
    private List<PropertyDefinition> implicitCollections;

    public XStreamDataFormat() {
        super("xstream");
    }

    public XStreamDataFormat(String encoding) {
        this();
        this.setEncoding(encoding);
    }

    @Override
    public String getDataFormatName() {
        return "json".equals(this.driver) ? "json-xstream" : "xstream";
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriverRef() {
        return this.driverRef;
    }

    public void setDriverRef(String driverRef) {
        this.driverRef = driverRef;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<PropertyDefinition> getConverters() {
        return this.converters;
    }

    public Map<String, String> getConvertersAsMap() {
        if (this.converters == null || this.converters.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (PropertyDefinition def : this.converters) {
            answer.put(def.getKey(), def.getValue());
        }
        return answer;
    }

    public void setConverters(List<PropertyDefinition> converters) {
        this.converters = converters;
    }

    public void setConverters(Map<String, String> converters) {
        this.converters = new ArrayList<PropertyDefinition>();
        converters.forEach((k, v) -> this.converters.add(new PropertyDefinition((String)k, (String)v)));
    }

    public List<PropertyDefinition> getAliases() {
        return this.aliases;
    }

    public Map<String, String> getAliasesAsMap() {
        if (this.aliases == null || this.aliases.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (PropertyDefinition def : this.aliases) {
            answer.put(def.getKey(), def.getValue());
        }
        return answer;
    }

    public void setAliases(List<PropertyDefinition> aliases) {
        this.aliases = aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = new ArrayList<PropertyDefinition>();
        aliases.forEach((k, v) -> this.aliases.add(new PropertyDefinition((String)k, (String)v)));
    }

    public List<PropertyDefinition> getOmitFields() {
        return this.omitFields;
    }

    public void setOmitFields(List<PropertyDefinition> omitFields) {
        this.omitFields = omitFields;
    }

    public void setOmitFields(Map<String, String> aliases) {
        this.omitFields = new ArrayList<PropertyDefinition>();
        aliases.forEach((k, v) -> this.omitFields.add(new PropertyDefinition((String)k, (String)v)));
    }

    public Map<String, String> getOmitFieldsAsMap() {
        if (this.omitFields == null || this.omitFields.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (PropertyDefinition def : this.omitFields) {
            answer.put(def.getKey(), def.getValue());
        }
        return answer;
    }

    public List<PropertyDefinition> getImplicitCollections() {
        return this.implicitCollections;
    }

    public void setImplicitCollections(List<PropertyDefinition> implicitCollections) {
        this.implicitCollections = implicitCollections;
    }

    public void setImplicitCollections(Map<String, String> implicitCollections) {
        this.implicitCollections = new ArrayList<PropertyDefinition>();
        implicitCollections.forEach((k, v) -> this.implicitCollections.add(new PropertyDefinition((String)k, (String)v)));
    }

    public Map<String, String> getImplicitCollectionsAsMap() {
        if (this.implicitCollections == null || this.implicitCollections.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (PropertyDefinition def : this.implicitCollections) {
            answer.put(def.getKey(), def.getValue());
        }
        return answer;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setPermissions(Class<?> ... type) {
        CollectionStringBuffer csb = new CollectionStringBuffer(",");
        for (Class<?> clazz : type) {
            csb.append((Object)"+");
            csb.append((Object)clazz.getName());
        }
        this.setPermissions(csb.toString());
    }
}

