/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.FaultToleranceConfigurationProperties;
import org.apache.camel.main.HealthCheckConfigurationProperties;
import org.apache.camel.main.HealthConfigurationProperties;
import org.apache.camel.main.HystrixConfigurationProperties;
import org.apache.camel.main.Main;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainHelper;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.PropertiesRouteTemplateParametersSource;
import org.apache.camel.main.Resilience4jConfigurationProperties;
import org.apache.camel.main.RestConfigurationProperties;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.main.ThreadPoolConfigurationProperties;
import org.apache.camel.main.ThreadPoolProfileConfigurationProperties;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMainSupport
extends BaseService {
    public static final String DEFAULT_PROPERTY_PLACEHOLDER_LOCATION = "classpath:application.properties;optional=true";
    public static final String INITIAL_PROPERTIES_LOCATION = "camel.main.initial-properties-location";
    public static final String OVERRIDE_PROPERTIES_LOCATION = "camel.main.override-properties-location";
    public static final String PROPERTY_PLACEHOLDER_LOCATION = "camel.main.property-placeholder-location";
    private static final Logger LOG = LoggerFactory.getLogger(BaseMainSupport.class);
    private static final String SENSITIVE_KEYS = "passphrase|password|secretkey|accesstoken|clientsecret|authorizationtoken|sasljaasconfig";
    protected volatile CamelContext camelContext;
    protected volatile ProducerTemplate camelTemplate;
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected final MainConfigurationProperties mainConfigurationProperties = new MainConfigurationProperties();
    protected final Properties wildcardProperties = new OrderedProperties();
    protected RoutesCollector routesCollector = new DefaultRoutesCollector();
    protected String propertyPlaceholderLocations;
    protected String defaultPropertyPlaceholderLocation = "classpath:application.properties;optional=true";
    protected Properties initialProperties;
    protected Properties overrideProperties;

    protected static String optionKey(String key) {
        key = StringHelper.dashToCamelCase((String)key);
        return key;
    }

    protected static boolean setPropertiesOnTarget(CamelContext context, Object target, Object source) throws Exception {
        org.apache.camel.util.ObjectHelper.notNull((Object)context, (String)"context");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        boolean rc = false;
        PropertyConfigurer targetConfigurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService((Object)target);
            targetConfigurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (targetConfigurer == null) {
            String name = target.getClass().getName();
            if (target instanceof ExtendedCamelContext) {
                name = ExtendedCamelContext.class.getName();
            }
            targetConfigurer = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(name, context);
        }
        PropertyConfigurer sourceConfigurer = null;
        if (source instanceof Component) {
            ServiceHelper.initService((Object)source);
            sourceConfigurer = ((Component)source).getComponentPropertyConfigurer();
        }
        if (sourceConfigurer == null) {
            String name = source.getClass().getName();
            if (source instanceof ExtendedCamelContext) {
                name = ExtendedCamelContext.class.getName();
            }
            sourceConfigurer = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(name, context);
        }
        if (targetConfigurer != null && sourceConfigurer instanceof PropertyConfigurerGetter) {
            PropertyConfigurerGetter getter = (PropertyConfigurerGetter)sourceConfigurer;
            for (String key : getter.getAllOptions(source).keySet()) {
                Object value = getter.getOptionValue(source, key, true);
                if (value == null) continue;
                rc |= targetConfigurer.configure(context, target, key, value, true);
            }
        }
        return rc;
    }

    protected static boolean setPropertiesOnTarget(CamelContext context, Object target, Map<String, Object> properties, String optionPrefix, boolean failIfNotSet, boolean ignoreCase, Map<String, String> autoConfiguredProperties) throws Exception {
        org.apache.camel.util.ObjectHelper.notNull((Object)context, (String)"context");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService((Object)target);
            configurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            String name = target.getClass().getName();
            if (target instanceof ExtendedCamelContext) {
                name = ExtendedCamelContext.class.getName();
            }
            configurer = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(name, context);
        }
        try {
            LinkedHashMap<String, Object> backup = new LinkedHashMap<String, Object>(properties);
            rc = PropertyBindingSupport.build().withMandatory(failIfNotSet).withRemoveParameters(true).withConfigurer(configurer).withIgnoreCase(ignoreCase).bind(context, target, properties);
            for (Map.Entry entry : backup.entrySet()) {
                if (entry.getValue() == null || properties.containsKey(entry.getKey())) continue;
                String prefix = optionPrefix;
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = "." + prefix;
                }
                LOG.debug("Configured property: {}{}={} on bean: {}", new Object[]{prefix, entry.getKey(), entry.getValue(), target});
                autoConfiguredProperties.put(prefix + (String)entry.getKey(), entry.getValue().toString());
            }
        }
        catch (PropertyBindingException e) {
            String key = e.getOptionKey();
            if (key == null) {
                String prefix = e.getOptionPrefix();
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = "." + prefix;
                }
                String string = key = prefix != null ? prefix + "." + e.getPropertyName() : e.getPropertyName();
            }
            if (failIfNotSet) {
                throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), optionPrefix, key, e.getCause());
            }
            LOG.debug("Error configuring property (" + key + ") with name: " + e.getPropertyName() + ") on bean: " + target + " with value: " + e.getValue() + ". This exception is ignored as failIfNotSet=false.", (Throwable)e);
        }
        return rc;
    }

    public MainConfigurationProperties configure() {
        return this.mainConfigurationProperties;
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    public String getDefaultPropertyPlaceholderLocation() {
        return this.defaultPropertyPlaceholderLocation;
    }

    public void setDefaultPropertyPlaceholderLocation(String defaultPropertyPlaceholderLocation) {
        this.defaultPropertyPlaceholderLocation = defaultPropertyPlaceholderLocation;
    }

    @Deprecated
    public boolean isAutoConfigurationEnabled() {
        return this.mainConfigurationProperties.isAutoConfigurationEnabled();
    }

    @Deprecated
    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.mainConfigurationProperties.setAutoConfigurationEnabled(autoConfigurationEnabled);
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public void addProperty(String key, String value) {
        this.addInitialProperty(key, value);
    }

    public void addInitialProperty(String key, String value) {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        this.initialProperties.setProperty(key, value);
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public void addOverrideProperty(String key, String value) {
        if (this.overrideProperties == null) {
            this.overrideProperties = new OrderedProperties();
        }
        this.overrideProperties.setProperty(key, value);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void addMainListener(MainListener listener) {
        this.listeners.add(listener);
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    public List<RouteDefinition> getRouteDefinitions() {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        if (this.camelContext != null) {
            answer.addAll(((Model)this.camelContext.getExtension(Model.class)).getRouteDefinitions());
        }
        return answer;
    }

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected abstract ProducerTemplate findOrCreateCamelTemplate();

    protected abstract CamelContext createCamelContext();

    protected void initCamelContext() throws Exception {
        this.camelContext = this.createCamelContext();
        if (this.camelContext == null) {
            throw new IllegalStateException("Created CamelContext is null");
        }
        this.postProcessCamelContext(this.camelContext);
    }

    protected void loadRouteBuilders(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (RoutesBuilder routesBuilder : this.mainConfigurationProperties.getRoutesBuilders()) {
            postProcessor.postProcessBeforeInitialization((Object)routesBuilder, routesBuilder.getClass().getName());
            postProcessor.postProcessAfterInitialization((Object)routesBuilder, routesBuilder.getClass().getName());
        }
        if (this.mainConfigurationProperties.getRoutesBuilderClasses() != null) {
            String[] routeClasses;
            for (String routeClass : routeClasses = this.mainConfigurationProperties.getRoutesBuilderClasses().split(",")) {
                Class routeClazz = camelContext.getClassResolver().resolveClass(routeClass, RoutesBuilder.class);
                if (routeClazz == null) {
                    LOG.warn("Unable to resolve class: {}", (Object)routeClass);
                    continue;
                }
                RoutesBuilder builder = (RoutesBuilder)camelContext.getInjector().newInstance(routeClazz);
                this.mainConfigurationProperties.addRoutesBuilder(builder);
            }
        }
        if (this.mainConfigurationProperties.getPackageScanRouteBuilders() != null) {
            String[] pkgs = this.mainConfigurationProperties.getPackageScanRouteBuilders().split(",");
            Set set = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPackageScanClassResolver().findImplementations(RoutesBuilder.class, pkgs);
            for (Class routeClazz : set) {
                Object builder = camelContext.getInjector().newInstance(routeClazz);
                if (builder instanceof RoutesBuilder) {
                    this.mainConfigurationProperties.addRoutesBuilder((RoutesBuilder)builder);
                    continue;
                }
                LOG.warn("Class {} is not a RouteBuilder class", (Object)routeClazz);
            }
        }
    }

    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (Object object : this.mainConfigurationProperties.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(object, object.getClass().getName());
            postProcessor.postProcessAfterInitialization(object, object.getClass().getName());
        }
        if (this.mainConfigurationProperties.getConfigurationClasses() != null) {
            String[] configClasses;
            for (String configClass : configClasses = this.mainConfigurationProperties.getConfigurationClasses().split(",")) {
                Class configClazz = camelContext.getClassResolver().resolveClass(configClass);
                Object config = camelContext.getInjector().newInstance(configClazz);
                this.mainConfigurationProperties.addConfiguration(config);
            }
        }
        for (Object object : this.mainConfigurationProperties.getConfigurations()) {
            Method method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[0]);
            if (method != null) {
                LOG.info("Calling configure method on configuration class: {}", (Object)object.getClass().getName());
                ObjectHelper.invokeMethod((Method)method, (Object)object, (Object[])new Object[0]);
                continue;
            }
            Object arg = camelContext;
            method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[]{CamelContext.class});
            if (method == null) {
                method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[]{Main.class});
                arg = this;
            }
            if (method == null) continue;
            LOG.info("Calling configure method on configuration class: {}", (Object)object.getClass().getName());
            ObjectHelper.invokeMethod((Method)method, (Object)object, (Object[])new Object[]{arg});
        }
    }

    protected void configurePropertiesService(CamelContext camelContext) throws Exception {
        Optional<String> location;
        Properties op;
        Optional<String> location2;
        Properties ip;
        PropertiesComponent pc = camelContext.getPropertiesComponent();
        if (pc.getLocations().isEmpty()) {
            String locations = this.propertyPlaceholderLocations;
            if (locations == null) {
                locations = MainHelper.lookupPropertyFromSysOrEnv(PROPERTY_PLACEHOLDER_LOCATION).orElse(this.defaultPropertyPlaceholderLocation);
            }
            if (!Objects.equals(locations, "false")) {
                pc.addLocation(locations);
                LOG.info("Using properties from: {}", (Object)locations);
            }
        }
        if (((ip = this.initialProperties) == null || ip.isEmpty()) && (location2 = MainHelper.lookupPropertyFromSysOrEnv(INITIAL_PROPERTIES_LOCATION)).isPresent()) {
            try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)location2.get());){
                ip = new Properties();
                ip.load(is);
            }
        }
        if (ip != null) {
            pc.setInitialProperties(ip);
        }
        if (((op = this.overrideProperties) == null || op.isEmpty()) && (location = MainHelper.lookupPropertyFromSysOrEnv(OVERRIDE_PROPERTIES_LOCATION)).isPresent()) {
            try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)location.get());){
                op = new Properties();
                op.load(is);
            }
        }
        if (op != null) {
            pc.setOverrideProperties(op);
        }
    }

    protected void configureLifecycle(CamelContext camelContext) throws Exception {
    }

    protected void autoconfigure(CamelContext camelContext) throws Exception {
        LinkedHashMap<String, String> autoConfiguredProperties = new LinkedHashMap<String, String>();
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFailFast(camelContext, autoConfiguredProperties);
            this.autoConfigurationPropertiesComponent(camelContext, autoConfiguredProperties);
            this.autoConfigurationMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        }
        this.doConfigureCamelContextFromMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        this.loadConfigurations(camelContext);
        if (this.mainConfigurationProperties.isAutowireComponentProperties() || this.mainConfigurationProperties.isAutowireComponentPropertiesDeep()) {
            this.autowireConfigurationFromRegistry(camelContext, this.mainConfigurationProperties.isAutowireComponentPropertiesNonNullOnly(), this.mainConfigurationProperties.isAutowireComponentPropertiesDeep());
        }
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFromProperties(camelContext, autoConfiguredProperties);
        }
        if (this.mainConfigurationProperties.isAutowireComponentProperties() || this.mainConfigurationProperties.isAutowireComponentPropertiesDeep()) {
            this.autowireWildcardProperties(camelContext);
        }
        if (camelContext.isTracing().booleanValue() && !this.mainConfigurationProperties.isTracing()) {
            camelContext.setTracing(Boolean.FALSE);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            LOG.info("Auto-configuration summary:");
            autoConfiguredProperties.forEach((k, v) -> {
                boolean sensitive = SENSITIVE_KEYS.contains(k.toLowerCase(Locale.ENGLISH));
                if (sensitive) {
                    LOG.info("\t{}=xxxxxx", k);
                } else {
                    LOG.info("\t{}={}", k, v);
                }
            });
        }
    }

    protected void configureRoutes(CamelContext camelContext) throws Exception {
        this.loadRouteBuilders(camelContext);
        RoutesConfigurer configurer = new RoutesConfigurer(this.routesCollector, this.mainConfigurationProperties.getRoutesBuilders());
        configurer.configureRoutes(camelContext, this.mainConfigurationProperties);
        for (Object config : this.mainConfigurationProperties.getConfigurations()) {
            Method method = ReflectionHelper.findMethod(config.getClass(), (String)"configureRouteTemplates", (Class[])new Class[0]);
            if (method != null) {
                LOG.info("Calling configureRouteTemplates method on configuration class: {}", (Object)config.getClass().getName());
                ObjectHelper.invokeMethod((Method)method, (Object)config, (Object[])new Object[0]);
                continue;
            }
            Object arg = camelContext;
            method = ReflectionHelper.findMethod(config.getClass(), (String)"configureRouteTemplates", (Class[])new Class[]{CamelContext.class});
            if (method == null) {
                method = ReflectionHelper.findMethod(config.getClass(), (String)"configureRouteTemplates", (Class[])new Class[]{Main.class});
                arg = this;
            }
            if (method == null) continue;
            LOG.info("Calling configureRouteTemplates method on configuration class: {}", (Object)config.getClass().getName());
            ObjectHelper.invokeMethod((Method)method, (Object)config, (Object[])new Object[]{arg});
        }
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        camelContext.build();
        for (MainListener listener : this.listeners) {
            listener.beforeInitialize(this);
        }
        this.configurePropertiesService(camelContext);
        for (MainListener listener : this.listeners) {
            listener.beforeConfigure(this);
        }
        this.autoconfigure(camelContext);
        this.configureLifecycle(camelContext);
        this.configureRoutes(camelContext);
        for (MainListener listener : this.listeners) {
            listener.afterConfigure(this);
            listener.configure(camelContext);
        }
    }

    protected void autoConfigurationFailFast(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Object failFast;
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        LOG.debug("Properties from Camel properties component:");
        for (String key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", (Object)key, (Object)prop.getProperty(key));
        }
        Object envEnabled = prop.remove("camel.main.autoConfigurationEnvironmentVariablesEnabled");
        if (envEnabled == null && (envEnabled = prop.remove("camel.main.auto-configuration-environment-variables-enabled")) != null) {
            PropertyBindingSupport.build().withMandatory(true).withIgnoreCase(true).bind(camelContext, (Object)this.mainConfigurationProperties, "autoConfigurationEnvironmentVariablesEnabled", envEnabled);
            autoConfiguredProperties.put("camel.main.auto-configuration-environment-variables-enabled", envEnabled.toString());
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        Object object = failFast = propENV != null ? propENV.remove("camel.main.autoconfigurationfailfast") : null;
        if (failFast != null) {
            PropertyBindingSupport.build().withMandatory(true).withIgnoreCase(true).bind(camelContext, (Object)this.mainConfigurationProperties, "autoConfigurationFailFast", failFast);
        } else {
            failFast = prop.remove("camel.main.autoConfigurationFailFast");
            if (failFast == null) {
                failFast = prop.remove("camel.main.auto-configuration-fail-fast");
            }
            if (failFast != null) {
                PropertyBindingSupport.build().withMandatory(true).withIgnoreCase(true).bind(camelContext, (Object)this.mainConfigurationProperties, "autoConfigurationFailFast", failFast);
                autoConfiguredProperties.put("camel.main.auto-configuration-fail-fast", failFast.toString());
            }
        }
    }

    protected void doConfigureCamelContextFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, Map<String, String> autoConfiguredProperties) throws Exception {
        FaultToleranceConfigurationDefinition faultToleranceModel;
        Resilience4jConfigurationDefinition resilience4jModel;
        HystrixConfigurationDefinition hystrixModel;
        Properties propENV;
        if (config.getFileConfigurations() != null) {
            String[] locs;
            for (String loc : locs = config.getFileConfigurations().split(",")) {
                String pattern;
                File[] files;
                String path = FileUtil.onlyPath((String)loc);
                if (path == null || (files = new File(path).listFiles(arg_0 -> BaseMainSupport.lambda$doConfigureCamelContextFromMainConfiguration$2(pattern = loc.length() > path.length() ? loc.substring(path.length() + 1) : null, arg_0))) == null) continue;
                for (File file : files) {
                    Properties props = new Properties();
                    try (FileInputStream is = new FileInputStream(file);){
                        props.load(is);
                    }
                    if (props.isEmpty()) continue;
                    if (this.overrideProperties == null) {
                        this.overrideProperties = new Properties();
                        PropertiesComponent pc = camelContext.getPropertiesComponent();
                        pc.setOverrideProperties(this.overrideProperties);
                    }
                    LOG.info("Loaded additional {} properties from file: {}", (Object)props.size(), (Object)file);
                    this.overrideProperties.putAll((Map<?, ?>)props);
                }
            }
        }
        DefaultConfigurationConfigurer.configure(camelContext, config);
        DefaultConfigurationConfigurer.afterConfigure(camelContext);
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        LinkedHashMap<String, Object> contextProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> hystrixProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> resilience4jProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> faultToleranceProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> restProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> threadPoolProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> healthProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> lraProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> routeTemplateProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> beansProperties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            String option;
            String value;
            if (key.startsWith("camel.context.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                contextProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.hystrix.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                hystrixProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.resilience4j.")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                resilience4jProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.faulttolerance.")) {
                value = prop.getProperty(key);
                option = key.substring(21);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                faultToleranceProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.rest.")) {
                value = prop.getProperty(key);
                option = key.substring(11);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                restProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.threadpool.")) {
                value = prop.getProperty(key);
                option = key.substring(17);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                threadPoolProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.health.")) {
                value = prop.getProperty(key);
                option = key.substring(13);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                healthProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.lra.")) {
                value = prop.getProperty(key);
                option = key.substring(10);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                lraProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.route-template")) {
                value = prop.getProperty(key);
                option = key.substring(20);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                routeTemplateProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (!key.startsWith("camel.beans.")) continue;
            value = prop.getProperty(key);
            option = key.substring(12);
            BaseMainSupport.validateOptionAndValue(key, option, value);
            beansProperties.put(BaseMainSupport.optionKey(option), value);
        }
        ModelCamelContext model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
        if (!beansProperties.isEmpty()) {
            LOG.debug("Creating and binding beans to registry from loaded properties: {}", (Object)beansProperties.size());
            this.bindBeansToRegistry(camelContext, beansProperties, "camel.beans.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!contextProperties.isEmpty()) {
            LOG.debug("Auto-configuring CamelContext from loaded properties: {}", (Object)contextProperties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, camelContext, contextProperties, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        HystrixConfigurationProperties hystrix = this.mainConfigurationProperties.hystrix();
        if (!hystrixProperties.isEmpty()) {
            LOG.debug("Auto-configuring Hystrix Circuit Breaker EIP from loaded properties: {}", (Object)hystrixProperties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, hystrix, hystrixProperties, "camel.hystrix.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if ((hystrixModel = model.getHystrixConfiguration(null)) == null) {
            hystrixModel = new HystrixConfigurationDefinition();
            model.setHystrixConfiguration(hystrixModel);
        }
        BaseMainSupport.setPropertiesOnTarget(camelContext, hystrixModel, hystrix);
        Resilience4jConfigurationProperties resilience4j = this.mainConfigurationProperties.resilience4j();
        if (!resilience4jProperties.isEmpty()) {
            LOG.debug("Auto-configuring Resilience4j Circuit Breaker EIP from loaded properties: {}", (Object)resilience4jProperties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, resilience4j, resilience4jProperties, "camel.resilience4j.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if ((resilience4jModel = model.getResilience4jConfiguration(null)) == null) {
            resilience4jModel = new Resilience4jConfigurationDefinition();
            model.setResilience4jConfiguration(resilience4jModel);
        }
        BaseMainSupport.setPropertiesOnTarget(camelContext, resilience4jModel, resilience4j);
        FaultToleranceConfigurationProperties faultTolerance = this.mainConfigurationProperties.faultTolerance();
        if (!faultToleranceProperties.isEmpty()) {
            LOG.debug("Auto-configuring MicroProfile Fault Tolerance Circuit Breaker EIP from loaded properties: {}", (Object)faultToleranceProperties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, faultTolerance, faultToleranceProperties, "camel.faulttolerance.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if ((faultToleranceModel = model.getFaultToleranceConfiguration(null)) == null) {
            faultToleranceModel = new FaultToleranceConfigurationDefinition();
            model.setFaultToleranceConfiguration(faultToleranceModel);
        }
        BaseMainSupport.setPropertiesOnTarget(camelContext, faultToleranceModel, faultTolerance);
        RestConfigurationProperties rest = this.mainConfigurationProperties.rest();
        if (!restProperties.isEmpty()) {
            LOG.debug("Auto-configuring Rest DSL from loaded properties: {}", (Object)restProperties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, (Object)rest, restProperties, "camel.rest.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        camelContext.setRestConfiguration((RestConfiguration)rest);
        if (!threadPoolProperties.isEmpty()) {
            LOG.debug("Auto-configuring Thread Pool from loaded properties: {}", (Object)threadPoolProperties.size());
            this.setThreadPoolProperties(camelContext, threadPoolProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!healthProperties.isEmpty()) {
            LOG.debug("Auto-configuring HealthCheck from loaded properties: {}", (Object)healthProperties.size());
            this.setHealthCheckProperties(camelContext, healthProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!routeTemplateProperties.isEmpty()) {
            LOG.debug("Auto-configuring Route templates from loaded properties: {}", (Object)routeTemplateProperties.size());
            this.setRouteTemplateProperties(camelContext, routeTemplateProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!lraProperties.isEmpty()) {
            LOG.debug("Auto-configuring Saga LRA from loaded properties: {}", (Object)lraProperties.size());
            this.setLraCheckProperties(camelContext, lraProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!beansProperties.isEmpty()) {
            beansProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.beans.{}={}", k, v));
        }
        if (!contextProperties.isEmpty()) {
            contextProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.context.{}={} on bean: {}", new Object[]{k, v, camelContext}));
        }
        if (!hystrixProperties.isEmpty()) {
            hystrixProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.hystrix.{}={} on bean: {}", new Object[]{k, v, hystrix}));
        }
        if (!resilience4jProperties.isEmpty()) {
            resilience4jProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.resilience4j.{}={} on bean: {}", new Object[]{k, v, resilience4j}));
        }
        if (!faultToleranceProperties.isEmpty()) {
            faultToleranceProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.faulttolerance.{}={} on bean: {}", new Object[]{k, v, faultTolerance}));
        }
        if (!restProperties.isEmpty()) {
            restProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.rest.{}={} on bean: {}", new Object[]{k, v, rest}));
        }
        if (!threadPoolProperties.isEmpty()) {
            threadPoolProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.threadpool.{}={}", k, v));
        }
        if (!healthProperties.isEmpty()) {
            healthProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.health.{}={}", k, v));
        }
        if (!routeTemplateProperties.isEmpty()) {
            routeTemplateProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.routetemplate.{}={}", k, v));
        }
        if (!lraProperties.isEmpty()) {
            lraProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.lra.{}={}", k, v));
        }
        DefaultConfigurationConfigurer.afterPropertiesSet(camelContext);
    }

    private void setThreadPoolProperties(CamelContext camelContext, Map<String, Object> threadPoolProperties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        ThreadPoolConfigurationProperties tp = this.mainConfigurationProperties.threadPool();
        Map hcConfig = PropertiesHelper.extractProperties(threadPoolProperties, (String)"config", (boolean)false);
        HashMap<String, ThreadPoolProfileConfigurationProperties> tpConfigs = new HashMap<String, ThreadPoolProfileConfigurationProperties>();
        for (Map.Entry entry : hcConfig.entrySet()) {
            ThreadPoolProfileConfigurationProperties tcp;
            String id = StringHelper.between((String)((String)entry.getKey()), (String)"[", (String)"]");
            if (id == null || (tcp = (ThreadPoolProfileConfigurationProperties)tpConfigs.get(id)) != null) continue;
            tcp = new ThreadPoolProfileConfigurationProperties();
            tcp.setId(id);
            tpConfigs.put(id, tcp);
        }
        if (tp.getConfig() != null) {
            tp.getConfig().putAll(tpConfigs);
        } else {
            tp.setConfig(tpConfigs);
        }
        BaseMainSupport.setPropertiesOnTarget(camelContext, tp, threadPoolProperties, "camel.threadpool.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        ThreadPoolProfile dp = new ThreadPoolProfileBuilder("default").poolSize(tp.getPoolSize()).maxPoolSize(tp.getMaxPoolSize()).keepAliveTime(tp.getKeepAliveTime(), tp.getTimeUnit()).maxQueueSize(tp.getMaxQueueSize()).allowCoreThreadTimeOut(tp.getAllowCoreThreadTimeOut()).rejectedPolicy(tp.getRejectedPolicy()).build();
        for (ThreadPoolProfileConfigurationProperties config : tp.getConfig().values()) {
            ThreadPoolProfileBuilder builder = new ThreadPoolProfileBuilder(config.getId(), dp);
            ThreadPoolProfile tpp = builder.poolSize(config.getPoolSize()).maxPoolSize(config.getMaxPoolSize()).keepAliveTime(config.getKeepAliveTime(), config.getTimeUnit()).maxQueueSize(config.getMaxQueueSize()).allowCoreThreadTimeOut(config.getAllowCoreThreadTimeOut()).rejectedPolicy(config.getRejectedPolicy()).build();
            if (tpp.isEmpty()) continue;
            camelContext.getExecutorServiceManager().registerThreadPoolProfile(tpp);
        }
        if (!dp.isEmpty()) {
            dp.setDefaultProfile(Boolean.valueOf(true));
            camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(dp);
        }
    }

    private void setRouteTemplateProperties(CamelContext camelContext, Map<String, Object> routeTemplateProperties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        PropertiesRouteTemplateParametersSource source = new PropertiesRouteTemplateParametersSource();
        for (Map.Entry<String, Object> entry : routeTemplateProperties.entrySet()) {
            String id = StringHelper.between((String)entry.getKey(), (String)"[", (String)"]");
            String key = StringHelper.after((String)entry.getKey(), (String)"].");
            source.addParameter(id, key, entry.getValue());
        }
        camelContext.getRegistry().bind("CamelMainRouteTemplateParametersSource", RouteTemplateParameterSource.class, (Object)source);
        TreeMap<String, Object> sorted = new TreeMap<String, Object>(routeTemplateProperties);
        sorted.forEach((k, v) -> autoConfiguredProperties.put("camel.route-template" + k, v.toString()));
        routeTemplateProperties.clear();
    }

    private void setHealthCheckProperties(CamelContext camelContext, Map<String, Object> healthCheckProperties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        HealthCheck hc;
        HealthCheckRegistry hcr = (HealthCheckRegistry)camelContext.getExtension(HealthCheckRegistry.class);
        if (hcr == null) {
            LOG.warn("Cannot find HealthCheckRegistry from classpath. Add camel-health to classpath.");
            return;
        }
        HealthConfigurationProperties health = this.mainConfigurationProperties.health();
        Map hcConfig = PropertiesHelper.extractProperties(healthCheckProperties, (String)"config", (boolean)false);
        HashMap<String, HealthCheckConfigurationProperties> hcConfigs = new HashMap<String, HealthCheckConfigurationProperties>();
        for (Map.Entry entry : hcConfig.entrySet()) {
            HealthCheckConfigurationProperties hcp;
            String parent = StringHelper.between((String)((String)entry.getKey()), (String)"[", (String)"]");
            if (parent == null || (hcp = (HealthCheckConfigurationProperties)((Object)hcConfigs.get(parent))) != null) continue;
            hcp = new HealthCheckConfigurationProperties();
            hcConfigs.put(parent, hcp);
        }
        if (health.getConfig() != null) {
            health.getConfig().putAll(hcConfigs);
        } else {
            health.setConfig(hcConfigs);
        }
        BaseMainSupport.setPropertiesOnTarget(camelContext, health, healthCheckProperties, "camel.health.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        if (health.getEnabled() != null) {
            hcr.setEnabled(health.getEnabled().booleanValue());
        }
        if (hcr.isEnabled() && (!health.getConfig().containsKey("context") || health.getContextEnabled() != null) && (hc = (HealthCheck)hcr.resolveById("context")) != null) {
            if (health.getContextEnabled() != null) {
                hc.getConfiguration().setEnabled(health.getContextEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (!health.getConfig().containsKey("routes") || health.getRoutesEnabled() != null) && (hc = hcr.getRepository("routes").orElse((HealthCheckRepository)hcr.resolveById("routes"))) != null) {
            if (health.getRoutesEnabled() != null) {
                hc.setEnabled(health.getRoutesEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (!health.getConfig().containsKey("registry") || health.getRegistryEnabled() != null)) {
            hcr.getRepository("registry").ifPresent(h -> {
                if (health.getRegistryEnabled() != null) {
                    h.setEnabled(health.getRegistryEnabled().booleanValue());
                }
            });
        }
        for (String id : health.getConfig().keySet()) {
            HealthCheckConfiguration hcc = health.getConfig().get(id);
            String parent = hcc.getParent();
            Object hc2 = hcr.getCheck(parent).orElse(null);
            if (hc2 != null) continue;
            hc2 = hcr.resolveById(parent);
            if (hc2 == null) {
                LOG.warn("Cannot resolve HealthCheck with id: " + parent + " from classpath.");
                continue;
            }
            hcr.register(hc2);
            if (hc2 instanceof HealthCheck) {
                ((HealthCheck)hc2).getConfiguration().setParent(hcc.getParent());
                ((HealthCheck)hc2).getConfiguration().setEnabled(hcc.isEnabled());
                ((HealthCheck)hc2).getConfiguration().setFailureThreshold(hcc.getFailureThreshold());
                ((HealthCheck)hc2).getConfiguration().setInterval(hcc.getInterval());
                continue;
            }
            if (!(hc2 instanceof HealthCheckRepository)) continue;
            ((HealthCheckRepository)hc2).setEnabled(hcc.isEnabled());
            ((HealthCheckRepository)hc2).addConfiguration(id, hcc);
        }
    }

    private void setLraCheckProperties(CamelContext camelContext, Map<String, Object> lraProperties, boolean failIfNotSet, Map<String, String> autoConfiguredProperties) throws Exception {
        boolean enabled;
        Object obj = lraProperties.get("enabled");
        if (obj != null) {
            autoConfiguredProperties.put("camel.lra.enabled", obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)obj.toString()) : true;
        if (enabled) {
            CamelSagaService css = BaseMainSupport.resolveLraSagaService(camelContext);
            BaseMainSupport.setPropertiesOnTarget(camelContext, css, lraProperties, "camel.lra.", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private static CamelSagaService resolveLraSagaService(CamelContext camelContext) throws Exception {
        Set set = camelContext.getRegistry().findByType(CamelSagaService.class);
        if (set.size() == 1) {
            return (CamelSagaService)set.iterator().next();
        }
        CamelSagaService answer = (CamelSagaService)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getDefaultFactoryFinder().newInstance("lra-saga-service", CamelSagaService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find LRASagaService on classpath. Add camel-lra to classpath."));
        camelContext.addService((Object)answer, true, false);
        return answer;
    }

    private void bindBeansToRegistry(CamelContext camelContext, Map<String, Object> properties, String optionPrefix, boolean failIfNotSet, boolean ignoreCase, Map<String, String> autoConfiguredProperties) throws Exception {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(properties.keySet());
        for (String key : keys) {
            if (key.indexOf(46) != -1) continue;
            String name = key;
            Object value = properties.remove(key);
            Object bean = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (String)name, (Object)value);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot create/resolve bean with name " + name + " from value: " + value);
            }
            camelContext.getRegistry().bind(name, bean);
            autoConfiguredProperties.put(optionPrefix + key, value.toString());
            Map config = PropertiesHelper.extractProperties(properties, (String)(key + "."));
            BaseMainSupport.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + key + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
            LOG.info("Binding bean: {} (type: {}) to the registry", (Object)key, (Object)org.apache.camel.util.ObjectHelper.classCanonicalName((Object)bean));
        }
    }

    protected void autoConfigurationPropertiesComponent(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propENV;
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.component.properties.")) continue;
            int dot = key.indexOf(46, 26);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            BaseMainSupport.validateOptionAndValue(key, option, value);
            properties.put(BaseMainSupport.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring properties component from loaded properties: {}", (Object)properties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, camelContext.getPropertiesComponent(), properties, "camel.component.properties.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.component.properties.{}={} on object: {}", new Object[]{k, v, camelContext.getPropertiesComponent()}));
        }
    }

    protected void autoConfigurationMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Properties propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."});
            propENV.remove(INITIAL_PROPERTIES_LOCATION.replace('-', '.'));
            propENV.remove(OVERRIDE_PROPERTIES_LOCATION.replace('-', '.'));
            propENV.remove(PROPERTY_PLACEHOLDER_LOCATION.replace('-', '.'));
            if (!propENV.isEmpty()) {
                prop.putAll((Map<?, ?>)propENV);
            }
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.main.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(11);
            BaseMainSupport.validateOptionAndValue(key, option, value);
            properties.put(BaseMainSupport.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring main from loaded properties: {}", (Object)properties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, config, properties, "camel.main.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.main.{}={} on bean: {}", new Object[]{k, v, config}));
        }
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propENV;
        OrderedProperties prop = new OrderedProperties();
        try {
            InputStream is = camelContext.getClassResolver().loadResourceAsStream("/META-INF/services/org/apache/camel/autowire.properties");
            if (is != null) {
                prop.load(is);
                if (!prop.isEmpty()) {
                    LOG.info("Autowired enabled from classpath: META-INF/services/org/apache/camel/autowire.properties with {} properties", (Object)prop.size());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Properties from classpath: META-INF/services/org/apache/camel/autowire.properties:");
                        for (String string : prop.stringPropertyNames()) {
                            LOG.debug("    {}={}", (Object)string, (Object)prop.getProperty(string));
                        }
                    }
                }
                IOHelper.close((Closeable)is);
            }
        }
        catch (Throwable is) {
            // empty catch block
        }
        Properties propPC = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        prop.putAll((Map<?, ?>)propPC);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.", "camel.dataformat.", "camel.language."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
        }
        LinkedHashMap<PropertyOptionKey, Map<String, Object>> properties = new LinkedHashMap<PropertyOptionKey, Map<String, Object>>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.contains("*")) continue;
            this.wildcardProperties.put(key, prop.getProperty(key));
        }
        for (String key : this.wildcardProperties.stringPropertyNames()) {
            prop.remove(key);
        }
        for (String key : prop.stringPropertyNames()) {
            BaseMainSupport.computeProperties("camel.component.", key, (Properties)prop, properties, name -> {
                Component target = camelContext.getComponent(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find component with name " + name + ". Make sure you have the component on the classpath");
                }
                return Collections.singleton(target);
            });
            BaseMainSupport.computeProperties("camel.dataformat.", key, (Properties)prop, properties, name -> {
                DataFormat target = camelContext.resolveDataFormat(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find dataformat with name " + name + ". Make sure you have the dataformat on the classpath");
                }
                return Collections.singleton(target);
            });
            BaseMainSupport.computeProperties("camel.language.", key, (Properties)prop, properties, name -> {
                Language target;
                try {
                    target = camelContext.resolveLanguage(name);
                }
                catch (NoSuchLanguageException e) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find language with name " + name + ". Make sure you have the language on the classpath");
                }
                return Collections.singleton(target);
            });
        }
        if (!properties.isEmpty()) {
            long l = properties.values().stream().mapToLong(Map::size).sum();
            LOG.debug("Auto-configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)l);
        }
        for (Map.Entry entry : properties.entrySet()) {
            BaseMainSupport.setPropertiesOnTarget(camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (Map)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            for (PropertyOptionKey pok : properties.keySet()) {
                Map values = (Map)properties.get(pok);
                values.forEach((k, v) -> {
                    String stringValue = v != null ? v.toString() : null;
                    LOG.warn("Property ({}={}) not auto-configured with name: {} on bean: {} with value: {}", new Object[]{pok.getOptionPrefix() + "." + k, stringValue, k, pok.getInstance(), stringValue});
                });
            }
        }
    }

    protected void autowireConfigurationFromRegistry(final CamelContext camelContext, final boolean bindNullOnly, final boolean deepNesting) throws Exception {
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                PropertyBindingSupport.autowireSingletonPropertiesFromRegistry((CamelContext)camelContext, (Object)component, (boolean)bindNullOnly, (boolean)deepNesting, (obj, propertyName, type, value) -> LOG.info("Autowired property: {} on component: {} as exactly one instance of type: {} found in the registry", new Object[]{propertyName, component.getClass().getSimpleName(), type.getName()}));
            }
        });
    }

    protected void autowireWildcardProperties(CamelContext camelContext) {
        if (this.wildcardProperties.isEmpty()) {
            return;
        }
        for (String name : camelContext.getComponentNames()) {
            Component comp = camelContext.getComponent(name);
            this.doAutowireWildcardProperties(name, comp);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                BaseMainSupport.this.doAutowireWildcardProperties(name, component);
            }
        });
    }

    protected void doAutowireWildcardProperties(String name, Component component) {
        LinkedHashMap<PropertyOptionKey, Map<String, Object>> properties = new LinkedHashMap<PropertyOptionKey, Map<String, Object>>();
        LinkedHashMap<String, String> autoConfiguredProperties = new LinkedHashMap<String, String>();
        String match = ("camel.component." + name).toLowerCase(Locale.ENGLISH);
        for (String string : this.wildcardProperties.stringPropertyNames()) {
            String mKey = string.substring(0, string.indexOf(42)).toLowerCase(Locale.ENGLISH);
            if (!match.startsWith(mKey)) continue;
            BaseMainSupport.computeProperties("camel.component.", string, this.wildcardProperties, properties, s -> Collections.singleton(component));
        }
        try {
            for (Map.Entry entry : properties.entrySet()) {
                BaseMainSupport.setPropertiesOnTarget(this.camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (Map)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            }
            if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
                LOG.info("Auto-configuration component {} summary:", (Object)name);
                autoConfiguredProperties.forEach((k, v) -> {
                    boolean sensitive = SENSITIVE_KEYS.contains(k.toLowerCase(Locale.ENGLISH));
                    if (sensitive) {
                        LOG.info("\t{}=xxxxxx", k);
                    } else {
                        LOG.info("\t{}={}", k, v);
                    }
                });
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    protected static void validateOptionAndValue(String key, String option, String value) {
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)option)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because option is empty");
        }
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)value)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because value is empty");
        }
    }

    protected static void computeProperties(String keyPrefix, String key, Properties prop, Map<PropertyOptionKey, Map<String, Object>> properties, Function<String, Iterable<Object>> supplier) {
        if (key.startsWith(keyPrefix)) {
            String name;
            int dot = key.indexOf(46, keyPrefix.length());
            String string = name = dot == -1 ? key.substring(keyPrefix.length()) : key.substring(keyPrefix.length(), dot);
            if ("enabled".equals(name)) {
                return;
            }
            if ("properties".equals(name)) {
                return;
            }
            if (!BaseMainSupport.isServiceEnabled(keyPrefix, name, prop)) {
                return;
            }
            String prefix = dot == -1 ? "" : key.substring(0, dot + 1);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            if ("enabled".equalsIgnoreCase(option)) {
                return;
            }
            BaseMainSupport.validateOptionAndValue(key, option, value);
            Iterable<Object> targets = supplier.apply(name);
            for (Object target : targets) {
                PropertyOptionKey pok = new PropertyOptionKey(target, prefix);
                Map values = properties.computeIfAbsent(pok, k -> new LinkedHashMap());
                values.put(BaseMainSupport.optionKey(option), value);
            }
        }
    }

    protected static boolean isServiceEnabled(String prefix, String name, Properties properties) {
        org.apache.camel.util.ObjectHelper.notNull((Object)prefix, (String)"prefix");
        org.apache.camel.util.ObjectHelper.notNull((Object)name, (String)"name");
        org.apache.camel.util.ObjectHelper.notNull((Object)properties, (String)"properties");
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String group = properties.getProperty(prefix + "enabled", "true");
        String item = properties.getProperty(prefix + name + ".enabled", group);
        return Boolean.parseBoolean(item);
    }

    private static /* synthetic */ boolean lambda$doConfigureCamelContextFromMainConfiguration$2(String pattern, File f) {
        return StringHelper.matches((String)pattern, (String)f.getName());
    }

    private static final class PropertyOptionKey {
        private final Object instance;
        private final String optionPrefix;

        private PropertyOptionKey(Object instance, String optionPrefix) {
            this.instance = org.apache.camel.util.ObjectHelper.notNull((Object)instance, (String)"instance");
            this.optionPrefix = (String)org.apache.camel.util.ObjectHelper.notNull((Object)optionPrefix, (String)"optionPrefix");
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getOptionPrefix() {
            return this.optionPrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyOptionKey)) {
                return false;
            }
            PropertyOptionKey key = (PropertyOptionKey)o;
            return Objects.equals(this.instance, key.instance) && Objects.equals(this.optionPrefix, key.optionPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.instance, this.optionPrefix);
        }
    }
}

