/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.utils;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.LoggingLevel;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;

public final class TaskHelper {
    private TaskHelper() {
    }

    public static String buildUrl(RuntimeCamelCatalog rcc, Map<String, String> props, String componentSchema, String endpointPropertiesPrefix, String pathPropertiesPrefix) throws URISyntaxException {
        HashMap filteredProps = new HashMap();
        props.keySet().stream().filter(k -> k.startsWith(endpointPropertiesPrefix) || k.startsWith(pathPropertiesPrefix)).forEach(k -> {
            String cfr_ignored_0 = (String)filteredProps.put(k.replace(endpointPropertiesPrefix, "").replace(pathPropertiesPrefix, ""), props.get(k));
        });
        return rcc.asEndpointUri(componentSchema, filteredProps, false);
    }

    public static String buildUrl(Map<String, String> props, String componentSchema, String endpointPropertiesPrefix, String pathPropertiesPrefix) {
        String urlPath = TaskHelper.createUrlPathFromProperties(props, pathPropertiesPrefix);
        String endpointOptions = TaskHelper.createEndpointOptionsFromProperties(props, endpointPropertiesPrefix);
        return componentSchema + ":" + urlPath + endpointOptions;
    }

    public static String createEndpointOptionsFromProperties(Map<String, String> props, String prefix) {
        return props.keySet().stream().filter(k -> k.startsWith(prefix)).map(k -> k.replace(prefix, "") + "=" + (String)props.get(k)).reduce((o1, o2) -> o1 + "&" + o2).map(result -> result == null || result.isEmpty() ? "" : "?" + result).orElse("");
    }

    public static String createUrlPathFromProperties(Map<String, String> props, String prefix) {
        return props.keySet().stream().filter(k -> k.startsWith(prefix)).map(k -> (String)props.get(k)).reduce((p1, p2) -> p1 + ":" + p2).orElse("");
    }

    public static Map<String, String> mergeProperties(Map<String, String> defaultProps, Map<String, String> loadedProps) {
        if (loadedProps == null && defaultProps == null) {
            return Collections.EMPTY_MAP;
        }
        if (loadedProps == null) {
            return new HashMap<String, String>(defaultProps);
        }
        if (defaultProps == null) {
            return new HashMap<String, String>(loadedProps);
        }
        HashMap<String, String> result = new HashMap<String, String>(loadedProps);
        defaultProps.keySet().stream().filter(k -> TaskHelper.stringStartWithOneOfPrefixes(k, loadedProps.keySet()) == false).filter(k -> !result.containsKey(k)).forEach(k -> {
            String cfr_ignored_0 = (String)result.put((String)k, (String)defaultProps.get(k));
        });
        return result;
    }

    private static String getStringPrefix(String s) {
        return s.lastIndexOf(".") > 0 ? s.substring(0, s.lastIndexOf(".")) : "";
    }

    private static Boolean stringStartWithOneOfPrefixes(String s, Set<String> prefixes) {
        if (s == null || prefixes == null) {
            return false;
        }
        for (String p : prefixes) {
            if (!s.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public static <CFG extends AbstractConfig> void logRecordContent(Logger logger, ConnectRecord<?> record, CFG config) {
        if (logger != null && record != null && config != null) {
            LoggingLevel level = LoggingLevel.OFF;
            try {
                String key = record instanceof SourceRecord ? "camel.source.contentLogLevel" : "camel.sink.contentLogLevel";
                level = LoggingLevel.valueOf((String)config.getString(key).toUpperCase());
            }
            catch (Exception e) {
                logger.warn("Invalid value for contentLogLevel property");
            }
            switch (level) {
                case TRACE: {
                    logger.trace(record.toString());
                    break;
                }
                case DEBUG: {
                    logger.debug(record.toString());
                    break;
                }
                case INFO: {
                    logger.info(record.toString());
                    break;
                }
                case WARN: {
                    logger.warn(record.toString());
                    break;
                }
                case ERROR: {
                    logger.error(record.toString());
                    break;
                }
            }
        }
    }
}

