/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.utils;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.kafkaconnector.utils.CamelKafkaConnectDataformat;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.Main;
import org.apache.camel.main.MainListener;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.OrderedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMainSupport {
    public static final String CAMEL_DATAFORMAT_PROPERTIES_PREFIX = "camel.dataformat.";
    private static final Logger LOG = LoggerFactory.getLogger(CamelMainSupport.class);
    private Main camelMain;
    private CamelContext camel;
    private final ExecutorService exService = Executors.newSingleThreadExecutor();
    private final CountDownLatch startFinishedSignal = new CountDownLatch(1);

    public CamelMainSupport(Map<String, String> props, String fromUrl, String toUrl, List<CamelKafkaConnectDataformat> dataformats, int aggregationSize, long aggregationTimeout) throws Exception {
        this(props, fromUrl, toUrl, dataformats, aggregationSize, aggregationTimeout, (CamelContext)new DefaultCamelContext());
    }

    public CamelMainSupport(Map<String, String> props, final String fromUrl, final String toUrl, final List<CamelKafkaConnectDataformat> dataformats, final int aggregationSize, final long aggregationTimeout, CamelContext camelContext) throws Exception {
        this.camel = camelContext;
        this.camelMain = new Main(){

            protected ProducerTemplate findOrCreateCamelTemplate() {
                return CamelMainSupport.this.camel.createProducerTemplate();
            }

            protected CamelContext createCamelContext() {
                return CamelMainSupport.this.camel;
            }
        };
        this.camelMain.addMainListener((MainListener)new CamelMainFinishedListener());
        this.camelMain.configure().setAutoConfigurationLogSummary(false);
        LinkedHashMap orderedProps = new LinkedHashMap();
        props.keySet().stream().filter(k -> ((String)props.get(k)).startsWith("#class:")).forEach(k -> {
            String cfr_ignored_0 = (String)orderedProps.put(k, props.get(k));
        });
        props.keySet().stream().filter(k -> !((String)props.get(k)).startsWith("#class:")).forEach(k -> {
            String cfr_ignored_0 = (String)orderedProps.put(k, props.get(k));
        });
        OrderedProperties camelProperties = new OrderedProperties();
        camelProperties.putAll((Map<?, ?>)orderedProps);
        LOG.info("Setting initial properties in Camel context: [{}]", (Object)camelProperties);
        this.camel.getPropertiesComponent().setInitialProperties((Properties)camelProperties);
        this.camelMain.init();
        this.camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                RouteDefinition rd = this.from(fromUrl);
                LOG.info("Creating Camel route from({})", (Object)fromUrl);
                block4: for (CamelKafkaConnectDataformat dataformat : dataformats) {
                    String dataformatId = dataformat.getDataformatId();
                    switch (dataformat.getDataformatKind()) {
                        case MARSHALL: {
                            LOG.info(".marshal().custom({})", (Object)dataformatId);
                            CamelMainSupport.this.camel.getRegistry().bind(dataformatId, (Object)CamelMainSupport.this.lookupAndInstantiateDataformat(dataformatId));
                            rd.marshal().custom(dataformatId);
                            continue block4;
                        }
                        case UNMARSHALL: {
                            LOG.info(".unmarshal().custom({})", (Object)dataformatId);
                            CamelMainSupport.this.camel.getRegistry().bind(dataformatId, (Object)CamelMainSupport.this.lookupAndInstantiateDataformat(dataformatId));
                            rd.unmarshal().custom(dataformatId);
                            continue block4;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported dataformat: " + dataformat);
                }
                if (CamelMainSupport.this.camel.getRegistry().lookupByName("aggregate") != null) {
                    AggregationStrategy s = (AggregationStrategy)CamelMainSupport.this.camel.getRegistry().lookupByName("aggregate");
                    LOG.info(".aggregate({}).constant(true).completionSize({}).completionTimeout({})", new Object[]{s, aggregationSize, aggregationTimeout});
                    LOG.info(".to({})", (Object)toUrl);
                    ((AggregateDefinition)rd.aggregate(s).constant((Object)true)).completionSize(aggregationSize).completionTimeout(aggregationTimeout).toD(toUrl);
                } else {
                    LOG.info(".to({})", (Object)toUrl);
                    rd.toD(toUrl);
                }
            }
        });
    }

    public void start() throws Exception {
        LOG.info("Starting CamelContext");
        CamelContextStarter starter = new CamelContextStarter();
        this.exService.execute(starter);
        this.startFinishedSignal.await();
        if (starter.hasException()) {
            LOG.info("CamelContext failed to start", (Throwable)starter.getException());
            throw starter.getException();
        }
        LOG.info("CamelContext started");
    }

    public void stop() {
        LOG.info("Stopping CamelContext");
        this.camelMain.stop();
        this.exService.shutdown();
        LOG.info("CamelContext stopped");
    }

    public ProducerTemplate createProducerTemplate() {
        return this.camel.createProducerTemplate();
    }

    public Endpoint getEndpoint(String uri) {
        return this.camel.getEndpoint(uri);
    }

    public Collection<Endpoint> getEndpoints() {
        return this.camel.getEndpoints();
    }

    public ConsumerTemplate createConsumerTemplate() {
        return this.camel.createConsumerTemplate();
    }

    public RuntimeCamelCatalog getRuntimeCamelCatalog() {
        return ((ExtendedCamelContext)this.camel.adapt(ExtendedCamelContext.class)).getRuntimeCamelCatalog();
    }

    private DataFormat lookupAndInstantiateDataformat(String dataformatName) {
        DataFormat df = this.camel.resolveDataFormat(dataformatName);
        if (df == null) {
            df = this.camel.createDataFormat(dataformatName);
            String prefix = CAMEL_DATAFORMAT_PROPERTIES_PREFIX + dataformatName + ".";
            Properties props = this.camel.getPropertiesComponent().loadProperties(k -> k.startsWith(prefix));
            CamelContextAware.trySetCamelContext((Object)df, (CamelContext)this.camel);
            if (!props.isEmpty()) {
                PropertyBindingSupport.build().withCamelContext(this.camel).withOptionPrefix(prefix).withRemoveParameters(false).withProperties((Map)props).withTarget((Object)df).bind();
            }
        }
        if (df == null) {
            throw new UnsupportedOperationException("No DataFormat found with name " + dataformatName);
        }
        return df;
    }

    private class CamelContextStarter
    implements Runnable {
        private Exception startException;

        private CamelContextStarter() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    CamelMainSupport.this.camelMain.run();
                }
                catch (Exception e) {
                    LOG.error("An exception has occurred before CamelContext startup has finished", (Throwable)e);
                    this.startException = e;
                    if (CamelMainSupport.this.startFinishedSignal.getCount() <= 0L) break block2;
                    LOG.trace("Signaling CamelContext startup is finished (startFinishedSignal.countDown();) due to an exception");
                    CamelMainSupport.this.startFinishedSignal.countDown();
                }
            }
        }

        public boolean hasException() {
            return this.startException != null;
        }

        public Exception getException() {
            return this.startException;
        }
    }

    private class CamelMainFinishedListener
    implements MainListener {
        private CamelMainFinishedListener() {
        }

        public void configure(CamelContext context) {
        }

        public void beforeStart(BaseMainSupport main) {
        }

        public void afterStart(BaseMainSupport main) {
            LOG.trace("Signaling CamelContext startup is finished (startFinishedSignal.countDown();) due to CamelMainFinishedListener been called");
            CamelMainSupport.this.startFinishedSignal.countDown();
        }

        public void beforeStop(BaseMainSupport main) {
        }

        public void afterStop(BaseMainSupport main) {
        }

        public void beforeConfigure(BaseMainSupport main) {
        }

        public void afterConfigure(BaseMainSupport main) {
        }

        public void beforeInitialize(BaseMainSupport main) {
        }
    }
}

