/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.tx;

import java.util.TimerTask;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Session;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.taskmanager.TimedTaskManager;
import org.apache.camel.component.sjms.tx.BatchTransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.DefaultTransactionCommitStrategy;
import org.apache.camel.spi.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SessionBatchTransactionSynchronization
implements Synchronization {
    private static final Logger LOG = LoggerFactory.getLogger(SessionBatchTransactionSynchronization.class);
    private Session session;
    private final TransactionCommitStrategy commitStrategy;
    private long batchTransactionTimeout = 5000L;
    private TimeoutTask currentTask;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private final TimedTaskManager timedTaskManager;

    public SessionBatchTransactionSynchronization(TimedTaskManager timedTaskManager, Session session, TransactionCommitStrategy commitStrategy, long batchTransactionTimeout) {
        this.timedTaskManager = timedTaskManager;
        this.session = session;
        this.commitStrategy = commitStrategy == null ? new DefaultTransactionCommitStrategy() : commitStrategy;
        if (batchTransactionTimeout > 0L) {
            this.batchTransactionTimeout = batchTransactionTimeout;
            this.createTask();
        }
    }

    public void onFailure(Exchange exchange) {
        try {
            this.lock.readLock().lock();
            if (this.commitStrategy.rollback(exchange)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing failure of Exchange id:{}", (Object)exchange.getExchangeId());
                }
                if (this.session != null && this.session.getTransacted()) {
                    this.session.rollback();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to rollback the session: " + e.getMessage() + ". This exception will be ignored.", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void onComplete(Exchange exchange) {
        try {
            this.lock.readLock().lock();
            if (this.commitStrategy.commit(exchange)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing completion of Exchange id:{}", (Object)exchange.getExchangeId());
                }
                if (this.session != null && this.session.getTransacted()) {
                    this.session.commit();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to commit the session: " + e.getMessage() + ". This exception will be ignored.", (Throwable)e);
            exchange.setException((Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.resetTask();
    }

    private void createTask() {
        try {
            this.lock.writeLock().lock();
            this.currentTask = new TimeoutTask();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void resetTask() {
        try {
            this.lock.writeLock().lock();
            this.currentTask.cancel();
            this.currentTask = new TimeoutTask();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.timedTaskManager.addTask(this.currentTask, this.batchTransactionTimeout);
    }

    public final class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            LOG.debug("Batch Transaction Timer expired");
            try {
                SessionBatchTransactionSynchronization.this.lock.writeLock().lock();
                LOG.trace("Committing the current transactions");
                try {
                    if (SessionBatchTransactionSynchronization.this.session != null && SessionBatchTransactionSynchronization.this.session.getTransacted()) {
                        SessionBatchTransactionSynchronization.this.session.commit();
                    }
                    ((BatchTransactionCommitStrategy)SessionBatchTransactionSynchronization.this.commitStrategy).reset();
                }
                catch (Exception e) {
                    LOG.warn("Failed to commit the session during timeout: " + e.getMessage() + ". This exception will be ignored.", (Throwable)e);
                }
            }
            finally {
                SessionBatchTransactionSynchronization.this.lock.writeLock().unlock();
            }
        }

        @Override
        public boolean cancel() {
            LOG.trace("Cancelling the TimeoutTask");
            return super.cancel();
        }
    }
}

