/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.batch;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SjmsBatchEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":destinationName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "sjms-batch".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "destinationName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(24);
        props.add("aggregationStrategy");
        props.add("mapJmsMessage");
        props.add("consumerCount");
        props.add("recoveryInterval");
        props.add("synchronous");
        props.add("sendEmptyMessageWhenIdle");
        props.add("includeAllJMSXProperties");
        props.add("pollDuration");
        props.add("exchangePattern");
        props.add("eagerCheckCompletion");
        props.add("completionSize");
        props.add("timeoutCheckerExecutorService");
        props.add("completionTimeout");
        props.add("bridgeErrorHandler");
        props.add("jmsKeyFormatStrategy");
        props.add("keepAliveDelay");
        props.add("completionInterval");
        props.add("headerFilterStrategy");
        props.add("destinationName");
        props.add("messageCreatedStrategy");
        props.add("asyncStartListener");
        props.add("completionPredicate");
        props.add("exceptionHandler");
        props.add("allowNullBody");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

