/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.HashSet;
import java.util.Set;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatedExceptionListener
implements ExceptionListener {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatedExceptionListener.class);
    private final Set<ExceptionListener> listenerSet;

    public AggregatedExceptionListener(ExceptionListener ... exceptionListeners) {
        this.listenerSet = new HashSet<ExceptionListener>(exceptionListeners.length);
        for (ExceptionListener exceptionListener : exceptionListeners) {
            if (exceptionListener instanceof AggregatedExceptionListener) {
                this.listenerSet.addAll(((AggregatedExceptionListener)exceptionListener).listenerSet);
                continue;
            }
            this.listenerSet.add(exceptionListener);
        }
    }

    public void onException(JMSException exception) {
        for (ExceptionListener listener : this.listenerSet) {
            try {
                listener.onException(exception);
            }
            catch (Exception ex) {
                LOG.error("Exception listeners shouldn't throw exceptions", (Throwable)ex);
            }
        }
    }
}

