/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.sjms.MessageProducerResources;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.tx.SessionTransactionSynchronization;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SjmsProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SjmsProducer.class);
    private GenericObjectPool<MessageProducerResources> producers;
    private ExecutorService executor;
    private Future<?> asyncStart;

    public SjmsProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "SjmsProducer");
        if (this.getProducers() == null) {
            GenericObjectPool producers = new GenericObjectPool((PoolableObjectFactory)new MessageProducerResourcesFactory());
            this.setProducers((GenericObjectPool<MessageProducerResources>)producers);
            producers.setMaxActive(this.getProducerCount());
            producers.setMaxIdle(this.getProducerCount());
            producers.setTestOnBorrow(this.getEndpoint().getComponent().isConnectionTestOnBorrow());
            producers.setLifo(false);
            if (this.getEndpoint().isPrefillPool()) {
                if (this.getEndpoint().isAsyncStartListener()) {
                    this.asyncStart = this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SjmsProducer.this.fillProducersPool();
                            }
                            catch (Throwable e) {
                                LOG.warn("Error filling producer pool for destination: {}. This exception will be ignored.", (Object)SjmsProducer.this.getDestinationName(), (Object)e);
                            }
                        }

                        public String toString() {
                            return "AsyncStartListenerTask[" + SjmsProducer.this.getDestinationName() + "]";
                        }
                    });
                } else {
                    this.fillProducersPool();
                }
            }
        }
    }

    private void fillProducersPool() throws Exception {
        while (this.producers.getNumIdle() < this.producers.getMaxIdle()) {
            this.producers.addObject();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.asyncStart != null && !this.asyncStart.isDone()) {
            this.asyncStart.cancel(true);
        }
        if (this.getProducers() != null) {
            if (this.getEndpoint().isAsyncStopListener()) {
                this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SjmsProducer.this.getProducers().close();
                            SjmsProducer.this.setProducers(null);
                        }
                        catch (Throwable e) {
                            LOG.warn("Error closing producers on destination: {}. This exception will be ignored.", (Object)SjmsProducer.this.getDestinationName(), (Object)e);
                        }
                    }

                    public String toString() {
                        return "AsyncStopListenerTask[" + SjmsProducer.this.getDestinationName() + "]";
                    }
                });
            } else {
                this.getProducers().close();
                this.setProducers(null);
            }
        }
        if (this.executor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor);
        }
    }

    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    protected MessageProducerResources doCreateProducerModel(Session session) throws Exception {
        MessageProducerResources answer;
        try {
            MessageProducer messageProducer = this.getEndpoint().getJmsObjectFactory().createMessageProducer(session, (Endpoint)this.getEndpoint());
            answer = new MessageProducerResources(session, messageProducer, this.getCommitStrategy());
        }
        catch (Exception e) {
            LOG.error("Unable to create the MessageProducer", (Throwable)e);
            throw e;
        }
        return answer;
    }

    protected Session createSession() throws Exception {
        ConnectionResource connectionResource = this.getOrCreateConnectionResource();
        Connection conn = connectionResource.borrowConnection();
        try {
            Session session = conn.createSession(this.isEndpointTransacted(), this.getAcknowledgeMode());
            return session;
        }
        catch (Exception e) {
            LOG.error("Unable to create the Session", (Throwable)e);
            throw e;
        }
        finally {
            connectionResource.returnConnection(conn);
        }
    }

    public abstract void sendMessage(Exchange var1, AsyncCallback var2, MessageProducerResources var3, ReleaseProducerCallback var4) throws Exception;

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing Exchange.id:{}", (Object)exchange.getExchangeId());
        }
        try {
            ReleaseProducerCallback releaseProducerCallback;
            MessageProducerResources producer;
            if (this.isEndpointTransacted() && this.isSharedJMSSession()) {
                Session session = (Session)exchange.getIn().getHeader("CamelJMSSession", Session.class);
                if (session != null && session.getTransacted()) {
                    producer = this.doCreateProducerModel(session);
                    releaseProducerCallback = new CloseProducerCallback();
                } else {
                    producer = (MessageProducerResources)this.getProducers().borrowObject();
                    releaseProducerCallback = new ReturnProducerCallback();
                    exchange.getIn().setHeader("CamelJMSSession", (Object)producer.getSession());
                    exchange.getUnitOfWork().addSynchronization((Synchronization)new SessionTransactionSynchronization(producer.getSession(), producer.getCommitStrategy()));
                }
            } else {
                producer = (MessageProducerResources)this.getProducers().borrowObject();
                releaseProducerCallback = new ReturnProducerCallback();
                if (this.isEndpointTransacted()) {
                    exchange.getUnitOfWork().addSynchronization((Synchronization)new SessionTransactionSynchronization(producer.getSession(), producer.getCommitStrategy()));
                }
            }
            if (producer == null) {
                exchange.setException((Throwable)new Exception("Unable to send message: connection not available"));
            } else if (!this.isSynchronous()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Sending message asynchronously: {}", exchange.getIn().getBody());
                }
                this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SjmsProducer.this.sendMessage(exchange, callback, producer, releaseProducerCallback);
                        }
                        catch (Exception e) {
                            RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                        }
                    }
                });
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Sending message synchronously: {}", exchange.getIn().getBody());
                }
                this.sendMessage(exchange, callback, producer, releaseProducerCallback);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing Exchange.id:{}", (Object)(exchange.getExchangeId() + " - FAILED"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.trace("Exception: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
            exchange.setException((Throwable)e);
        }
        LOG.debug("Processing Exchange.id:{}", (Object)(exchange.getExchangeId() + " - SUCCESS"));
        return this.isSynchronous();
    }

    @Deprecated
    protected ConnectionResource getConnectionResource() {
        return this.getEndpoint().getConnectionResource();
    }

    protected ConnectionResource getOrCreateConnectionResource() {
        ConnectionResource answer = this.getEndpoint().getConnectionResource();
        if (answer == null) {
            answer = this.getEndpoint().createConnectionResource((Object)this);
        }
        return answer;
    }

    public int getAcknowledgeMode() {
        return this.getEndpoint().getAcknowledgementMode().intValue();
    }

    public boolean isSynchronous() {
        return this.getEndpoint().isSynchronous();
    }

    public String getReplyTo() {
        return this.getEndpoint().getNamedReplyTo();
    }

    public String getDestinationName() {
        return this.getEndpoint().getDestinationName();
    }

    public void setProducers(GenericObjectPool<MessageProducerResources> producers) {
        this.producers = producers;
    }

    public GenericObjectPool<MessageProducerResources> getProducers() {
        return this.producers;
    }

    public boolean isTopic() {
        return this.getEndpoint().isTopic();
    }

    public boolean isEndpointTransacted() {
        return this.getEndpoint().isTransacted();
    }

    public boolean isSharedJMSSession() {
        return this.getEndpoint().isSharedJMSSession();
    }

    public String getNamedReplyTo() {
        return this.getEndpoint().getNamedReplyTo();
    }

    public int getProducerCount() {
        return this.getEndpoint().getProducerCount();
    }

    public int getConsumerCount() {
        return this.getEndpoint().getConsumerCount();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public long getTtl() {
        return this.getEndpoint().getTtl();
    }

    public boolean isPersistent() {
        return this.getEndpoint().isPersistent();
    }

    public long getResponseTimeOut() {
        return this.getEndpoint().getResponseTimeOut();
    }

    protected TransactionCommitStrategy getCommitStrategy() {
        if (this.isEndpointTransacted()) {
            return this.getEndpoint().getTransactionCommitStrategy();
        }
        return null;
    }

    protected class ReturnProducerCallback
    implements ReleaseProducerCallback {
        protected ReturnProducerCallback() {
        }

        @Override
        public void release(MessageProducerResources producer) throws Exception {
            SjmsProducer.this.getProducers().returnObject((Object)producer);
        }
    }

    protected class CloseProducerCallback
    implements ReleaseProducerCallback {
        protected CloseProducerCallback() {
        }

        @Override
        public void release(MessageProducerResources producer) throws Exception {
            producer.getMessageProducer().close();
        }
    }

    protected static interface ReleaseProducerCallback {
        public void release(MessageProducerResources var1) throws Exception;
    }

    protected class MessageProducerResourcesFactory
    extends BasePoolableObjectFactory<MessageProducerResources> {
        protected MessageProducerResourcesFactory() {
        }

        public MessageProducerResources makeObject() throws Exception {
            return SjmsProducer.this.doCreateProducerModel(SjmsProducer.this.createSession());
        }

        public boolean validateObject(MessageProducerResources obj) {
            try {
                obj.getSession().getAcknowledgeMode();
                return true;
            }
            catch (JMSException ex) {
                LOG.error("Cannot validate session", (Throwable)ex);
                return false;
            }
        }

        public void destroyObject(MessageProducerResources model) throws Exception {
            if (model.getMessageProducer() != null) {
                model.getMessageProducer().close();
            }
            if (model.getSession() != null) {
                try {
                    if (model.getSession().getTransacted()) {
                        try {
                            model.getSession().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    model.getSession().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

