/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.camel.component.slack.utils.SlackUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class SlackComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public SlackComponentVerifierExtension() {
        this("slack");
    }

    public SlackComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS);
        if (ObjectHelper.isEmpty((Object)parameters.get("token")) && ObjectHelper.isEmpty((Object)parameters.get("webhookUrl"))) {
            builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.GENERIC, (String)"You must specify a webhookUrl (for producer) or a token (for consumer)").parameterKey("webhookUrl").parameterKey("token").build());
        }
        if (ObjectHelper.isNotEmpty((Object)parameters.get("token")) && ObjectHelper.isNotEmpty((Object)parameters.get("webhookUrl"))) {
            builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.GENERIC, (String)"You must specify a webhookUrl (for producer) or a token (for consumer). You can't specify both.").parameterKey("webhookUrl").parameterKey("token").build());
        }
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        String webhookUrl = (String)parameters.get("webhookUrl");
        if (ObjectHelper.isNotEmpty((Object)webhookUrl)) {
            try {
                CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
                HttpPost httpPost = new HttpPost(webhookUrl);
                SlackMessage slackMessage = new SlackMessage();
                slackMessage.setText("Test connection");
                String json = this.asJson(slackMessage);
                StringEntity body = new StringEntity(json);
                httpPost.setEntity((HttpEntity)body);
                HttpResponse response = client.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 299) {
                    builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid webhookUrl").parameterKey("webhookUrl").build());
                }
            }
            catch (Exception e) {
                builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid webhookUrl").parameterKey("webhookUrl").build());
            }
        }
        if (ObjectHelper.isNotEmpty((Object)parameters.get("token"))) {
            String token = (String)parameters.get("token");
            try {
                JsonObject obj;
                CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
                HttpPost httpPost = new HttpPost(parameters.get("serverUrl") + "/api/channels.list");
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("token", token));
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                HttpResponse response = client.execute((HttpUriRequest)httpPost);
                String jsonString = SlackUtils.readResponse(response.getEntity().getContent());
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 299) {
                    builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid token").parameterKey("token").build());
                }
                if ((obj = (JsonObject)Jsoner.deserialize((String)jsonString)).get((Object)"ok") != null && obj.get((Object)"ok").equals(false)) {
                    builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid token").parameterKey("token").build());
                }
            }
            catch (Exception e) {
                builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid token").parameterKey("token").build());
            }
        }
    }

    protected String asJson(SlackMessage message) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("text", message.getText());
        return new JsonObject(jsonMap).toJson();
    }
}

