/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.slack.SlackComponent;
import org.apache.camel.component.slack.SlackConsumer;
import org.apache.camel.component.slack.SlackProducer;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.JsonObject;

@UriEndpoint(firstVersion="2.16.0", scheme="slack", title="Slack", syntax="slack:channel", label="social")
public class SlackEndpoint
extends ScheduledPollEndpoint {
    @UriPath
    @Metadata(required=true)
    private String channel;
    @UriParam(label="producer")
    private String webhookUrl;
    @UriParam(label="producer", secret=true)
    private String username;
    @UriParam(label="producer")
    private String iconUrl;
    @UriParam(label="producer")
    private String iconEmoji;
    @UriParam(label="consumer", secret=true)
    private String token;
    @UriParam(label="consumer", defaultValue="10")
    private String maxResults = "10";
    @UriParam(label="consumer", defaultValue="https://slack.com")
    private String serverUrl = "https://slack.com";

    public SlackEndpoint(String uri, String channelName, SlackComponent component) {
        super(uri, (Component)component);
        this.webhookUrl = component.getWebhookUrl();
        this.channel = channelName;
    }

    public Producer createProducer() throws Exception {
        SlackProducer producer = new SlackProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.token)) {
            throw new RuntimeCamelException("Missing required endpoint configuration: token must be defined for Slack consumer");
        }
        SlackConsumer consumer = new SlackConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    public void setIconEmoji(String iconEmoji) {
        this.iconEmoji = iconEmoji;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(String maxResult) {
        this.maxResults = maxResult;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public Exchange createExchange(JsonObject object) {
        return this.createExchange(this.getExchangePattern(), object);
    }

    public Exchange createExchange(ExchangePattern pattern, JsonObject object) {
        JsonObject icons;
        Exchange exchange = super.createExchange(pattern);
        SlackMessage slackMessage = new SlackMessage();
        String text = object.getString("text");
        String user = object.getString("user");
        slackMessage.setText(text);
        slackMessage.setUser(user);
        if (ObjectHelper.isNotEmpty((Object)object.get((Object)"icons")) && ObjectHelper.isNotEmpty((Object)(icons = (JsonObject)object.getMap("icons")).get((Object)"emoji"))) {
            slackMessage.setIconEmoji(icons.getString("emoji"));
        }
        Message message = exchange.getIn();
        message.setBody((Object)slackMessage);
        return exchange;
    }
}

