/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpResponse;

public final class SlackUtils {
    private SlackUtils() {
    }

    public static String readResponse(HttpResponse response) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (InputStream s = response.getEntity().getContent();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = s.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }

    public static String readResponse(InputStream s) throws IOException, UnsupportedEncodingException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = s.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }
}

