/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.slack.transformers;

import java.util.Map;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELD_KEY_CONFIG = "key";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("key", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Transforms String-based content from Kafka into a map");
    private static final Logger LOG = LoggerFactory.getLogger(SlackTransforms.class);

    public R apply(R r) {
        Object value = r.value();
        if (r.value() instanceof SlackMessage) {
            LOG.debug("Converting record from SlackMessage to text");
            SlackMessage message = (SlackMessage)r.value();
            LOG.debug("Received text: {}", (Object)message.getText());
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), null, r.key(), (Schema)SchemaHelper.buildSchemaBuilderForType((Object)message.getText()), (Object)message.getText(), r.timestamp());
        }
        LOG.debug("Unexpected message type: {}", r.value().getClass());
        return r;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }
}

