/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import org.jsmpp.bean.Command;
import org.jsmpp.session.ActivityNotifier;
import org.jsmpp.session.OutboundResponseHandler;
import org.jsmpp.session.SMPPOutboundSessionContext;
import org.jsmpp.util.HexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PDUProcessOutboundTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PDUProcessOutboundTask.class);
    private final Command pduHeader;
    private final byte[] pdu;
    private final SMPPOutboundSessionContext sessionContext;
    private final OutboundResponseHandler responseHandler;
    private final ActivityNotifier activityNotifier;
    private final Runnable onIOExceptionTask;

    PDUProcessOutboundTask(Command pduHeader, byte[] pdu, SMPPOutboundSessionContext sessionContext, OutboundResponseHandler responseHandler, ActivityNotifier activityNotifier, Runnable onIOExceptionTask) {
        this.pduHeader = pduHeader;
        this.pdu = pdu;
        this.sessionContext = sessionContext;
        this.responseHandler = responseHandler;
        this.activityNotifier = activityNotifier;
        this.onIOExceptionTask = onIOExceptionTask;
    }

    @Override
    public void run() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Received PDU {}", (Object)HexUtil.convertBytesToHexString(this.pdu, 0, this.pdu.length));
            }
            switch (this.pduHeader.getCommandId()) {
                case 1: 
                case 2: 
                case 9: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processBind(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483648: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processGenericNack(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 21: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processEnquireLink(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483627: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processEnquireLinkResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483643: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processDeliverSmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 6: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processUnbind(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483642: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processUnbindResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                default: {
                    this.sessionContext.getStateProcessor().processUnknownCid(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.onIOExceptionTask.run();
        }
    }
}

