/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SmppEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port";
    private static final String[] SCHEMES = new String[]{"smpp", "smpps"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "host", "localhost", false, copy);
        uri = this.buildPathParameter(syntax, uri, "port", "2775", false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(41);
        props.add("serviceType");
        props.add("lazySessionCreation");
        props.add("initialReconnectDelay");
        props.add("destAddrTon");
        props.add("synchronous");
        props.add("httpProxyHost");
        props.add("numberingPlanIndicator");
        props.add("alphabet");
        props.add("destAddrNpi");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("host");
        props.add("systemType");
        props.add("sourceAddr");
        props.add("sourceAddrNpi");
        props.add("systemId");
        props.add("addressRange");
        props.add("exchangePattern");
        props.add("sessionStateListener");
        props.add("usingSSL");
        props.add("registeredDelivery");
        props.add("httpProxyPort");
        props.add("reconnectDelay");
        props.add("encoding");
        props.add("httpProxyPassword");
        props.add("transactionTimer");
        props.add("splittingPolicy");
        props.add("lazyStartProducer");
        props.add("protocolId");
        props.add("proxyHeaders");
        props.add("httpProxyUsername");
        props.add("typeOfNumber");
        props.add("port");
        props.add("dataCoding");
        props.add("enquireLinkTimer");
        props.add("destAddr");
        props.add("replaceIfPresentFlag");
        props.add("priorityFlag");
        props.add("maxReconnect");
        props.add("exceptionHandler");
        props.add("sourceAddrTon");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("systemId");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

