/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.camel.kafkaconnector.VersionUtil;
import org.apache.camel.kafkaconnector.utils.CamelKafkaConnectMain;
import org.apache.camel.kafkaconnector.utils.TaskHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.StringHelper;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.ErrantRecordReporter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSinkTask
extends SinkTask {
    public static final String KAFKA_RECORD_KEY_HEADER = "camel.kafka.connector.record.key";
    public static final String HEADER_CAMEL_PREFIX = "CamelHeader.";
    public static final String PROPERTY_CAMEL_PREFIX = "CamelProperty.";
    private static final String CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX = "camel.sink.endpoint.";
    private static final String CAMEL_SINK_PATH_PROPERTIES_PREFIX = "camel.sink.path.";
    private static final Logger LOG = LoggerFactory.getLogger(CamelSinkTask.class);
    private static final String LOCAL_URL = "direct:start";
    private ErrantRecordReporter reporter;
    private CamelKafkaConnectMain cms;
    private ProducerTemplate producer;
    private Endpoint localEndpoint;
    private LoggingLevel loggingLevel = LoggingLevel.OFF;

    public String version() {
        return VersionUtil.getVersion();
    }

    public void start(Map<String, String> props) {
        try {
            LOG.info("Starting CamelSinkTask connector task");
            Map<String, String> actualProps = TaskHelper.combineDefaultAndLoadedProperties(this.getDefaultConfig(), props);
            CamelSinkConnectorConfig config = this.getCamelSinkConnectorConfig(actualProps);
            if (this.context != null) {
                this.reporter = this.context.errantRecordReporter();
            }
            try {
                String levelStr = config.getString("camel.sink.contentLogLevel");
                this.loggingLevel = LoggingLevel.valueOf((String)levelStr.toUpperCase());
            }
            catch (Exception e) {
                LOG.debug("Invalid value for {} property", (Object)"camel.sink.contentLogLevel");
            }
            String remoteUrl = config.getString("camel.sink.url");
            String marshaller = config.getString("camel.sink.marshal");
            String unmarshaller = config.getString("camel.sink.unmarshal");
            int size = config.getInt("camel.aggregation.size");
            long timeout = config.getLong("camel.aggregation.timeout");
            int maxRedeliveries = config.getInt("camel.error.handler.max.redeliveries");
            long redeliveryDelay = config.getLong("camel.error.handler.redelivery.delay");
            String errorHandler = config.getString("camel.error.handler");
            Boolean idempotencyEnabled = config.getBoolean("camel.idempotency.enabled");
            String expressionType = config.getString("camel.idempotency.expression.type");
            String expressionHeader = config.getString("camel.idempotency.expression.header");
            int memoryDimension = config.getInt("camel.idempotency.memory.dimension");
            String idempotentRepositoryType = config.getString("camel.idempotency.repository.type");
            String idempotentRepositoryKafkaTopic = config.getString("camel.idempotency.kafka.topic");
            String idempotentRepositoryBootstrapServers = config.getString("camel.idempotency.kafka.bootstrap.servers");
            int idempotentRepositoryKafkaMaxCacheSize = config.getInt("camel.idempotency.kafka.max.cache.size");
            int idempotentRepositoryKafkaPollDuration = config.getInt("camel.idempotency.kafka.poll.duration.ms");
            String headersRemovePattern = config.getString("camel.remove.headers.pattern");
            DefaultCamelContext camelContext = new DefaultCamelContext();
            if (remoteUrl == null) {
                remoteUrl = TaskHelper.buildUrl((CamelContext)camelContext, actualProps, config.getString("camel.sink.component"), CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX, CAMEL_SINK_PATH_PROPERTIES_PREFIX);
            }
            this.cms = CamelKafkaConnectMain.builder(LOCAL_URL, remoteUrl).withProperties(actualProps).withUnmarshallDataFormat(unmarshaller).withMarshallDataFormat(marshaller).withAggregationSize(size).withAggregationTimeout(timeout).withErrorHandler(errorHandler).withMaxRedeliveries(maxRedeliveries).withRedeliveryDelay(redeliveryDelay).withIdempotencyEnabled(idempotencyEnabled).withExpressionType(expressionType).withExpressionHeader(expressionHeader).withMemoryDimension(memoryDimension).withIdempotentRepositoryType(idempotentRepositoryType).withIdempotentRepositoryTopicName(idempotentRepositoryKafkaTopic).withIdempotentRepositoryKafkaServers(idempotentRepositoryBootstrapServers).withIdempotentRepositoryKafkaMaxCacheSize(idempotentRepositoryKafkaMaxCacheSize).withIdempotentRepositoryKafkaPollDuration(idempotentRepositoryKafkaPollDuration).withHeadersExcludePattern(headersRemovePattern).build((CamelContext)camelContext);
            this.cms.start();
            this.producer = this.cms.getProducerTemplate();
            this.localEndpoint = this.cms.getCamelContext().getEndpoint(LOCAL_URL);
            LOG.info("CamelSinkTask connector task started");
        }
        catch (Exception e) {
            throw new ConnectException("Failed to create and start Camel context", (Throwable)e);
        }
    }

    protected CamelSinkConnectorConfig getCamelSinkConnectorConfig(Map<String, String> props) {
        return new CamelSinkConnectorConfig(props);
    }

    protected Map<String, String> getDefaultConfig() {
        return Collections.emptyMap();
    }

    protected static String getCamelSinkEndpointConfigPrefix() {
        return CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX;
    }

    protected static String getCamelSinkPathConfigPrefix() {
        return CAMEL_SINK_PATH_PROPERTIES_PREFIX;
    }

    public void put(Collection<SinkRecord> sinkRecords) {
        for (SinkRecord record : sinkRecords) {
            TaskHelper.logRecordContent(LOG, this.loggingLevel, record);
            DefaultExchange exchange = new DefaultExchange(this.producer.getCamelContext());
            exchange.getMessage().setBody(record.value());
            exchange.getMessage().setHeader(KAFKA_RECORD_KEY_HEADER, record.key());
            for (Header header : record.headers()) {
                if (header.key().startsWith(HEADER_CAMEL_PREFIX)) {
                    CamelSinkTask.mapHeader(header, HEADER_CAMEL_PREFIX, exchange.getMessage().getHeaders());
                    continue;
                }
                if (!header.key().startsWith(PROPERTY_CAMEL_PREFIX)) continue;
                CamelSinkTask.mapHeader(header, PROPERTY_CAMEL_PREFIX, exchange.getProperties());
            }
            LOG.debug("Sending exchange {} to {}", (Object)exchange.getExchangeId(), (Object)LOCAL_URL);
            this.producer.send(this.localEndpoint, (Exchange)exchange);
            if (!exchange.isFailed()) continue;
            if (this.reporter == null) {
                LOG.warn("A delivery has failed and the error reporting is NOT enabled. Records may be lost or ignored");
                throw new ConnectException("Exchange delivery has failed!", (Throwable)exchange.getException());
            }
            LOG.warn("A delivery has failed and the error reporting is enabled. Sending record to the DLQ");
            this.reporter.report(record, (Throwable)exchange.getException());
        }
    }

    public void stop() {
        LOG.info("Stopping CamelSinkTask connector task");
        try {
            if (this.cms != null) {
                this.cms.stop();
            } else {
                LOG.warn("A fatal exception may have occurred and the Camel main was not created");
            }
        }
        catch (Exception e) {
            throw new ConnectException("Failed to stop Camel context", (Throwable)e);
        }
        finally {
            LOG.info("CamelSinkTask connector task stopped");
        }
    }

    private static void mapHeader(Header header, String prefix, Map<String, Object> destination) {
        String key = StringHelper.after((String)header.key(), (String)prefix, (String)header.key());
        Schema schema = header.schema();
        if (schema.type().equals((Object)Schema.BYTES_SCHEMA.type()) && Objects.equals(schema.name(), "org.apache.kafka.connect.data.Decimal")) {
            destination.put(key, Decimal.toLogical((Schema)schema, (byte[])((byte[])header.value())));
        } else {
            destination.put(key, header.value());
        }
    }

    CamelKafkaConnectMain getCms() {
        return this.cms;
    }
}

