/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.schema.validation;

import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenDataAndLocationBuilder;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.schema.validation.ArrayNodeHasher;
import com.worldturner.medeia.schema.validation.DigestBuilder$WhenMappings;
import com.worldturner.medeia.schema.validation.DigestBuilder$takeResult$1;
import com.worldturner.medeia.schema.validation.DigestHashResult;
import com.worldturner.medeia.schema.validation.HashResult;
import com.worldturner.medeia.schema.validation.NodeHasher;
import com.worldturner.medeia.schema.validation.NodeHasherParent;
import com.worldturner.medeia.schema.validation.ObjectNodeHasher;
import com.worldturner.util.PropertiesKt;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0016R\u001b\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/worldturner/medeia/schema/validation/DigestBuilder;", "Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationBuilder;", "startLevel", "", "factory", "Lkotlin/Function0;", "Ljava/security/MessageDigest;", "Lcom/worldturner/medeia/schema/validation/MessageDigestFactory;", "(ILkotlin/jvm/functions/Function0;)V", "getFactory", "()Lkotlin/jvm/functions/Function0;", "result", "Lcom/worldturner/medeia/schema/validation/HashResult;", "stack", "Ljava/util/Deque;", "Lcom/worldturner/medeia/schema/validation/NodeHasher;", "getStartLevel", "()I", "consume", "", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "location", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "findParentDigester", "lastStep", "nodeHasher", "processFieldName", "takeResult", "medeia-validator-core"})
public final class DigestBuilder
implements JsonTokenDataAndLocationBuilder {
    private final Deque<NodeHasher> stack;
    private HashResult result;
    private final int startLevel;
    @NotNull
    private final Function0<MessageDigest> factory;

    @Override
    public void consume(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        NodeHasher nodeHasher;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        if (token.getType() == JsonTokenType.FIELD_NAME) {
            this.processFieldName(token);
            return;
        }
        if (token.getType().getFirstToken()) {
            NodeHasher nodeHasher2;
            switch (DigestBuilder$WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
                case 1: {
                    nodeHasher2 = new ObjectNodeHasher(this.factory);
                    break;
                }
                case 2: {
                    MessageDigest parentDigester = this.findParentDigester();
                    nodeHasher2 = new ArrayNodeHasher(parentDigester);
                    break;
                }
                default: {
                    nodeHasher2 = token;
                }
            }
            nodeHasher = nodeHasher2;
            this.stack.push(nodeHasher);
        }
        if (token.getType().getLastToken()) {
            NodeHasher nodeHasher3 = this.stack.pop();
            if (nodeHasher3 == null) {
                Intrinsics.throwNpe();
            }
            nodeHasher = nodeHasher3;
            NodeHasher top = this.stack.peek();
            if (top instanceof NodeHasherParent) {
                ((NodeHasherParent)top).add(nodeHasher);
            } else if (location.getLevel() == this.startLevel) {
                this.lastStep(nodeHasher);
            } else {
                throw (Throwable)new IllegalStateException("Child node seen where this is not allowed");
            }
        }
    }

    private final void lastStep(NodeHasher nodeHasher) {
        NodeHasher nodeHasher2 = nodeHasher;
        if (nodeHasher2 instanceof JsonTokenData) {
            this.result = (HashResult)((Object)nodeHasher);
        } else if (nodeHasher2 instanceof ArrayNodeHasher) {
            MessageDigest digester = ((ArrayNodeHasher)nodeHasher).getParentDigester();
            nodeHasher.digest(digester);
            byte[] byArray = digester.digest();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digester.digest()");
            this.result = new DigestHashResult(byArray);
        } else if (nodeHasher2 instanceof ObjectNodeHasher) {
            MessageDigest digester = (MessageDigest)this.factory.invoke();
            nodeHasher.digest(digester);
            byte[] byArray = digester.digest();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digester.digest()");
            this.result = new DigestHashResult(byArray);
        }
    }

    private final MessageDigest findParentDigester() {
        MessageDigest messageDigest;
        NodeHasher top = this.stack.peek();
        if (top instanceof NodeHasherParent) {
            messageDigest = ((NodeHasherParent)top).getParentDigester();
            if (messageDigest == null) {
                Intrinsics.throwNpe();
            }
        } else {
            messageDigest = (MessageDigest)this.factory.invoke();
        }
        MessageDigest parentDigester = messageDigest;
        return parentDigester;
    }

    private final void processFieldName(JsonTokenData token) {
        NodeHasher top;
        Collection collection = this.stack;
        if (!collection.isEmpty() && (top = this.stack.peek()) instanceof ObjectNodeHasher) {
            ObjectNodeHasher objectNodeHasher = (ObjectNodeHasher)top;
            String string = token.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            objectNodeHasher.setCurrentProperty(string);
            return;
        }
        throw (Throwable)new IllegalStateException("Received field name outside of Object context");
    }

    @Override
    @Nullable
    public HashResult takeResult() {
        return (HashResult)PropertiesKt.getAndClear(new DigestBuilder$takeResult$1(this));
    }

    public final int getStartLevel() {
        return this.startLevel;
    }

    @NotNull
    public final Function0<MessageDigest> getFactory() {
        return this.factory;
    }

    public DigestBuilder(int startLevel, @NotNull Function0<? extends MessageDigest> factory) {
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        this.startLevel = startLevel;
        this.factory = factory;
        this.stack = new ArrayDeque();
    }

    public static final /* synthetic */ HashResult access$getResult$p(DigestBuilder $this) {
        return $this.result;
    }

    public static final /* synthetic */ void access$setResult$p(DigestBuilder $this, HashResult hashResult) {
        $this.result = hashResult;
    }
}

