/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetric$;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class SQLMetrics$ {
    public static final SQLMetrics$ MODULE$;
    private final String SUM_METRIC;
    private final String SIZE_METRIC;
    private final String TIMING_METRIC;
    private final String AVERAGE_METRIC;
    private final int org$apache$spark$sql$execution$metric$SQLMetrics$$baseForAvgMetric;

    static {
        new SQLMetrics$();
    }

    private String SUM_METRIC() {
        return this.SUM_METRIC;
    }

    private String SIZE_METRIC() {
        return this.SIZE_METRIC;
    }

    private String TIMING_METRIC() {
        return this.TIMING_METRIC;
    }

    private String AVERAGE_METRIC() {
        return this.AVERAGE_METRIC;
    }

    public int org$apache$spark$sql$execution$metric$SQLMetrics$$baseForAvgMetric() {
        return this.org$apache$spark$sql$execution$metric$SQLMetrics$$baseForAvgMetric;
    }

    public void setDoubleForAverageMetrics(SQLMetric metric, double v) {
        String string = metric.metricType();
        String string2 = this.AVERAGE_METRIC();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(metric){
            public static final long serialVersionUID = 0L;
            private final SQLMetric metric$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't set a double to a metric of metrics type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metric$1.metricType()}));
            }
            {
                this.metric$1 = metric$1;
            }
        });
        metric.set((long)(v * (double)this.org$apache$spark$sql$execution$metric$SQLMetrics$$baseForAvgMetric()));
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createMetric(SparkContext sc, String name2) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.SUM_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)new Some((Object)name2), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createSizeMetric(SparkContext sc, String name2) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.SIZE_METRIC(), -1L);
        acc.register(sc, (Option)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " total (min, med, max)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2}))), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createTimingMetric(SparkContext sc, String name2) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.TIMING_METRIC(), -1L);
        acc.register(sc, (Option)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " total (min, med, max)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2}))), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createAverageMetric(SparkContext sc, String name2) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.AVERAGE_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (min, med, max)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2}))), false);
        return var3_3;
    }

    public String stringValue(String metricsType, Seq<Object> values2) {
        block13: {
            Seq seq;
            block14: {
                String string;
                block8: {
                    Tuple4 tuple4;
                    Seq seq2;
                    Object object;
                    block12: {
                        block11: {
                            block9: {
                                Seq seq3;
                                block10: {
                                    Tuple3 tuple3;
                                    Seq seq4;
                                    block7: {
                                        String string2 = metricsType;
                                        String string3 = this.SUM_METRIC();
                                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block7;
                                        NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
                                        string = numberFormat.format(BoxesRunTime.unboxToLong((Object)values2.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                                        break block8;
                                    }
                                    String string4 = metricsType;
                                    String string5 = this.AVERAGE_METRIC();
                                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block9;
                                    NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                                    Seq validValues = (Seq)values2.filter((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(long x$1) {
                                            return this.apply$mcZJ$sp(x$1);
                                        }

                                        public boolean apply$mcZJ$sp(long x$1) {
                                            return x$1 > 0L;
                                        }
                                    });
                                    if (validValues.isEmpty()) {
                                        seq4 = (Seq)Seq$.MODULE$.fill(3, (Function0)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final long apply() {
                                                return this.apply$mcJ$sp();
                                            }

                                            public long apply$mcJ$sp() {
                                                return 0L;
                                            }
                                        });
                                    } else {
                                        Seq sorted = (Seq)validValues.sorted((Ordering)Ordering.Long$.MODULE$);
                                        seq4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)sorted.apply(0)), BoxesRunTime.unboxToLong((Object)sorted.apply(validValues.length() / 2)), BoxesRunTime.unboxToLong((Object)sorted.apply(validValues.length() - 1))}));
                                    }
                                    Seq metric = seq4;
                                    seq3 = (Seq)metric.map((Function1)new Serializable(numberFormat){
                                        public static final long serialVersionUID = 0L;
                                        private final NumberFormat numberFormat$1;

                                        public final String apply(long v) {
                                            return this.numberFormat$1.format((double)v / (double)SQLMetrics$.MODULE$.org$apache$spark$sql$execution$metric$SQLMetrics$$baseForAvgMetric());
                                        }
                                        {
                                            this.numberFormat$1 = numberFormat$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    Some some = Seq$.MODULE$.unapplySeq(seq3);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block10;
                                    String min = (String)((SeqLike)some.get()).apply(0);
                                    String med = (String)((SeqLike)some.get()).apply(1);
                                    String max = (String)((SeqLike)some.get()).apply(2);
                                    Tuple3 tuple32 = tuple3 = new Tuple3((Object)min, (Object)med, (Object)max);
                                    String min2 = (String)tuple32._1();
                                    String med2 = (String)tuple32._2();
                                    String max2 = (String)tuple32._3();
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{min2, med2, max2}));
                                    break block8;
                                }
                                throw new MatchError((Object)seq3);
                            }
                            String string6 = metricsType;
                            String string7 = this.SIZE_METRIC();
                            if (string6 != null ? !string6.equals(string7) : string7 != null) break block11;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(long size) {
                                    return Utils$.MODULE$.bytesToString(size);
                                }
                            };
                            break block12;
                        }
                        String string8 = metricsType;
                        String string9 = this.TIMING_METRIC();
                        if (string8 != null ? !string8.equals(string9) : string9 != null) break block13;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(long ms) {
                                return Utils$.MODULE$.msDurationToString(ms);
                            }
                        };
                    }
                    Serializable strFormat = object;
                    Seq validValues = (Seq)values2.filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(long x$3) {
                            return this.apply$mcZJ$sp(x$3);
                        }

                        public boolean apply$mcZJ$sp(long x$3) {
                            return x$3 >= 0L;
                        }
                    });
                    if (validValues.isEmpty()) {
                        seq2 = (Seq)Seq$.MODULE$.fill(4, (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        });
                    } else {
                        Seq sorted = (Seq)validValues.sorted((Ordering)Ordering.Long$.MODULE$);
                        seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)sorted.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), BoxesRunTime.unboxToLong((Object)sorted.apply(0)), BoxesRunTime.unboxToLong((Object)sorted.apply(validValues.length() / 2)), BoxesRunTime.unboxToLong((Object)sorted.apply(validValues.length() - 1))}));
                    }
                    Seq metric = seq2;
                    seq = (Seq)metric.map((Function1)strFormat, Seq$.MODULE$.canBuildFrom());
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block14;
                    String sum = (String)((SeqLike)some.get()).apply(0);
                    String min = (String)((SeqLike)some.get()).apply(1);
                    String med = (String)((SeqLike)some.get()).apply(2);
                    String max = (String)((SeqLike)some.get()).apply(3);
                    Tuple4 tuple42 = tuple4 = new Tuple4((Object)sum, (Object)min, (Object)med, (Object)max);
                    String sum2 = (String)tuple42._1();
                    String min3 = (String)tuple42._2();
                    String med3 = (String)tuple42._3();
                    String max3 = (String)tuple42._4();
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", " (", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sum2, min3, med3, max3}));
                }
                return string;
            }
            throw new MatchError((Object)seq);
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"unexpected metrics type: ").append((Object)metricsType).toString());
    }

    public void postDriverMetricUpdates(SparkContext sc, String executionId, Seq<SQLMetric> metrics2) {
        if (executionId != null) {
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(new StringOps(Predef$.MODULE$.augmentString(executionId)).toLong(), (Seq<Tuple2<Object, Object>>)((Seq)metrics2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(SQLMetric m) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)m.id())), (Object)BoxesRunTime.boxToLong((long)m.value()));
                }
            }, Seq$.MODULE$.canBuildFrom()))));
        }
    }

    private SQLMetrics$() {
        MODULE$ = this;
        this.SUM_METRIC = "sum";
        this.SIZE_METRIC = "size";
        this.TIMING_METRIC = "timing";
        this.AVERAGE_METRIC = "average";
        this.org$apache$spark$sql$execution$metric$SQLMetrics$$baseForAvgMetric = 10;
    }
}

