/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.TempTableAlreadyExistsException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001=\u0011Qc\u00127pE\u0006dG+Z7q-&,w/T1oC\u001e,'O\u0003\u0002\u0004\t\u000591-\u0019;bY><'BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\u0005eCR\f'-Y:f+\u0005I\u0002C\u0001\u000e\u001e\u001d\t\t2$\u0003\u0002\u001d%\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\ta\"\u0003\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001a\u0003%!\u0017\r^1cCN,\u0007\u0005C\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0003K\u001d\u0002\"A\n\u0001\u000e\u0003\tAQa\u0006\u0012A\u0002eAq!\u000b\u0001C\u0002\u0013%!&A\bwS\u0016<H)\u001a4j]&$\u0018n\u001c8t+\u0005Y\u0003\u0003\u0002\u001723Mj\u0011!\f\u0006\u0003]=\nq!\\;uC\ndWM\u0003\u00021%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ij#a\u0002%bg\"l\u0015\r\u001d\t\u0003iej\u0011!\u000e\u0006\u0003m]\nq\u0001\\8hS\u000e\fGN\u0003\u00029\t\u0005)\u0001\u000f\\1og&\u0011!(\u000e\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0003\u0004=\u0001\u0001\u0006IaK\u0001\u0011m&,w\u000fR3gS:LG/[8og\u0002BCa\u000f I\u0013B\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u000bG>t7-\u001e:sK:$(BA\"E\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002\u000b\u0006)!.\u0019<bq&\u0011q\t\u0011\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013AS\u0001\u0005i\"L7\u000fC\u0003M\u0001\u0011\u0005Q*A\u0002hKR$\"AT)\u0011\u0007Ey5'\u0003\u0002Q%\t1q\n\u001d;j_:DQAU&A\u0002e\tAA\\1nK\")A\u000b\u0001C\u0001+\u000611M]3bi\u0016$BAV-[9B\u0011\u0011cV\u0005\u00031J\u0011A!\u00168ji\")!k\u0015a\u00013!)1l\u0015a\u0001g\u0005qa/[3x\t\u00164\u0017N\\5uS>t\u0007\"B/T\u0001\u0004q\u0016\u0001E8wKJ\u0014\u0018\u000eZ3JM\u0016C\u0018n\u001d;t!\t\tr,\u0003\u0002a%\t9!i\\8mK\u0006t\u0007\"\u00022\u0001\t\u0003\u0019\u0017AB;qI\u0006$X\rF\u0002_I\u0016DQAU1A\u0002eAQaW1A\u0002MBQa\u001a\u0001\u0005\u0002!\faA]3n_Z,GC\u00010j\u0011\u0015\u0011f\r1\u0001\u001a\u0011\u0015Y\u0007\u0001\"\u0001m\u0003\u0019\u0011XM\\1nKR\u0019a,\\8\t\u000b9T\u0007\u0019A\r\u0002\u000f=dGMT1nK\")\u0001O\u001ba\u00013\u00059a.Z<OC6,\u0007\"\u0002:\u0001\t\u0003\u0019\u0018!\u00047jgR4\u0016.Z<OC6,7\u000fF\u0002u\u0003\u0003\u00012!^?\u001a\u001d\t18P\u0004\u0002xu6\t\u0001P\u0003\u0002z\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003yJ\tq\u0001]1dW\u0006<W-\u0003\u0002\u007f\u007f\n\u00191+Z9\u000b\u0005q\u0014\u0002BBA\u0002c\u0002\u0007\u0011$A\u0004qCR$XM\u001d8\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u0005)1\r\\3beR\ta\u000b")
public class GlobalTempViewManager {
    private final String database;
    @GuardedBy(value="this")
    private final HashMap<String, LogicalPlan> viewDefinitions;

    public String database() {
        return this.database;
    }

    private HashMap<String, LogicalPlan> viewDefinitions() {
        return this.viewDefinitions;
    }

    public synchronized Option<LogicalPlan> get(String name2) {
        return this.viewDefinitions().get((Object)name2);
    }

    public void create(String name2, LogicalPlan viewDefinition, boolean overrideIfExists) {
        GlobalTempViewManager globalTempViewManager = this;
        synchronized (globalTempViewManager) {
            if (!overrideIfExists && this.viewDefinitions().contains((Object)name2)) {
                throw new TempTableAlreadyExistsException(name2);
            }
            this.viewDefinitions().put((Object)name2, (Object)viewDefinition);
            return;
        }
    }

    public synchronized boolean update(String name2, LogicalPlan viewDefinition) {
        boolean bl;
        if (this.viewDefinitions().contains((Object)name2)) {
            this.viewDefinitions().put((Object)name2, (Object)viewDefinition);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean remove(String name2) {
        return this.viewDefinitions().remove((Object)name2).isDefined();
    }

    public synchronized boolean rename(String oldName, String newName) {
        boolean bl;
        if (this.viewDefinitions().contains((Object)oldName)) {
            if (this.viewDefinitions().contains((Object)newName)) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rename temporary view from '", "' to '", "': destination view already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldName, newName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            LogicalPlan viewDefinition = (LogicalPlan)this.viewDefinitions().apply((Object)oldName);
            this.viewDefinitions().remove((Object)oldName);
            this.viewDefinitions().put((Object)newName, (Object)viewDefinition);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized Seq<String> listViewNames(String pattern) {
        return StringUtils$.MODULE$.filterPattern((Seq<String>)this.viewDefinitions().keys().toSeq(), pattern);
    }

    public synchronized void clear() {
        this.viewDefinitions().clear();
    }

    public GlobalTempViewManager(String database2) {
        this.database = database2;
        this.viewDefinitions = new HashMap();
    }
}

