/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.servlets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.spark_project.jetty.util.IO;
import org.spark_project.jetty.util.StringUtil;
import org.spark_project.jetty.util.URIUtil;

public class PutFilter
implements Filter {
    public static final String __PUT = "PUT";
    public static final String __DELETE = "DELETE";
    public static final String __MOVE = "MOVE";
    public static final String __OPTIONS = "OPTIONS";
    Set<String> _operations = new HashSet<String>();
    private ConcurrentMap<String, String> _hidden = new ConcurrentHashMap<String, String>();
    private ServletContext _context;
    private String _baseURI;
    private boolean _delAllowed;
    private boolean _putAtomic;
    private File _tmpdir;

    public void init(FilterConfig config2) throws ServletException {
        this._context = config2.getServletContext();
        this._tmpdir = (File)this._context.getAttribute("javax.servlet.context.tempdir");
        if (this._context.getRealPath("/") == null) {
            throw new UnavailableException("Packed war");
        }
        String b = config2.getInitParameter("baseURI");
        if (b != null) {
            this._baseURI = b;
        } else {
            File base = new File(this._context.getRealPath("/"));
            this._baseURI = base.toURI().toString();
        }
        this._delAllowed = this.getInitBoolean(config2, "delAllowed");
        this._putAtomic = this.getInitBoolean(config2, "putAtomic");
        this._operations.add(__OPTIONS);
        this._operations.add(__PUT);
        if (this._delAllowed) {
            this._operations.add(__DELETE);
            this._operations.add(__MOVE);
        }
    }

    private boolean getInitBoolean(FilterConfig config2, String name2) {
        String value2 = config2.getInitParameter(name2);
        return value2 != null && value2.length() > 0 && (value2.startsWith("t") || value2.startsWith("T") || value2.startsWith("y") || value2.startsWith("Y") || value2.startsWith("1"));
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block11: {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String servletPath = request.getServletPath();
            String pathInfo = request.getPathInfo();
            String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
            String resource = URIUtil.addPaths(this._baseURI, pathInContext);
            String method = request.getMethod();
            boolean op = this._operations.contains(method);
            if (op) {
                File file = null;
                try {
                    if (method.equals(__OPTIONS)) {
                        this.handleOptions(chain, request, response);
                        break block11;
                    }
                    file = new File(new URI(resource));
                    boolean exists = file.exists();
                    if (exists && !this.passConditionalHeaders(request, response, file)) {
                        return;
                    }
                    if (method.equals(__PUT)) {
                        this.handlePut(request, response, pathInContext, file);
                        break block11;
                    }
                    if (method.equals(__DELETE)) {
                        this.handleDelete(request, response, pathInContext, file);
                        break block11;
                    }
                    if (method.equals(__MOVE)) {
                        this.handleMove(request, response, pathInContext, file);
                        break block11;
                    }
                    throw new IllegalStateException();
                }
                catch (Exception e) {
                    this._context.log(e.toString(), (Throwable)e);
                    response.sendError(500);
                }
            } else {
                if (this.isHidden(pathInContext)) {
                    response.sendError(404);
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                return;
            }
        }
    }

    private boolean isHidden(String pathInContext) {
        return this._hidden.containsKey(pathInContext);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePut(HttpServletRequest request, HttpServletResponse response, String pathInContext, File file) throws ServletException, IOException {
        boolean exists = file.exists();
        if (pathInContext.endsWith("/")) {
            if (!exists) {
                if (!file.mkdirs()) {
                    response.sendError(403);
                } else {
                    response.setStatus(201);
                    response.flushBuffer();
                }
            } else {
                response.setStatus(200);
                response.flushBuffer();
            }
        } else {
            boolean ok = false;
            try {
                this._hidden.put(pathInContext, pathInContext);
                File parent = file.getParentFile();
                parent.mkdirs();
                int toRead = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                if (this._putAtomic) {
                    File tmp = File.createTempFile(file.getName(), null, this._tmpdir);
                    try (FileOutputStream out = new FileOutputStream(tmp, false);){
                        if (toRead >= 0) {
                            IO.copy((InputStream)in, out, (long)toRead);
                        } else {
                            IO.copy((InputStream)in, out);
                        }
                    }
                    if (!tmp.renameTo(file)) {
                        throw new IOException("rename from " + tmp + " to " + file + " failed");
                    }
                } else {
                    try (FileOutputStream out = new FileOutputStream(file, false);){
                        if (toRead >= 0) {
                            IO.copy((InputStream)in, out, (long)toRead);
                        } else {
                            IO.copy((InputStream)in, out);
                        }
                    }
                }
                response.setStatus(exists ? 200 : 201);
                response.flushBuffer();
                ok = true;
            }
            catch (Exception ex) {
                this._context.log(ex.toString(), (Throwable)ex);
                response.sendError(403);
            }
            finally {
                if (!ok) {
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                    catch (Exception e) {
                        this._context.log(e.toString(), (Throwable)e);
                    }
                }
                this._hidden.remove(pathInContext);
            }
        }
    }

    public void handleDelete(HttpServletRequest request, HttpServletResponse response, String pathInContext, File file) throws ServletException, IOException {
        try {
            if (file.delete()) {
                response.setStatus(204);
                response.flushBuffer();
            } else {
                response.sendError(403);
            }
        }
        catch (SecurityException sex) {
            this._context.log(sex.toString(), (Throwable)sex);
            response.sendError(403);
        }
    }

    public void handleMove(HttpServletRequest request, HttpServletResponse response, String pathInContext, File file) throws ServletException, IOException, URISyntaxException {
        String newPath = URIUtil.canonicalPath(request.getHeader("new-uri"));
        if (newPath == null) {
            response.sendError(400);
            return;
        }
        String contextPath = request.getContextPath();
        if (contextPath != null && !newPath.startsWith(contextPath)) {
            response.sendError(405);
            return;
        }
        String newInfo = newPath;
        if (contextPath != null) {
            newInfo = newInfo.substring(contextPath.length());
        }
        String new_resource = URIUtil.addPaths(this._baseURI, newInfo);
        File new_file = new File(new URI(new_resource));
        file.renameTo(new_file);
        response.setStatus(204);
        response.flushBuffer();
    }

    public void handleOptions(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        chain.doFilter((ServletRequest)request, (ServletResponse)new HttpServletResponseWrapper(response){

            public void setHeader(String name2, String value2) {
                if ("Allow".equalsIgnoreCase(name2)) {
                    HashSet<String> options = new HashSet<String>();
                    options.addAll(Arrays.asList(StringUtil.csvSplit(value2)));
                    options.addAll(PutFilter.this._operations);
                    value2 = null;
                    for (String o : options) {
                        value2 = value2 == null ? o : value2 + ", " + o;
                    }
                }
                super.setHeader(name2, value2);
            }
        });
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        long date = 0L;
        date = request.getDateHeader("if-unmodified-since");
        if (date > 0L && file.lastModified() / 1000L > date / 1000L) {
            response.sendError(412);
            return false;
        }
        date = request.getDateHeader("if-modified-since");
        if (date > 0L && file.lastModified() / 1000L <= date / 1000L) {
            response.reset();
            response.setStatus(304);
            response.flushBuffer();
            return false;
        }
        return true;
    }
}

