/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.sql.SqlKind;

public class UnionToDistinctRule
extends RelOptRule {
    public static final UnionToDistinctRule INSTANCE = new UnionToDistinctRule(LogicalUnion.class, RelFactories.DEFAULT_SET_OP_FACTORY);
    private final RelFactories.SetOpFactory setOpFactory;

    public UnionToDistinctRule(Class<? extends Union> clazz, RelFactories.SetOpFactory setOpFactory) {
        super(UnionToDistinctRule.operand(clazz, UnionToDistinctRule.any()));
        this.setOpFactory = setOpFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Union union = (Union)call.rel(0);
        if (union.all) {
            return;
        }
        RelNode unionAll = this.setOpFactory.createSetOp(SqlKind.UNION, union.getInputs(), true);
        call.transformTo(RelOptUtil.createDistinctRel(unionAll));
    }
}

